/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.text.edits.TextEditGroup;

public class ModifierRewrite {
    private static final int VISIBILITY_MODIFIERS = 7;
    private ListRewrite fModifierRewrite;
    private AST fAst;

    public static ModifierRewrite create(ASTRewrite rewrite, ASTNode declNode) {
        return new ModifierRewrite(rewrite, declNode);
    }

    private ModifierRewrite(ASTRewrite rewrite, ASTNode declNode) {
        this.fModifierRewrite = this.evaluateListRewrite(rewrite, declNode);
        this.fAst = declNode.getAST();
    }

    private ListRewrite evaluateListRewrite(ASTRewrite rewrite, ASTNode declNode) {
        switch (declNode.getNodeType()) {
            case 31: {
                return rewrite.getListRewrite(declNode, MethodDeclaration.MODIFIERS2_PROPERTY);
            }
            case 23: {
                return rewrite.getListRewrite(declNode, FieldDeclaration.MODIFIERS2_PROPERTY);
            }
            case 58: {
                return rewrite.getListRewrite(declNode, VariableDeclarationExpression.MODIFIERS2_PROPERTY);
            }
            case 60: {
                return rewrite.getListRewrite(declNode, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
            }
            case 44: {
                return rewrite.getListRewrite(declNode, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            }
            case 55: {
                return rewrite.getListRewrite(declNode, TypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 71: {
                return rewrite.getListRewrite(declNode, EnumDeclaration.MODIFIERS2_PROPERTY);
            }
            case 81: {
                return rewrite.getListRewrite(declNode, AnnotationTypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 72: {
                return rewrite.getListRewrite(declNode, EnumConstantDeclaration.MODIFIERS2_PROPERTY);
            }
            case 82: {
                return rewrite.getListRewrite(declNode, AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY);
            }
        }
        throw new IllegalArgumentException("node has no modifiers: " + declNode.getClass().getName());
    }

    public ListRewrite getModifierRewrite() {
        return this.fModifierRewrite;
    }

    public void setModifiers(int modfiers, TextEditGroup editGroup) {
        this.internalSetModifiers(modfiers, -1, editGroup);
    }

    public void setModifiers(int included, int excluded, TextEditGroup editGroup) {
        this.internalSetModifiers(included, included | excluded, editGroup);
    }

    public void setVisibility(int visibilityFlags, TextEditGroup editGroup) {
        this.internalSetModifiers(visibilityFlags, 7, editGroup);
    }

    public void copyAllModifiers(ASTNode otherDecl, TextEditGroup editGroup) {
        ListRewrite modifierList = this.evaluateListRewrite(this.fModifierRewrite.getASTRewrite(), otherDecl);
        List originalList = modifierList.getOriginalList();
        if (originalList.isEmpty()) {
            return;
        }
        ASTNode copy = modifierList.createCopyTarget((ASTNode)originalList.get(0), (ASTNode)originalList.get(originalList.size() - 1));
        if (copy != null) {
            this.fModifierRewrite.insertLast(copy, editGroup);
        }
    }

    private void internalSetModifiers(int modfiers, int consideredFlags, TextEditGroup editGroup) {
        int newModifiers = modfiers & consideredFlags;
        List originalList = this.fModifierRewrite.getOriginalList();
        int i = 0;
        while (i < originalList.size()) {
            int flag;
            ASTNode curr = (ASTNode)originalList.get(i);
            if (curr instanceof Modifier && (consideredFlags & (flag = ((Modifier)curr).getKeyword().toFlagValue())) != 0) {
                if ((newModifiers & flag) == 0) {
                    this.fModifierRewrite.remove(curr, editGroup);
                }
                newModifiers &= ~flag;
            }
            ++i;
        }
        IExtendedModifier lastAnnotation = null;
        List extendedList = this.fModifierRewrite.getRewrittenList();
        int i2 = 0;
        while (i2 < extendedList.size()) {
            IExtendedModifier curr = (IExtendedModifier)extendedList.get(i2);
            if (curr.isAnnotation()) {
                lastAnnotation = curr;
            }
            ++i2;
        }
        List newNodes = ASTNodeFactory.newModifiers(this.fAst, newModifiers);
        int i3 = 0;
        while (i3 < newNodes.size()) {
            Modifier curr = (Modifier)newNodes.get(i3);
            if ((curr.getKeyword().toFlagValue() & 7) != 0) {
                if (lastAnnotation != null) {
                    this.fModifierRewrite.insertAfter((ASTNode)curr, (ASTNode)lastAnnotation, editGroup);
                } else {
                    this.fModifierRewrite.insertFirst((ASTNode)curr, editGroup);
                }
            } else {
                this.fModifierRewrite.insertLast((ASTNode)curr, editGroup);
            }
            ++i3;
        }
    }
}

