/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.model;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;

public abstract class RuntimeDelegate {
    private Runtime runtime;
    private RuntimeWorkingCopy runtimeWC;

    final void initialize(Runtime newRuntime, IProgressMonitor monitor) {
        this.runtime = newRuntime;
        if (this.runtime instanceof RuntimeWorkingCopy) {
            this.runtimeWC = (RuntimeWorkingCopy)this.runtime;
        }
        this.initialize();
    }

    protected void initialize() {
    }

    public final IRuntime getRuntime() {
        return this.runtime;
    }

    public final IRuntimeWorkingCopy getRuntimeWorkingCopy() {
        return this.runtimeWC;
    }

    public IStatus validate() {
        if (this.runtime.getName() == null || this.runtime.getName().length() == 0) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorRuntimeName, null);
        }
        if (this.isNameInUse()) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorDuplicateRuntimeName, null);
        }
        IPath path = this.runtime.getLocation();
        if (path == null || path.isEmpty()) {
            return new Status(4, "org.eclipse.wst.server.core", 0, "", null);
        }
        return Status.OK_STATUS;
    }

    private boolean isNameInUse() {
        IRuntime[] runtimes;
        IRuntime orig = this.runtime;
        if (this.runtimeWC != null) {
            orig = this.runtimeWC.getOriginal();
        }
        if ((runtimes = ServerCore.getRuntimes()) != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                if (orig != runtimes[i] && this.runtime.getName().equals(runtimes[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected final int getAttribute(String id, int defaultValue) {
        return this.runtime.getAttribute(id, defaultValue);
    }

    protected final boolean getAttribute(String id, boolean defaultValue) {
        return this.runtime.getAttribute(id, defaultValue);
    }

    protected final String getAttribute(String id, String defaultValue) {
        return this.runtime.getAttribute(id, defaultValue);
    }

    protected final List getAttribute(String id, List defaultValue) {
        return this.runtime.getAttribute(id, defaultValue);
    }

    protected final Map getAttribute(String id, Map defaultValue) {
        return this.runtime.getAttribute(id, defaultValue);
    }

    public void dispose() {
    }

    public void setDefaults(IProgressMonitor monitor) {
    }

    protected final void setAttribute(String id, int value) {
        this.runtimeWC.setAttribute(id, value);
    }

    protected final void setAttribute(String id, boolean value) {
        this.runtimeWC.setAttribute(id, value);
    }

    protected final void setAttribute(String id, String value) {
        this.runtimeWC.setAttribute(id, value);
    }

    protected final void setAttribute(String id, List value) {
        this.runtimeWC.setAttribute(id, value);
    }

    protected final void setAttribute(String id, Map value) {
        this.runtimeWC.setAttribute(id, value);
    }
}

