/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class UrlCombo
extends Composite {
    private Combo combo;
    private IDialogSettings settings;
    private String project;
    private static final int URL_WIDTH_HINT = 450;

    public UrlCombo(Composite parent, String project) {
        super(parent, 0);
        this.project = project;
        this.createCombo();
    }

    private void createCombo() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.combo = new Combo((Composite)this, 2048);
        GridData data = new GridData();
        data.widthHint = 450;
        this.combo.setLayoutData((Object)data);
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        int i = 0;
        while (i < 5) {
            String url = this.settings.get("UrlCombo." + this.project + "." + i);
            if (url == null) break;
            this.combo.add(url);
            ++i;
        }
    }

    public Combo getCombo() {
        return this.combo;
    }

    public String getText() {
        return this.combo.getText().trim();
    }

    public void setText(String text) {
        this.combo.setText(text);
    }

    public void saveUrl() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.getText());
        int i = 0;
        while (i < 5) {
            String url = this.settings.get("UrlCombo." + this.project + "." + i);
            if (url == null) break;
            if (!urls.contains(url)) {
                urls.add(url);
            }
            ++i;
        }
        i = 0;
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            String url = (String)iter.next();
            this.settings.put("UrlCombo." + this.project + "." + i++, url);
            if (i == 5) break;
        }
    }
}

