/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.model;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.rubypeople.rdt.internal.debug.core.RubyDebuggerProxy;
import org.rubypeople.rdt.internal.debug.core.model.RubyThread;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;

public class RubyStackFrame
extends PlatformObject
implements IStackFrame {
    private RubyThread thread;
    private String file;
    private int lineNumber;
    private int index;
    private RubyVariable[] variables;

    public RubyStackFrame(RubyThread rubyThread, String string, int n, int n2) {
        this.lineNumber = n;
        this.index = n2;
        this.file = string;
        this.thread = rubyThread;
    }

    public IThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread rubyThread) {
        this.thread = rubyThread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.variables == null) {
            this.variables = this.getRubyDebuggerProxy().readVariables(this);
        }
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        if (this.variables == null) {
            return false;
        }
        return this.variables.length > 0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() {
        return String.valueOf(this.file) + ":" + this.getLineNumber();
    }

    public String getFileName() {
        return this.file;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public String getModelIdentifier() {
        return this.getThread().getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.getThread().getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public boolean canStepInto() {
        return this.canResume();
    }

    public boolean canStepOver() {
        return this.canResume();
    }

    public boolean canStepReturn() {
        return this.canResume();
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
        this.thread.prepareForResume();
        this.getRubyDebuggerProxy().readStepIntoEnd(this);
        DebugEvent debugEvent = new DebugEvent((Object)this.getThread(), 1, 1);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
    }

    public void stepOver() throws DebugException {
        this.thread.prepareForResume();
        this.getRubyDebuggerProxy().readStepOverEnd(this);
        DebugEvent debugEvent = new DebugEvent((Object)this.getThread(), 1, 2);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
    }

    public void stepReturn() throws DebugException {
        this.thread.prepareForResume();
        this.getRubyDebuggerProxy().readStepReturnEnd(this);
        DebugEvent debugEvent = new DebugEvent((Object)this.getThread(), 1, 4);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public int getIndex() {
        return this.index;
    }

    public RubyDebuggerProxy getRubyDebuggerProxy() {
        return this.thread.getRubyDebuggerProxy();
    }
}

