/***************************************************************************
                           cplugin.h  -  description
                             -------------------
    begin                : Fri Sep 27 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CPLUGIN_H
#define CPLUGIN_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cobject.h>

typedef enum ePluginType {
	eptNONE,
	eptLIB,
	eptGUI
} ePluginType;

class CPlugin;
class CPluginManager;
class _CCallback;

class DLL_EXPORT CPlugin : public CObject {
public:
	/** */
	CPlugin();
	/** */
	virtual ~CPlugin();

	/** init function */
	virtual bool Init() = 0;

protected:
	/** */
	virtual int PluginCallback( CObject *, CObject *) { return 0; };
};

class CManager;
class CDownloadManager;
class CConnectionManager;
class CConfig;
class CFileManager;

class DLL_EXPORT CPluginInstance : public CObject {
public:
	CConfig * m_pConfig;
	CManager * m_pManager;
	CDownloadManager * m_pDownloadManager;
	CConnectionManager * m_pConnectionManager;
	CFileManager * m_pFileManager;
};

typedef struct ePluginStruct {
	/** */
	CPlugin * m_pPlugin;
	/** */
	CPluginInstance * m_pPluginInstance;
	/** */
	void (*init) (void);
	/** */
	void (*deinit) (void);
	/** */
	ePluginType m_eType;

} ePluginStruct;

#endif
