require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_DB_MACHDEP_H_)) {
    eval 'sub _ARM_DB_MACHDEP_H_ () {1;}' unless defined(&_ARM_DB_MACHDEP_H_);
    require 'uvm/uvm_extern.ph';
    require 'arm/armreg.ph';
    require 'machine/frame.ph';
    require 'machine/trap.ph';
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub PC_REGS {
        my($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> &tf_pc));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        my($regs, $value) = @_;
	    eval q(($regs)-> &tf_pc = ( &register_t)($value));
    }' unless defined(&SET_PC_REGS);
    eval 'sub BKPT_INST () {( &KERNEL_BREAKPOINT);}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {( &INSN_SIZE);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        my($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub T_BREAKPOINT () {(1);}' unless defined(&T_BREAKPOINT);
    eval 'sub IS_BREAKPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_BREAKPOINT));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((0));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub inst_trap_return {
        my($ins) = @_;
	    eval q((0));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        my($ins) = @_;
	    eval q(((($ins) & 0xe108000) == 0x8108000 || (($ins) & 0xff0fff0) == 0x1a0f000));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        my($ins) = @_;
	    eval q(((($ins) & 0xf000000) == 0xb000000));
    }' unless defined(&inst_call);
    eval 'sub inst_branch {
        my($ins) = @_;
	    eval q(((($ins) & 0xf000000) == 0xa000000 || (($ins) & 0xfdffff0) == 0x79ff100));
    }' unless defined(&inst_branch);
    eval 'sub inst_unconditional_flow_transfer {
        my($ins) = @_;
	    eval q((((($ins) &  &INSN_COND_MASK) ==  &INSN_COND_AL)  && ( &inst_branch($ins) ||  &inst_call($ins) ||  &inst_return($ins))));
    }' unless defined(&inst_unconditional_flow_transfer);
    eval 'sub getreg_val () {(0);}' unless defined(&getreg_val);
    eval 'sub next_instr_address {
        my($pc, $bd) = @_;
	    eval q((($bd) ? ($pc) : (($pc) +  &INSN_SIZE)));
    }' unless defined(&next_instr_address);
    eval 'sub DB_MACHINE_COMMANDS () {1;}' unless defined(&DB_MACHINE_COMMANDS);
    eval 'sub SOFTWARE_SSTEP () {1;}' unless defined(&SOFTWARE_SSTEP);
    eval 'sub branch_taken {
        my($ins, $pc, $fun, $regs) = @_;
	    eval q( &db_branch_taken(($ins), ($pc), ($regs)));
    }' unless defined(&branch_taken);
}
1;
