require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sys/stat.ph';
require 'ufs/ufs/dinode.ph';
eval 'sub EXT2_ROOTINO () {(( &ufsino_t)2);}' unless defined(&EXT2_ROOTINO);
eval 'sub EXT2_RESIZEINO () {(( &ufsino_t)7);}' unless defined(&EXT2_RESIZEINO);
eval 'sub EXT2_FIRSTINO () {(( &ufsino_t)11);}' unless defined(&EXT2_FIRSTINO);
eval 'sub NDADDR () {12;}' unless defined(&NDADDR);
eval 'sub NIADDR () {3;}' unless defined(&NIADDR);
eval 'sub EXT2_MAXSYMLINKLEN () {(( &NDADDR+ &NIADDR) * $sizeof{ &u_int32_t});}' unless defined(&EXT2_MAXSYMLINKLEN);
eval 'sub E2MAXSYMLINKLEN () {(( &NDADDR +  &NIADDR) * $sizeof{ &u_int32_t});}' unless defined(&E2MAXSYMLINKLEN);
eval 'sub EXT2_IEXEC () {0000100;}' unless defined(&EXT2_IEXEC);
eval 'sub EXT2_IWRITE () {0000200;}' unless defined(&EXT2_IWRITE);
eval 'sub EXT2_IREAD () {0000400;}' unless defined(&EXT2_IREAD);
eval 'sub EXT2_ISVTX () {0001000;}' unless defined(&EXT2_ISVTX);
eval 'sub EXT2_ISGID () {0002000;}' unless defined(&EXT2_ISGID);
eval 'sub EXT2_ISUID () {0004000;}' unless defined(&EXT2_ISUID);
eval 'sub EXT2_IFMT () {0170000;}' unless defined(&EXT2_IFMT);
eval 'sub EXT2_IFIFO () {0010000;}' unless defined(&EXT2_IFIFO);
eval 'sub EXT2_IFCHR () {0020000;}' unless defined(&EXT2_IFCHR);
eval 'sub EXT2_IFDIR () {0040000;}' unless defined(&EXT2_IFDIR);
eval 'sub EXT2_IFBLK () {0060000;}' unless defined(&EXT2_IFBLK);
eval 'sub EXT2_IFREG () {0100000;}' unless defined(&EXT2_IFREG);
eval 'sub EXT2_IFLNK () {0120000;}' unless defined(&EXT2_IFLNK);
eval 'sub EXT2_IFSOCK () {0140000;}' unless defined(&EXT2_IFSOCK);
eval 'sub EXT2_SECRM () {0x1;}' unless defined(&EXT2_SECRM);
eval 'sub EXT2_UNRM () {0x2;}' unless defined(&EXT2_UNRM);
eval 'sub EXT2_COMPR () {0x4;}' unless defined(&EXT2_COMPR);
eval 'sub EXT2_SYNC () {0x8;}' unless defined(&EXT2_SYNC);
eval 'sub EXT2_IMMUTABLE () {0x10;}' unless defined(&EXT2_IMMUTABLE);
eval 'sub EXT2_APPEND () {0x20;}' unless defined(&EXT2_APPEND);
eval 'sub EXT2_NODUMP () {0x40;}' unless defined(&EXT2_NODUMP);
eval 'sub EXT2_NOATIME () {0x80;}' unless defined(&EXT2_NOATIME);
eval 'sub EXT4_INDEX () {0x1000;}' unless defined(&EXT4_INDEX);
eval 'sub EXT4_JOURNAL_DATA () {0x4000;}' unless defined(&EXT4_JOURNAL_DATA);
eval 'sub EXT4_DIRSYNC () {0x10000;}' unless defined(&EXT4_DIRSYNC);
eval 'sub EXT4_TOPDIR () {0x20000;}' unless defined(&EXT4_TOPDIR);
eval 'sub EXT4_HUGE_FILE () {0x40000;}' unless defined(&EXT4_HUGE_FILE);
eval 'sub EXT4_EXTENTS () {0x80000;}' unless defined(&EXT4_EXTENTS);
eval 'sub EXT4_EOFBLOCKS () {0x400000;}' unless defined(&EXT4_EOFBLOCKS);
eval 'sub EXT2_REV0_DINODE_SIZE () {128;}' unless defined(&EXT2_REV0_DINODE_SIZE);
unless(defined(&EXT2_DINODE_SIZE)) {
    sub EXT2_DINODE_SIZE {
	my($fs) = @_;
	eval q((($fs)-> ($e2fs->{e2fs_rev}) >  &E2FS_REV0 ? ($fs)-> ($e2fs->{e2fs_inode_size}) :  &EXT2_REV0_DINODE_SIZE));
    }
}
eval 'sub e2di_rdev () { $e2di_blocks[0];}' unless defined(&e2di_rdev);
eval 'sub e2di_shortlink () { &e2di_blocks;}' unless defined(&e2di_shortlink);
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
    eval 'sub e2fs_iload {
        my($fs, $old, $new) = @_;
	    eval q( &memcpy(($new),($old),  &MIN( &EXT2_DINODE_SIZE($fs), $sizeof{$new})));
    }' unless defined(&e2fs_iload);
    eval 'sub e2fs_isave {
        my($fs, $old, $new) = @_;
	    eval q( &memcpy(($new),($old),  &MIN( &EXT2_DINODE_SIZE($fs), $sizeof{$new})));
    }' unless defined(&e2fs_isave);
} else {
    eval 'sub e2fs_iload {
        my($fs, $old, $new) = @_;
	    eval q( &e2fs_i_bswap(($fs), ($old), ($new)));
    }' unless defined(&e2fs_iload);
    eval 'sub e2fs_isave {
        my($fs, $old, $new) = @_;
	    eval q( &e2fs_i_bswap(($fs), ($old), ($new)));
    }' unless defined(&e2fs_isave);
}
1;
