#!/usr/bin/perl
##############################################################################
# RackMonkey - Know Your Racks - http://www.rackmonkey.org                   #
# Version 1.2.5-1                                                            #
# (C)2004-2009 Will Green (wgreen at users.sourceforge.net)                  #
# RackMonkey DNS Query Script                                                #
##############################################################################

# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details.

# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

use strict;
use warnings;

use 5.006_001;

use Net::DNS;

use RackMonkey::CGI;

our $VERSION = '1.2.5-1';
our $AUTHOR  = 'Will Green (wgreen at users.sourceforge.net)';

my $cgi = new RackMonkey::CGI;
print $cgi->header('text/plain');
my $domain = $cgi->queryOn;

my $res   = Net::DNS::Resolver->new;
my $query;

# A record query
print "A Records\n=========\n";
$query = $res->search("$domain");
if ($query)
{
    foreach my $rr ($query->answer)
    {
        next unless $rr->type eq "A";
        print $rr->name.'    '.$rr->ttl.'    '.$rr->class.'    '.$rr->type.'    '.$rr->address."\n";
    }
}
else
{
    print "DNS 'A' record query failed: ", $res->errorstring, "\n";
}

# CNAME record query
print "\nCNAME Records\n=============\n";
$query = $res->search("$domain", 'CNAME');
if ($query)
{
    foreach my $rr ($query->answer)
    {
        next unless $rr->type eq "CNAME";
        print $rr->name.'    '.$rr->ttl.'    '.$rr->class.'    '.$rr->type.'    '.$rr->cname."\n";
    }
}
else
{
    print "DNS 'cname' record query failed: ", $res->errorstring, "\n";
}

# MX record query
print "\nMX Records\n==========\n";
$query = $res->search("$domain", 'MX');
if ($query)
{
    foreach my $rr ($query->answer)
    {
        next unless $rr->type eq "MX";
        print $rr->name.'    '.$rr->ttl.'    '.$rr->class.'    '.$rr->type.'    '.$rr->preference.'    '.$rr->exchange."\n";
    }
}
else
{
    print "DNS 'MX' record query failed: ", $res->errorstring, "\n";
}

print "\nPlease use the back button to return to the main RackMonkey application.\n";

my ($minute, $hour, $day, $month, $year) = (gmtime)[1, 2, 3, 4, 5];
my $currentDate = sprintf("%04d-%02d-%02d %02d:%02d GMT", $year + 1900, $month + 1, $day, $hour, $minute);
print "\nGenerated by RackMonkey $VERSION at $currentDate.";


