/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType<T>
extends OpenType<T> {
    private static final long serialVersionUID = 720504429830309770L;
    private int dimension;
    private OpenType<?> elementType;
    private boolean primitiveArray;
    private transient Integer hashCode;
    private transient String string;
    private static final Map<OpenType<?>, ArrayType<?>> cache = new HashMap();
    private static final Map<Class<?>, ArrayType<?>> primCache = new HashMap();

    /*
     * Unable to fully structure code
     */
    private static final String getArrayClassName(OpenType<?> elementType, int dim, boolean primitive) throws OpenDataException {
        block3: {
            if (!primitive) break block3;
            type = ArrayType.getPrimitiveTypeClass((SimpleType)elementType);
            ** GOTO lbl13
        }
        className = elementType.getClassName();
        try {
            type = Class.forName(className);
            if (true) ** GOTO lbl13
        }
        catch (ClassNotFoundException v0) {
            throw new OpenDataException("The class name, " + className + ", is unavailable.");
        }
        do {
            type = type.getComponentType();
lbl13:
            // 3 sources

        } while (type.isArray());
        return Array.newInstance(type, new int[ArrayType.getDimensions(elementType, dim)]).getClass().getName();
    }

    private static final int getDimensions(OpenType<?> elementType, int dim) {
        if (dim < 1) {
            throw new IllegalArgumentException("Dimensions must be greater than or equal to 1.");
        }
        if (elementType instanceof ArrayType) {
            return dim + ((ArrayType)elementType).getDimension();
        }
        return dim;
    }

    private static final SimpleType<?> getPrimitiveType(Class<?> type) throws OpenDataException {
        if (type.equals(Boolean.TYPE)) {
            return SimpleType.BOOLEAN;
        }
        if (type.equals(Byte.TYPE)) {
            return SimpleType.BYTE;
        }
        if (type.equals(Character.TYPE)) {
            return SimpleType.CHARACTER;
        }
        if (type.equals(Double.TYPE)) {
            return SimpleType.DOUBLE;
        }
        if (type.equals(Float.TYPE)) {
            return SimpleType.FLOAT;
        }
        if (type.equals(Integer.TYPE)) {
            return SimpleType.INTEGER;
        }
        if (type.equals(Long.TYPE)) {
            return SimpleType.LONG;
        }
        if (type.equals(Short.TYPE)) {
            return SimpleType.SHORT;
        }
        if (type.equals(Void.TYPE)) {
            return SimpleType.VOID;
        }
        throw new OpenDataException(type + " is not a primitive type.");
    }

    private static final Class<?> getPrimitiveTypeClass(SimpleType<?> type) throws OpenDataException {
        if (type.equals(SimpleType.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (type.equals(SimpleType.BYTE)) {
            return Byte.TYPE;
        }
        if (type.equals(SimpleType.CHARACTER)) {
            return Character.TYPE;
        }
        if (type.equals(SimpleType.DOUBLE)) {
            return Double.TYPE;
        }
        if (type.equals(SimpleType.FLOAT)) {
            return Float.TYPE;
        }
        if (type.equals(SimpleType.INTEGER)) {
            return Integer.TYPE;
        }
        if (type.equals(SimpleType.LONG)) {
            return Long.TYPE;
        }
        if (type.equals(SimpleType.SHORT)) {
            return Short.TYPE;
        }
        if (type.equals(SimpleType.VOID)) {
            return Void.TYPE;
        }
        throw new OpenDataException(type + " is not a primitive type.");
    }

    private static final OpenType<?> getElementType(OpenType<?> elemType) {
        if (elemType instanceof ArrayType) {
            return ((ArrayType)elemType).getElementOpenType();
        }
        return elemType;
    }

    private static final String getElementTypeName(OpenType<?> elemType) throws OpenDataException {
        OpenType<?> trueElemType = ArrayType.getElementType(elemType);
        if (elemType instanceof ArrayType && ((ArrayType)elemType).isPrimitiveArray()) {
            return ArrayType.getPrimitiveTypeClass((SimpleType)trueElemType).getName();
        }
        return trueElemType.getClassName();
    }

    public ArrayType(int dim, OpenType<?> elementType) throws OpenDataException {
        super(ArrayType.getArrayClassName(elementType, dim, false), ArrayType.getArrayClassName(elementType, dim, false), String.valueOf(ArrayType.getDimensions(elementType, dim)) + "-dimension array of " + ArrayType.getElementTypeName(elementType));
        if (!(elementType instanceof SimpleType || elementType instanceof CompositeType || elementType instanceof TabularType || elementType instanceof ArrayType)) {
            throw new OpenDataException("The element type must be a simple type, an array type, a composite type or a tabular type.");
        }
        this.dimension = ArrayType.getDimensions(elementType, dim);
        this.elementType = ArrayType.getElementType(elementType);
        this.primitiveArray = elementType instanceof ArrayType && ((ArrayType)elementType).isPrimitiveArray();
    }

    public ArrayType(SimpleType<?> elementType, boolean primitiveArray) throws OpenDataException {
        super(ArrayType.getArrayClassName(elementType, 1, primitiveArray), ArrayType.getArrayClassName(elementType, 1, primitiveArray), "1-dimension array of " + (primitiveArray ? ArrayType.getPrimitiveTypeClass(elementType).getName() : elementType.getClassName()));
        this.dimension = 1;
        this.elementType = elementType;
        this.primitiveArray = primitiveArray;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ArrayType)) {
            return false;
        }
        ArrayType atype = (ArrayType)obj;
        return atype.getDimension() == this.dimension && atype.getElementOpenType().equals(this.elementType) && atype.isPrimitiveArray() == this.primitiveArray;
    }

    public static <E> ArrayType<E[]> getArrayType(OpenType<E> elementType) throws OpenDataException {
        ArrayType<Object> arr = cache.get(elementType);
        if (arr != null) {
            return arr;
        }
        arr = new ArrayType(1, elementType);
        cache.put(elementType, arr);
        return arr;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static <T> ArrayType<T> getPrimitiveArrayType(Class<T> type) {
        arr /* !! */  = ArrayType.primCache.get(type);
        if (arr /* !! */  != null) {
            return arr /* !! */ ;
        }
        comType = type;
        dim = 0;
        do {
            comType = comType.getComponentType();
            ++dim;
            if (comType != null) continue;
            throw new IllegalArgumentException("The given class is not an array.");
        } while (comType.isArray());
        try {
            arr /* !! */  = new ArrayType<T>(ArrayType.getPrimitiveType(comType), true);
            if (true) ** GOTO lbl24
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException("The array is not of a primitive type", e);
        }
        do {
            try {
                arr /* !! */  = new ArrayType<T>(1, arr /* !! */ );
                --dim;
            }
            catch (OpenDataException e) {
                throw (Error)new InternalError("Couldn't generate extra dimensions").initCause(e);
            }
lbl24:
            // 2 sources

        } while (dim > 1);
        ArrayType.primCache.put(type, arr /* !! */ );
        return arr /* !! */ ;
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType<?> getElementOpenType() {
        return this.elementType;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.dimension + this.elementType.hashCode() + Boolean.valueOf(this.primitiveArray).hashCode();
        }
        return this.hashCode;
    }

    public boolean isPrimitiveArray() {
        return this.primitiveArray;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<? extends Object> objClass = obj.getClass();
        if (!objClass.isArray()) {
            return false;
        }
        if (this.elementType instanceof SimpleType) {
            return this.getClassName().equals(objClass.getName());
        }
        Class<? extends Object> elementClass = null;
        try {
            elementClass = Class.forName(this.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The array type's element class could not be found.", e);
        }
        if (!elementClass.isAssignableFrom(objClass)) {
            return false;
        }
        int a = 0;
        while (a < Array.getLength(obj)) {
            Object elem = Array.get(obj, a);
            if (elem != null && !this.elementType.isValue(elem)) {
                return false;
            }
            ++a;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = String.valueOf(this.getClass().getName()) + "[name=" + this.getTypeName() + ", dimension=" + this.dimension + ", elementType=" + this.elementType + ", primitiveArray=" + this.primitiveArray + "]";
        }
        return this.string;
    }
}

