/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.Calendar;
import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants,
Cloneable {
    private static final byte KNOWN_SIZE = 1;
    private static final byte KNOWN_CSIZE = 2;
    private static final byte KNOWN_CRC = 4;
    private static final byte KNOWN_TIME = 8;
    private static final byte KNOWN_DOSTIME = 16;
    private static final byte KNOWN_EXTRA = 32;
    private final String name;
    private int size;
    private long compressedSize = -1L;
    private int crc;
    private String comment = null;
    private byte method = (byte)-1;
    private byte known = 0;
    private int dostime;
    private long time;
    private byte[] extra = null;
    int flags;
    int offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String name) {
        int length = name.length();
        if (length > 65535) {
            throw new IllegalArgumentException("name length is " + length);
        }
        this.name = name;
    }

    public ZipEntry(ZipEntry e) {
        this(e, e.name);
    }

    ZipEntry(ZipEntry e, String name) {
        this.name = name;
        this.known = e.known;
        this.size = e.size;
        this.compressedSize = e.compressedSize;
        this.crc = e.crc;
        this.dostime = e.dostime;
        this.time = e.time;
        this.method = e.method;
        this.extra = e.extra;
        this.comment = e.comment;
    }

    final void setDOSTime(int dostime) {
        this.dostime = dostime;
        this.known = (byte)(this.known | 0x10);
        this.known = (byte)(this.known & 0xFFFFFFF7);
    }

    final int getDOSTime() {
        if ((this.known & 0x10) != 0) {
            return this.dostime;
        }
        if ((this.known & 8) != 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(this.time);
            this.dostime = (cal.get(1) - 1980 & 0x7F) << 25 | cal.get(2) + 1 << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
            this.known = (byte)(this.known | 0x10);
            return this.dostime;
        }
        return 0;
    }

    public Object clone() {
        ZipEntry clone;
        if (this.getClass() == ZipEntry.class) {
            clone = new ZipEntry(this);
        } else {
            try {
                clone = (ZipEntry)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
        if (this.extra != null) {
            clone.extra = new byte[this.extra.length];
            System.arraycopy(this.extra, 0, clone.extra, 0, this.extra.length);
        }
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long time) {
        this.time = time;
        this.known = (byte)(this.known | 8);
        this.known = (byte)(this.known & 0xFFFFFFEF);
    }

    public long getTime() {
        this.parseExtra();
        if ((this.known & 8) != 0) {
            return this.time;
        }
        if ((this.known & 0x10) != 0) {
            int sec = 2 * (this.dostime & 0x1F);
            int min = this.dostime >> 5 & 0x3F;
            int hrs = this.dostime >> 11 & 0x1F;
            int day = this.dostime >> 16 & 0x1F;
            int mon = (this.dostime >> 21 & 0xF) - 1;
            int year = (this.dostime >> 25 & 0x7F) + 1980;
            try {
                Calendar cal = Calendar.getInstance();
                cal.set(year, mon, day, hrs, min, sec);
                this.time = cal.getTimeInMillis();
                this.known = (byte)(this.known | 8);
                return this.time;
            }
            catch (RuntimeException runtimeException) {
                this.known = (byte)(this.known & 0xFFFFFFF7);
                return -1L;
            }
        }
        return -1L;
    }

    public void setSize(long size) {
        if ((size & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.size = (int)size;
        this.known = (byte)(this.known | 1);
    }

    public long getSize() {
        return (this.known & 1) != 0 ? (long)this.size & 0xFFFFFFFFL : -1L;
    }

    public void setCompressedSize(long csize) {
        this.compressedSize = csize;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCrc(long crc) {
        if ((crc & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.crc = (int)crc;
        this.known = (byte)(this.known | 4);
    }

    public long getCrc() {
        return (this.known & 4) != 0 ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException();
        }
        this.method = (byte)method;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] extra) {
        if (extra == null) {
            this.extra = null;
            return;
        }
        if (extra.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = extra;
    }

    private void parseExtra() {
        if ((this.known & 0x20) != 0) {
            return;
        }
        if (this.extra == null) {
            this.known = (byte)(this.known | 0x20);
            return;
        }
        try {
            int pos = 0;
            while (pos < this.extra.length) {
                byte flags;
                int sig = this.extra[pos++] & 0xFF | (this.extra[pos++] & 0xFF) << 8;
                int len = this.extra[pos++] & 0xFF | (this.extra[pos++] & 0xFF) << 8;
                if (sig == 21589 && ((flags = this.extra[pos]) & 1) != 0) {
                    long time = this.extra[pos + 1] & 0xFF | (this.extra[pos + 2] & 0xFF) << 8 | (this.extra[pos + 3] & 0xFF) << 16 | (this.extra[pos + 4] & 0xFF) << 24;
                    this.setTime(time * 1000L);
                }
                pos += len;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        this.known = (byte)(this.known | 0x20);
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String comment) {
        if (comment != null && comment.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        int nlen = this.name.length();
        return nlen > 0 && this.name.charAt(nlen - 1) == '/';
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

