/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;

public class XMLEventReaderImpl
implements XMLEventReader {
    protected final XMLStreamReader reader;
    protected final XMLEventAllocator allocator;
    protected final String systemId;
    protected XMLEvent peekEvent;

    protected XMLEventReaderImpl(XMLStreamReader reader, XMLEventAllocator allocator, String systemId) {
        this.reader = reader;
        this.allocator = allocator;
        this.systemId = systemId;
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent ret = this.peek();
        this.peekEvent = null;
        return ret;
    }

    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            RuntimeException e2 = new RuntimeException();
            e2.initCause(e);
            throw e2;
        }
    }

    public boolean hasNext() {
        if (this.peekEvent != null) {
            return true;
        }
        try {
            return this.reader.hasNext();
        }
        catch (XMLStreamException xMLStreamException) {
            return false;
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.peekEvent != null) {
            return this.peekEvent;
        }
        if (!this.reader.hasNext()) {
            return null;
        }
        this.reader.next();
        this.peekEvent = this.allocator.allocate(this.reader);
        return this.peekEvent;
    }

    public String getElementText() throws XMLStreamException {
        return this.reader.getElementText();
    }

    public XMLEvent nextTag() throws XMLStreamException {
        if (this.peekEvent != null) {
            int eventType = this.peekEvent.getEventType();
            if (eventType == 1 || eventType == 2) {
                return this.peekEvent;
            }
            this.peekEvent = null;
        }
        this.reader.nextTag();
        return this.allocator.allocate(this.reader);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.reader.getProperty(name);
    }

    public void close() throws XMLStreamException {
        this.reader.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

