/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.LineSegment;
import gnu.java.awt.java2d.Segment;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;

public class CubicSegment
extends Segment {
    public Point2D cp1;
    public Point2D cp2;

    public CubicSegment(double x1, double y1, double c1x, double c1y, double c2x, double c2y, double x2, double y2) {
        this.P1 = new Point2D.Double(x1, y1);
        this.P2 = new Point2D.Double(x2, y2);
        this.cp1 = new Point2D.Double(c1x, c1y);
        this.cp2 = new Point2D.Double(c2x, c2y);
    }

    public CubicSegment(Point2D p1, Point2D cp1, Point2D cp2, Point2D p2) {
        this.P1 = p1;
        this.P2 = p2;
        this.cp1 = cp1;
        this.cp2 = cp2;
    }

    public Object clone() {
        CubicSegment segment = null;
        try {
            segment = (CubicSegment)super.clone();
            segment.P1 = (Point2D)this.P1.clone();
            segment.P2 = (Point2D)this.P2.clone();
            segment.cp1 = (Point2D)this.cp1.clone();
            segment.cp2 = (Point2D)this.cp2.clone();
        }
        catch (CloneNotSupportedException cnse) {
            InternalError ie = new InternalError();
            ie.initCause(cnse);
            throw ie;
        }
        return segment;
    }

    public Segment[] getDisplacedSegments(double radius) {
        Segment segmentTop = null;
        Segment segmentBottom = null;
        this.radius = radius;
        CubicCurve2D[] curves = new CubicCurve2D[10];
        curves[0] = new CubicCurve2D.Double(this.P1.getX(), this.P1.getY(), this.cp1.getX(), this.cp1.getY(), this.cp2.getX(), this.cp2.getY(), this.P2.getX(), this.P2.getY());
        int numCurves = 1;
        while (numCurves > 0) {
            if (curves[numCurves - 1].getFlatnessSq() <= radius / 3.0 || numCurves == 10) {
                Segment[] displaced = new LineSegment(curves[numCurves - 1].getP1(), curves[numCurves - 1].getP2()).getDisplacedSegments(radius);
                if (segmentTop == null) {
                    segmentTop = displaced[0];
                    segmentBottom = displaced[1];
                } else {
                    segmentTop.add(displaced[0]);
                    segmentBottom.add(displaced[1]);
                }
                --numCurves;
                continue;
            }
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            curves[numCurves - 1].subdivide(left, right);
            curves[numCurves - 1] = right;
            curves[numCurves] = left;
            curves[numCurves - 1] = right;
            curves[numCurves] = left;
            ++numCurves;
        }
        return new Segment[]{segmentTop, segmentBottom};
    }

    public void reverse() {
        Point2D temp = this.P1;
        this.P1 = this.P2;
        this.P2 = temp;
        temp = this.cp1;
        this.cp1 = this.cp2;
        this.cp2 = temp;
    }

    public double[] cp1() {
        return new double[]{this.cp1.getX(), this.cp1.getY()};
    }

    public double[] cp2() {
        return new double[]{this.cp2.getX(), this.cp2.getY()};
    }
}

