/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Signature;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class VirtualMachineCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        boolean shutdown = false;
        try {
            switch (command) {
                case 1: {
                    this.executeVersion(bb, os);
                    break;
                }
                case 2: {
                    this.executeClassesBySignature(bb, os);
                    break;
                }
                case 3: {
                    this.executeAllClasses(bb, os);
                    break;
                }
                case 4: {
                    this.executeAllThreads(bb, os);
                    break;
                }
                case 5: {
                    this.executeTopLevelThreadGroups(bb, os);
                    break;
                }
                case 7: {
                    this.executeIDsizes(bb, os);
                    break;
                }
                case 6: {
                    shutdown = true;
                    this.executeDispose(bb, os);
                    break;
                }
                case 8: {
                    this.executeSuspend(bb, os);
                    break;
                }
                case 9: {
                    this.executeResume(bb, os);
                    break;
                }
                case 10: {
                    shutdown = true;
                    this.executeExit(bb, os);
                    break;
                }
                case 11: {
                    this.executeCreateString(bb, os);
                    break;
                }
                case 12: {
                    this.executeCapabilities(bb, os);
                    break;
                }
                case 13: {
                    this.executeClassPaths(bb, os);
                    break;
                }
                case 14: {
                    this.executeDisposeObjects(bb, os);
                    break;
                }
                case 15: {
                    this.executeHoldEvents(bb, os);
                    break;
                }
                case 16: {
                    this.executeReleaseEvents(bb, os);
                    break;
                }
                case 17: {
                    this.executeCapabilitiesNew(bb, os);
                    break;
                }
                case 18: {
                    this.executeRedefineClasses(bb, os);
                    break;
                }
                case 19: {
                    this.executeSetDefaultStratum(bb, os);
                    break;
                }
                case 20: {
                    this.executeAllClassesWithGeneric(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in VirtualMachine Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return shutdown;
    }

    private void executeVersion(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        Properties props = System.getProperties();
        int jdwpMajor = 1;
        int jdwpMinor = 4;
        String description = "JDWP version " + jdwpMajor + "." + jdwpMinor + ", JVM version " + props.getProperty("java.vm.name") + " " + props.getProperty("java.vm.version") + " " + props.getProperty("java.version");
        String vmVersion = props.getProperty("java.version");
        String vmName = props.getProperty("java.vm.name");
        JdwpString.writeString(os, description);
        os.writeInt(jdwpMajor);
        os.writeInt(jdwpMinor);
        JdwpString.writeString(os, vmName);
        JdwpString.writeString(os, vmVersion);
    }

    private void executeClassesBySignature(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        String sig = JdwpString.readString(bb);
        ArrayList<Class> allMatchingClasses = new ArrayList<Class>();
        Collection classes = VMVirtualMachine.getAllLoadedClasses();
        for (Class clazz : classes) {
            String clazzSig = Signature.computeClassSignature(clazz);
            if (!clazzSig.equals(sig)) continue;
            allMatchingClasses.add(clazz);
        }
        os.writeInt(allMatchingClasses.size());
        int i = 0;
        while (i < allMatchingClasses.size()) {
            Class clazz = (Class)allMatchingClasses.get(i);
            ReferenceTypeId id = this.idMan.getReferenceTypeId(clazz);
            id.writeTagged(os);
            int status = VMVirtualMachine.getClassStatus(clazz);
            os.writeInt(status);
            ++i;
        }
    }

    private void executeAllClasses(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        Collection classes = VMVirtualMachine.getAllLoadedClasses();
        os.writeInt(classes.size());
        for (Class clazz : classes) {
            ReferenceTypeId id = this.idMan.getReferenceTypeId(clazz);
            id.writeTagged(os);
            String sig = Signature.computeClassSignature(clazz);
            JdwpString.writeString(os, sig);
            int status = VMVirtualMachine.getClassStatus(clazz);
            os.writeInt(status);
        }
    }

    private void executeAllThreads(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        Thread thread;
        ThreadGroup jdwpGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup root = this.getRootThreadGroup(jdwpGroup);
        int numThreads = root.activeCount();
        Thread[] allThreads = new Thread[numThreads];
        root.enumerate(allThreads);
        numThreads = 0;
        int i = 0;
        while (i < allThreads.length) {
            thread = allThreads[i];
            if (thread == null) break;
            if (!thread.getThreadGroup().equals(jdwpGroup)) {
                ++numThreads;
            }
            ++i;
        }
        os.writeInt(numThreads);
        i = 0;
        while (i < allThreads.length) {
            thread = allThreads[i];
            if (thread == null) break;
            if (!thread.getThreadGroup().equals(jdwpGroup)) {
                this.idMan.getObjectId(thread).write(os);
            }
            ++i;
        }
    }

    private void executeTopLevelThreadGroups(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadGroup jdwpGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup root = this.getRootThreadGroup(jdwpGroup);
        os.writeInt(1);
        this.idMan.getObjectId(root).write(os);
    }

    private void executeDispose(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.Dispose not implemented");
    }

    private void executeIDsizes(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        os.writeInt(8);
        os.writeInt(8);
        os.writeInt(8);
        os.writeInt(8);
        os.writeInt(8);
    }

    private void executeSuspend(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        VMVirtualMachine.suspendAllThreads();
    }

    private void executeResume(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        VMVirtualMachine.resumeAllThreads();
    }

    private void executeExit(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        int exitCode = bb.getInt();
        System.exit(exitCode);
    }

    private void executeCreateString(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        String string = JdwpString.readString(bb);
        ObjectId stringId = this.idMan.getObjectId(string);
        stringId.disableCollection();
        stringId.write(os);
    }

    private void executeCapabilities(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
    }

    private void executeClassPaths(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        String baseDir = System.getProperty("user.dir");
        JdwpString.writeString(os, baseDir);
        String classPath = System.getProperty("java.class.path");
        String[] paths = classPath.split(":");
        os.writeInt(paths.length);
        int i = 0;
        while (i < paths.length) {
            JdwpString.writeString(os, paths[i]);
            ++i;
        }
        String bootPath = System.getProperty("sun.boot.class.path");
        paths = bootPath.split(":");
        os.writeInt(paths.length);
        int i2 = 0;
        while (i2 < paths.length) {
            JdwpString.writeString(os, paths[i2]);
            ++i2;
        }
    }

    private void executeDisposeObjects(ByteBuffer bb, DataOutputStream os) throws JdwpException {
    }

    private void executeHoldEvents(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.HoldEvents not implemented");
    }

    private void executeReleaseEvents(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.ReleaseEvents not implemented");
    }

    private void executeCapabilitiesNew(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        this.executeCapabilities(bb, os);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        os.writeBoolean(false);
        int i = 15;
        while (i < 32) {
            os.writeBoolean(false);
            ++i;
        }
    }

    private void executeRedefineClasses(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        String msg = "redefinition of classes is not supported";
        throw new NotImplementedException(msg);
    }

    private void executeSetDefaultStratum(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        String msg = "setting the default stratum is not supported";
        throw new NotImplementedException(msg);
    }

    private void executeAllClassesWithGeneric(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.AllClassesWithGeneric not implemented");
    }

    private ThreadGroup getRootThreadGroup(ThreadGroup group) {
        ThreadGroup parent = group.getParent();
        while (parent != null) {
            group = parent;
            parent = group.getParent();
        }
        return group;
    }
}

