'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _libColourNames = require('./lib/colourNames');

var _libColourNames2 = _interopRequireDefault(_libColourNames);

var _libToShorthand = require('./lib/toShorthand');

var _libToShorthand2 = _interopRequireDefault(_libToShorthand);

var _libColourType = require('./lib/colourType');

var ctype = _interopRequireWildcard(_libColourType);

var _color = require('color');

var _color2 = _interopRequireDefault(_color);

var _libStripWhitespace = require('./lib/stripWhitespace');

var _libStripWhitespace2 = _interopRequireDefault(_libStripWhitespace);

var _libTrimLeadingZero = require('./lib/trimLeadingZero');

var _libTrimLeadingZero2 = _interopRequireDefault(_libTrimLeadingZero);

var filterColor = function filterColor(callback) {
    return Object.keys(_libColourNames2['default']).filter(callback);
};
var shorter = function shorter(a, b) {
    return (a && a.length < b.length ? a : b).toLowerCase();
};

exports['default'] = function (colour) {
    if (ctype.isRGBorHSL(colour)) {
        var c = (0, _color2['default'])(colour);
        if (c.alpha() === 1) {
            // At full alpha, just use hex
            colour = c.hexString();
        } else {
            var rgb = c.rgb();
            if (!rgb.r && !rgb.g && !rgb.b && !rgb.a) {
                return 'transparent';
            }
            var hsla = c.hslaString();
            var rgba = c.rgbString();
            return (0, _libTrimLeadingZero2['default'])((0, _libStripWhitespace2['default'])(hsla.length < rgba.length ? hsla : rgba));
        }
    }
    if (ctype.isHex(colour)) {
        colour = (0, _libToShorthand2['default'])(colour.toLowerCase());
        var keyword = filterColor(function (key) {
            return _libColourNames2['default'][key] === colour;
        })[0];
        return shorter(keyword, colour);
    } else if (ctype.isKeyword(colour)) {
        var hex = _libColourNames2['default'][filterColor(function (k) {
            return k === colour.toLowerCase();
        })[0]];
        return shorter(hex, colour);
    }
    // Possibly malformed, just pass through
    return colour;
};

module.exports = exports['default'];