Ext.namespace('Zarafa.plugins.pdfbox');

/**
 * @class Zarafa.plugins.pdfbox.ABOUT
 * @extends String
 *
 * The copyright string holding the copyright notice for the Zarafa pdfbox Plugin.
 */
Zarafa.plugins.pdfbox.ABOUT = ""
	+ "<p>Copyright (C) 2005 - 2015  Zarafa B.V. &lt;info@zarafa.com&gt; and its licensors</p>"

	+ "<p>This program is free software: you can redistribute it and/or modify "
	+ "it under the terms of the GNU Affero General Public License as "
	+ "published by the Free Software Foundation, either version 3 of the "
	+ "License, or (at your option) any later version.</p>"

	+ "<p>This program is distributed in the hope that it will be useful, "
	+ "but WITHOUT ANY WARRANTY; without even the implied warranty of "
	+ "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
	+ "GNU Affero General Public License for more details.</p>"

	+ "<p>You should have received a copy of the GNU Affero General Public License "
	+ "along with this program.  If not, see <a href=\"http://www.gnu.org/licenses/\" target=\"_blank\">http://www.gnu.org/licenses/</a>.</p>"

	+ "<hr />"

	+ "<p>The pdfbox plugin contains the following third-party components:</p>"

	+ "<h1>pdf.js</h1>"

	+ "<p>Copyright (C) 2011 Mozilla Foundation</p>"

	+ "<p>Contributors: Andreas Gal &lt;gal@mozilla.com&gt;"
	+ "              Chris G Jones &lt;cjones@mozilla.com&gt;"
	+ "              Shaon Barman &lt;shaon.barman@gmail.com&gt;"
	+ "              Vivien Nicolas &lt;21@vingtetun.org&gt;"
	+ "              Justin D'Arcangelo &lt;justindarc@gmail.com&gt;"
	+ "              Yury Delendik"
	+ "              Kalervo Kujala"
	+ "              Adil Allawi &lt;@ironymark&gt;"
	+ "              Jakob Miland &lt;saebekassebil@gmail.com&gt;"
	+ "              Artur Adib &lt;aadib@mozilla.com&gt;"
	+ "              Brendan Dahl &lt;bdahl@mozilla.com&gt;"
	+ "              David Quintana &lt;gigaherz@gmail.com&gt;</p>"

	+ "<p>Permission is hereby granted, free of charge, to any person obtaining a"
	+ "copy of this software and associated documentation files (the \"Software\"),"
	+ "to deal in the Software without restriction, including without limitation"
	+ "the rights to use, copy, modify, merge, publish, distribute, sublicense,"
	+ "and/or sell copies of the Software, and to permit persons to whom the"
	+ "Software is furnished to do so, subject to the following conditions:</p>"

	+ "<p>The above copyright notice and this permission notice shall be included in"
	+ "all copies or substantial portions of the Software.</p>"

	+ "<p>THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR"
	+ "IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,"
	+ "FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL"
	+ "THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER"
	+ "LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING"
	+ "FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER"
	+ "DEALINGS IN THE SOFTWARE.</p>";
Ext.namespace('Zarafa.plugins.pdfbox');

/**
 * @class Zarafa.plugins.pdfbox.PdfBoxPlugin
 * @extends Zarafa.core.Plugin
 */
Zarafa.plugins.pdfbox.PdfBoxPlugin = Ext.extend(Zarafa.core.Plugin, {

	/**
	 * Fired when the user doubleclicked on a box
	 * @param {Zarafa.common.ui.BoxField} boxField Parent of the box
	 * @param {Zarafa.common.ui.Box} box The box that has been doubleclicked
	 * @param {Ext.data.Record} record The record that belongs to the box
	 */
	doOpen: function(record)
	{
		var filename = record.get('name');
		var pdfBoxCfg = {
			easing: 'elasticOut', 
			resizeDuration: 0.6, 
			close: '&#215;',
			hideInfo: 'auto',
			href: record.getInlineImageUrl(),
			title: filename
		};
		Ext.ux.PdfBox.open(pdfBoxCfg);
	},
	
	/**
	 * Bid for the type of shared component and the given record.
	 * This will bid on a common.create or common.view for a
	 * record with a message class set to IPM or IPM.Note.
	 * @param {Zarafa.core.data.SharedComponentType} type Type of component a context can bid for.
	 * @param {Ext.data.Record} record Optionally passed record.
	 * @return {Number} The bid for the shared component
	 */
	bidSharedComponent: function(type, record)
	{
		var bid = -1;
		switch (type) {
			case Zarafa.core.data.SharedComponentType['common.view']:
			{
				if (record instanceof Zarafa.core.data.IPMAttachmentRecord) {
					var filename = record.get('name');
					if(Ext.ux.PdfBox.isDocument(filename))
					{
						bid=1;
					}
				}
				break;
			}
		}
		return bid;
	},

	/**
	 * Will return the reference to the shared component.
	 * Based on the type of component requested a component is returned.
	 * @param {Zarafa.core.data.SharedComponentType} type Type of component a context can bid for.
	 * @param {Ext.data.Record} record Optionally passed record.
	 * @return {Ext.Component} Component
	 */
	getSharedComponent: function(type, record)
	{
		var component;
		switch (type) {
			case Zarafa.core.data.SharedComponentType['common.view']:
				component = this;
				break;
		}
		return component;
	}

});

Zarafa.onReady(function() {
	container.registerPlugin(new Zarafa.core.PluginMetaData({
		name : 'pdfbox',
		displayName : _('PDF Box Plugin'),
		about : Zarafa.plugins.pdfbox.ABOUT,
		pluginConstructor : Zarafa.plugins.pdfbox.PdfBoxPlugin
	}));
});
