"""Generated message classes for datastore version v1beta3.

Google Cloud Datastore is a schemaless NoSQL datastore providing robust,
scalable storage for your application.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages
from googlecloudsdk.third_party.apitools.base.py import encoding


package = 'datastore'


class AllocateIdsRequest(_messages.Message):
  """The request for google.datastore.v1beta3.Datastore.AllocateIds.

  Fields:
    databaseId: If not empty, the ID of the database against which to make the
      request.
    keys: A list of keys with incomplete key paths for which to allocate IDs.
      No key may be reserved/read-only.
  """

  databaseId = _messages.StringField(1)
  keys = _messages.MessageField('Key', 2, repeated=True)


class AllocateIdsResponse(_messages.Message):
  """The response for google.datastore.v1beta3.Datastore.AllocateIds.

  Fields:
    keys: The keys specified in the request (in the same order), each with its
      key path completed with a newly allocated ID.
  """

  keys = _messages.MessageField('Key', 1, repeated=True)


class ArrayValue(_messages.Message):
  """An array value.

  Fields:
    values: Values in the array. The order of this array may not be preserved
      if it contains a mix of indexed and unindexed values.
  """

  values = _messages.MessageField('Value', 1, repeated=True)


class BeginTransactionRequest(_messages.Message):
  """The request for google.datastore.v1beta3.Datastore.BeginTransaction.

  Fields:
    databaseId: If not empty, the ID of the database against which to make the
      request.
    transactionOptions: Options for a new transaction.
  """

  databaseId = _messages.StringField(1)
  transactionOptions = _messages.MessageField('TransactionOptions', 2)


class BeginTransactionResponse(_messages.Message):
  """The response for google.datastore.v1beta3.Datastore.BeginTransaction.

  Fields:
    transaction: The transaction identifier (always present).
  """

  transaction = _messages.BytesField(1)


class Circle(_messages.Message):
  """A "circle" on the surface of the Earth, defined as the area within a
  certain geographical distance of a point.

  Fields:
    center: The center of the circle.
    radiusMeters: The "radius" of the circle, in meters. Must be greater or
      equal to zero.
  """

  center = _messages.MessageField('LatLng', 1)
  radiusMeters = _messages.FloatField(2)


class CommitRequest(_messages.Message):
  """The request for google.datastore.v1beta3.Datastore.Commit.

  Enums:
    ModeValueValuesEnum: The type of commit to perform. Defaults to
      `TRANSACTIONAL`.

  Fields:
    databaseId: If not empty, the ID of the database against which to make the
      request.
    mode: The type of commit to perform. Defaults to `TRANSACTIONAL`.
    mutations: The mutations to perform.  When mode is `TRANSACTIONAL`,
      mutations affecting a single entity are applied in order. The following
      sequences of mutations affecting a single entity are not permitted in a
      single `Commit` request:  - `insert` followed by `insert` - `update`
      followed by `insert` - `upsert` followed by `insert` - `delete` followed
      by `update`  When mode is `NON_TRANSACTIONAL`, no two mutations may
      affect a single entity.
    singleUseTransaction: Options for beginning a new transaction for this
      request. The transaction is committed when the request completes. If
      specified, google.datastore.v1beta3.TransactionOptions.mode must be
      google.datastore.v1beta3.TransactionOptions.ReadWrite.
    transaction: The identifier of the transaction associated with the commit.
      A transaction identifier is returned by a call to BeginTransaction.
  """

  class ModeValueValuesEnum(_messages.Enum):
    """The type of commit to perform. Defaults to `TRANSACTIONAL`.

    Values:
      MODE_UNSPECIFIED: Unspecified. This value must not be used.
      TRANSACTIONAL: Transactional: The mutations are either all applied, or
        none are applied. Learn about transactions
        [here](https://cloud.google.com/datastore/docs/concepts/transactions).
      NON_TRANSACTIONAL: Non-transactional: The mutations may not apply as all
        or none.
    """
    MODE_UNSPECIFIED = 0
    TRANSACTIONAL = 1
    NON_TRANSACTIONAL = 2

  databaseId = _messages.StringField(1)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)
  mutations = _messages.MessageField('Mutation', 3, repeated=True)
  singleUseTransaction = _messages.MessageField('TransactionOptions', 4)
  transaction = _messages.BytesField(5)


class CommitResponse(_messages.Message):
  """The response for google.datastore.v1beta3.Datastore.Commit.

  Fields:
    indexUpdates: The number of index entries updated during the commit, or
      zero if none were updated.
    mutationResults: The result of performing the mutations. The i-th mutation
      result corresponds to the i-th mutation in the request.
  """

  indexUpdates = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  mutationResults = _messages.MessageField('MutationResult', 2, repeated=True)


class CommonMetadata(_messages.Message):
  """Metadata common to all Datastore Admin Operations.

  Enums:
    OperationTypeValueValuesEnum: The type of the operation.  Can be used as a
      filter in ListOperationsRequest.

  Messages:
    LabelsValue: The client-assigned labels which were provided when the
      Operation was created.  May also include additional labels.

  Fields:
    cancelling: True if the Operation is currently being cancelled.  Will only
      be set after the cancellation request was received, but before the
      Operation is done. So the state transitions are: 1) done=false,
      cancelling=false 2) done=false, cancelling=true 3) done=true,
      cancelling=false
    endTime: The time the Operation ended, either successfully or otherwise.
    labels: The client-assigned labels which were provided when the Operation
      was created.  May also include additional labels.
    operationType: The type of the operation.  Can be used as a filter in
      ListOperationsRequest.
    startTime: The time that work began on the Operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    """The type of the operation.  Can be used as a filter in
    ListOperationsRequest.

    Values:
      UNSPECIFIED_TYPE: Unspecified.
      EXPORT: Export.
      IMPORT: Import.
      BUILD_INDEX: Build an index.
      CLEAR_INDEX: Clear an index.
    """
    UNSPECIFIED_TYPE = 0
    EXPORT = 1
    IMPORT = 2
    BUILD_INDEX = 3
    CLEAR_INDEX = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """The client-assigned labels which were provided when the Operation was
    created.  May also include additional labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cancelling = _messages.BooleanField(1)
  endTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 4)
  startTime = _messages.StringField(5)


class CompositeFilter(_messages.Message):
  """A filter that merges multiple other filters using the given operator.

  Enums:
    OpValueValuesEnum: The operator for combining multiple filters.

  Fields:
    filters: The list of filters to combine. Must contain at least one filter.
    op: The operator for combining multiple filters.
  """

  class OpValueValuesEnum(_messages.Enum):
    """The operator for combining multiple filters.

    Values:
      OPERATOR_UNSPECIFIED: Unspecified. This value must not be used.
      AND: The results are required to satisfy each of the combined filters.
    """
    OPERATOR_UNSPECIFIED = 0
    AND = 1

  filters = _messages.MessageField('Filter', 1, repeated=True)
  op = _messages.EnumField('OpValueValuesEnum', 2)


class DatastoreProjectsAllocateIdsRequest(_messages.Message):
  """A DatastoreProjectsAllocateIdsRequest object.

  Fields:
    allocateIdsRequest: A AllocateIdsRequest resource to be passed as the
      request body.
    projectId: The ID of the project against which to make the request.
  """

  allocateIdsRequest = _messages.MessageField('AllocateIdsRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsBeginTransactionRequest(_messages.Message):
  """A DatastoreProjectsBeginTransactionRequest object.

  Fields:
    beginTransactionRequest: A BeginTransactionRequest resource to be passed
      as the request body.
    projectId: The ID of the project against which to make the request.
  """

  beginTransactionRequest = _messages.MessageField('BeginTransactionRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsCommitRequest(_messages.Message):
  """A DatastoreProjectsCommitRequest object.

  Fields:
    commitRequest: A CommitRequest resource to be passed as the request body.
    projectId: The ID of the project against which to make the request.
  """

  commitRequest = _messages.MessageField('CommitRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsExportRequest(_messages.Message):
  """A DatastoreProjectsExportRequest object.

  Fields:
    exportRequest: A ExportRequest resource to be passed as the request body.
    projectId: Project ID against which to make the request.
  """

  exportRequest = _messages.MessageField('ExportRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsImportRequest(_messages.Message):
  """A DatastoreProjectsImportRequest object.

  Fields:
    importRequest: A ImportRequest resource to be passed as the request body.
    projectId: Project ID against which to make the request.
  """

  importRequest = _messages.MessageField('ImportRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsIndexesGetRequest(_messages.Message):
  """A DatastoreProjectsIndexesGetRequest object.

  Fields:
    databaseId: The database id.
    indexId: The format matches that of Index.index_id.
    projectId: The project id.
  """

  databaseId = _messages.StringField(1)
  indexId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)


class DatastoreProjectsIndexesListRequest(_messages.Message):
  """A DatastoreProjectsIndexesListRequest object.

  Fields:
    databaseId: The database id.
    filter: The standard List filter. The filter expression may filter only on
      definition.kind, eg '(definition.kind == "User") or (definition.kind ==
      "Widget")'.
    pageSize: The standard List page size.
    pageToken: The standard List page token.
    projectId: The project id.
  """

  databaseId = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.BytesField(4)
  projectId = _messages.StringField(5, required=True)


class DatastoreProjectsIndexesLookupRequest(_messages.Message):
  """A DatastoreProjectsIndexesLookupRequest object.

  Fields:
    lookupIndexRequest: A LookupIndexRequest resource to be passed as the
      request body.
    projectId: The project id.
  """

  lookupIndexRequest = _messages.MessageField('LookupIndexRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsLookupRequest(_messages.Message):
  """A DatastoreProjectsLookupRequest object.

  Fields:
    lookupRequest: A LookupRequest resource to be passed as the request body.
    projectId: The ID of the project against which to make the request.
  """

  lookupRequest = _messages.MessageField('LookupRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsMultiWatchRequest(_messages.Message):
  """A DatastoreProjectsMultiWatchRequest object.

  Fields:
    multiWatchRequest: A MultiWatchRequest resource to be passed as the
      request body.
    projectId: Project ID against which to make the request.
  """

  multiWatchRequest = _messages.MessageField('MultiWatchRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsOperationsCancelRequest(_messages.Message):
  """A DatastoreProjectsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class DatastoreProjectsOperationsDeleteRequest(_messages.Message):
  """A DatastoreProjectsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatastoreProjectsOperationsGetRequest(_messages.Message):
  """A DatastoreProjectsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DatastoreProjectsOperationsListRequest(_messages.Message):
  """A DatastoreProjectsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation collection.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DatastoreProjectsRollbackRequest(_messages.Message):
  """A DatastoreProjectsRollbackRequest object.

  Fields:
    projectId: The ID of the project against which to make the request.
    rollbackRequest: A RollbackRequest resource to be passed as the request
      body.
  """

  projectId = _messages.StringField(1, required=True)
  rollbackRequest = _messages.MessageField('RollbackRequest', 2)


class DatastoreProjectsRunQueryRequest(_messages.Message):
  """A DatastoreProjectsRunQueryRequest object.

  Fields:
    projectId: The ID of the project against which to make the request.
    runQueryRequest: A RunQueryRequest resource to be passed as the request
      body.
  """

  projectId = _messages.StringField(1, required=True)
  runQueryRequest = _messages.MessageField('RunQueryRequest', 2)


class DatastoreProjectsWatchRequest(_messages.Message):
  """A DatastoreProjectsWatchRequest object.

  Fields:
    projectId: Project ID against which to make the request.
    watchRequest: A WatchRequest resource to be passed as the request body.
  """

  projectId = _messages.StringField(1, required=True)
  watchRequest = _messages.MessageField('WatchRequest', 2)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Entity(_messages.Message):
  """A Datastore data object.  An entity is limited to 1 megabyte when stored.
  That _roughly_ corresponds to a limit of 1 megabyte for the serialized form
  of this message.

  Messages:
    PropertiesValue: The entity's properties. The map's keys are property
      names. A property name matching regex `__.*__` is reserved. A reserved
      property name is forbidden in certain documented contexts. The name must
      not contain more than 500 characters. The name cannot be `""`.

  Fields:
    key: The entity's key.  An entity must have a key, unless otherwise
      documented (for example, an entity in `Value.entity_value` may have no
      key). An entity's kind is its key path's last element's kind, or null if
      it has no key.
    properties: The entity's properties. The map's keys are property names. A
      property name matching regex `__.*__` is reserved. A reserved property
      name is forbidden in certain documented contexts. The name must not
      contain more than 500 characters. The name cannot be `""`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    """The entity's properties. The map's keys are property names. A property
    name matching regex `__.*__` is reserved. A reserved property name is
    forbidden in certain documented contexts. The name must not contain more
    than 500 characters. The name cannot be `""`.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A Value attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Value', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  key = _messages.MessageField('Key', 1)
  properties = _messages.MessageField('PropertiesValue', 2)


class EntityFilter(_messages.Message):
  """Identifies a subset of Entities in a Project.  This is specified as
  combinations of Kind + Namespace (either or both of which may be all as
  described in the following examples). Example usage:  Entire Project:
  kinds=[], namespace_ids=[]  Kinds Foo and Bar in all Namespaces:
  kinds=['Foo', 'Bar'], namespace_ids=[]  Kinds Foo and Bar only in the
  Default Namespace:   kinds=['Foo', 'Bar'], namespace_ids=['']  Kinds Foo and
  Bar in both the Default and Baz Namespaces:   kinds=['Foo', 'Bar'],
  namespace_ids=['', 'Baz']  The entire Baz Namespace:   kinds=[],
  namespace_ids=['Baz']

  Fields:
    kinds: If empty, then this represents all Kinds.
    namespaceIds: An empty list represents all Namespaces.  This is the
      preferred usage for Projects that don't use Namespaces.  An empty string
      element represents the Default Namespace.  This should be used if the
      Project has data in non-Default Namespaces, but doesn't want to include
      them. Each Namespace in this list must be unique.
  """

  kinds = _messages.StringField(1, repeated=True)
  namespaceIds = _messages.StringField(2, repeated=True)


class EntityResult(_messages.Message):
  """The result of fetching an entity from Datastore.

  Fields:
    cursor: A cursor that points to the position after the result entity. Set
      only when the `EntityResult` is part of a `QueryResultBatch` message.
    entity: The resulting entity.
    version: The version of the entity, a strictly positive number that
      monotonically increases with changes to the entity.  This field is set
      for `FULL` entity results. For missing entities in `LookupResponse`,
      this is the version of the snapshot that was used to look up the entity,
      and it is always set except for eventually consistent reads.
  """

  cursor = _messages.BytesField(1)
  entity = _messages.MessageField('Entity', 2)
  version = _messages.IntegerField(3)


class ExistenceFilter(_messages.Message):
  """An existence filter that must be applied and verified locally to resolve
  possible delete mutations.

  Enums:
    StrategyValueValuesEnum: The strategy used to map a key to the filter
      bits.

  Fields:
    bits: The filter bits.
    count: The total number of keys represented in this filter. Used to detect
      the presence of false positives.
    hashCount: The number of hashes used in `bits`.
    strategy: The strategy used to map a key to the filter bits.
  """

  class StrategyValueValuesEnum(_messages.Enum):
    """The strategy used to map a key to the filter bits.

    Values:
      STRATEGY_NOT_SPECIFIED: <no description>
      MURMUR128_MITZ_64: <no description>
    """
    STRATEGY_NOT_SPECIFIED = 0
    MURMUR128_MITZ_64 = 1

  bits = _messages.BytesField(1)
  count = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  hashCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  strategy = _messages.EnumField('StrategyValueValuesEnum', 4)


class ExportMetadata(_messages.Message):
  """Metadata for Export Operations.

  Fields:
    bytesProgress: An estimate of the number of bytes processed.
    common: Metadata common to all Datastore Admin Operations.
    destination: Location for the export metadata and data files.  This will
      be the same value as the
      google.datastore.v1beta3.ExportRequest.destination field. Actual files
      will be nested deeper than this.  The final output location is provided
      in google.datastore.v1beta3.ExportResponse.data_location.
    entitiesProgress: An estimate of the number of Entities processed.
    entityFilter: Description of which Entities are being exported.
  """

  bytesProgress = _messages.MessageField('Progress', 1)
  common = _messages.MessageField('CommonMetadata', 2)
  destination = _messages.StringField(3)
  entitiesProgress = _messages.MessageField('Progress', 4)
  entityFilter = _messages.MessageField('EntityFilter', 5)


class ExportRequest(_messages.Message):
  """The request for google.datastore.v1beta3.DatastoreAdmin.Export.

  Messages:
    LabelsValue: Client-assigned labels.

  Fields:
    databaseId: Database ID against which to make the request. Unset indicates
      the default database. Not currently supported.
    destination: Location for the export metadata and data files.  Specified
      as the full resource name of the external storage location. Currently,
      only Google Cloud Storage is supported.  So the destination should be of
      the form: //storage.googleapis.com/buckets/bucket-name or
      //storage.googleapis.com/buckets/bucket-name/objects/object-path.  The
      resulting files will be nested deeper than the specified destination.
      The final data location will be provided in the
      google.datastore.v1beta3.ExportResponse.data_location field.  That value
      should be used for subsequent Import Operations.  By nesting the data
      files deeper, the same destination can be used in multiple Export
      Operations without conflict.
    entityFilter: Description of what data from the Project is included in the
      export.
    labels: Client-assigned labels.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Client-assigned labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  databaseId = _messages.StringField(1)
  destination = _messages.StringField(2)
  entityFilter = _messages.MessageField('EntityFilter', 3)
  labels = _messages.MessageField('LabelsValue', 4)


class ExportResponse(_messages.Message):
  """The response for google.datastore.v1beta3.DatastoreAdmin.Export.

  Fields:
    dataLocation: Location of the output files. This can be used to begin an
      import into Cloud Datastore (this Project or another Project).  See
      google.datastore.v1beta3.ImportRequest.data_location.  Only present if
      the Operation completed successfully.  This location will be nested
      deeper than the initial
      google.datastore.v1beta3.ExportRequest.destination in order to support
      multiple Exports to the same destination without conflict.
  """

  dataLocation = _messages.StringField(1)


class Filter(_messages.Message):
  """A holder for any type of filter.

  Fields:
    compositeFilter: A composite filter.
    propertyFilter: A filter on a property.
    stContainsFilter: A filter that selects geo points within a region.
  """

  compositeFilter = _messages.MessageField('CompositeFilter', 1)
  propertyFilter = _messages.MessageField('PropertyFilter', 2)
  stContainsFilter = _messages.MessageField('StContainsFilter', 3)


class GeoRegion(_messages.Message):
  """A region on the surface of the Earth.

  Fields:
    circle: A circular region.
    rectangle: A rectangular region.
  """

  circle = _messages.MessageField('Circle', 1)
  rectangle = _messages.MessageField('Rectangle', 2)


class GqlQuery(_messages.Message):
  """A [GQL
  query](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).

  Messages:
    NamedBindingsValue: For each non-reserved named binding site in the query
      string, there must be a named parameter with that name, but not
      necessarily the inverse. Key must match regex `A-Za-z_$*`, must not
      match regex `__.*__`, and must not be `""`.

  Fields:
    allowLiterals: When false, the query string must not contain any literals
      and instead must bind all values. For example, `SELECT * FROM Kind WHERE
      a = 'string literal'` is not allowed, while `SELECT * FROM Kind WHERE a
      = @value` is.
    namedBindings: For each non-reserved named binding site in the query
      string, there must be a named parameter with that name, but not
      necessarily the inverse. Key must match regex `A-Za-z_$*`, must not
      match regex `__.*__`, and must not be `""`.
    positionalBindings: Numbered binding site @1 references the first numbered
      parameter, effectively using 1-based indexing, rather than the usual 0.
      For each binding site numbered i in `query_string`, there must be an
      i-th numbered parameter. The inverse must also be true.
    queryString: A string of the format described
      [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NamedBindingsValue(_messages.Message):
    """For each non-reserved named binding site in the query string, there
    must be a named parameter with that name, but not necessarily the inverse.
    Key must match regex `A-Za-z_$*`, must not match regex `__.*__`, and must
    not be `""`.

    Messages:
      AdditionalProperty: An additional property for a NamedBindingsValue
        object.

    Fields:
      additionalProperties: Additional properties of type NamedBindingsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a NamedBindingsValue object.

      Fields:
        key: Name of the additional property.
        value: A GqlQueryParameter attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GqlQueryParameter', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allowLiterals = _messages.BooleanField(1)
  namedBindings = _messages.MessageField('NamedBindingsValue', 2)
  positionalBindings = _messages.MessageField('GqlQueryParameter', 3, repeated=True)
  queryString = _messages.StringField(4)


class GqlQueryParameter(_messages.Message):
  """A binding parameter for a GQL query.

  Fields:
    cursor: A query cursor. Query cursors are returned in query result
      batches.
    geoRegion: Geographical region.
    value: A value parameter.
  """

  cursor = _messages.BytesField(1)
  geoRegion = _messages.MessageField('GeoRegion', 2)
  value = _messages.MessageField('Value', 3)


class ImportMetadata(_messages.Message):
  """Metadata for Import operations.

  Fields:
    bytesProgress: An estimate of the number of bytes processed.
    common: Metadata common to all Datastore Admin Operations.
    dataLocation: The location that we are importing from.
    entitiesProgress: An estimate of the number of Entities processed.
    entityFilter: Description of which Entities are being imported.
  """

  bytesProgress = _messages.MessageField('Progress', 1)
  common = _messages.MessageField('CommonMetadata', 2)
  dataLocation = _messages.StringField(3)
  entitiesProgress = _messages.MessageField('Progress', 4)
  entityFilter = _messages.MessageField('EntityFilter', 5)


class ImportRequest(_messages.Message):
  """The request for google.datastore.v1beta3.DatastoreAdmin.Import.

  Messages:
    LabelsValue: Client-assigned labels.

  Fields:
    dataLocation: The full resource name of the external storage location.
      Currently, only Google Cloud Storage is supported.  So the data_location
      should be of the form: //storage.googleapis.com/buckets/bucket-
      name/objects/object-path.  See
      google.datastore.v1beta3.ExportResponse.data_location
    databaseId: Database ID against which to make the request. Unset indicates
      the default database. Not currently supported.
    entityFilter: Optionally specify which Kinds/Namespaces are to be
      imported. If provided, the list must be a subset of the EntityFilter
      used in creating the export, otherwise a FAILED_PRECONDITION error will
      be returned. If no filter is specified then all Entities from the export
      are imported.
    labels: Client-assigned labels.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Client-assigned labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dataLocation = _messages.StringField(1)
  databaseId = _messages.StringField(2)
  entityFilter = _messages.MessageField('EntityFilter', 3)
  labels = _messages.MessageField('LabelsValue', 4)


class Index(_messages.Message):
  """An index.

  Enums:
    StateValueValuesEnum: Required.

  Fields:
    databaseId: If not empty, the ID of the database to which the index
      belongs.
    indexDefinition: The definition of the index.  No two indexes have the
      same definition.
    indexId: The index's ID within the indexes collection resource.
    projectId: The ID of the project to which the index belongs.
    state: Required.
  """

  class StateValueValuesEnum(_messages.Enum):
    """Required.

    Values:
      STATE_UNSPECIFIED: The state is unspecified.
      OFF: No index data exists.
      SERVING: The index is updated when writing an entity. The index is fully
        populated from all relevant stored entities.
      BUILDING: The index is being built: transitioning from OFF to SERVING.
        There is an active long-running operation for the index. The index is
        updated when writing an entity. Some index data may exist.
      CLEARING: The index is being cleared: transitioning from SERVING to OFF.
        There is an active long-running operation for the index. The index is
        not updated when writing an entity. Some index data may exist.
      ERROR: The index was being built or cleared, but something went wrong.
        There is no active long-running operation for the index, and the most
        recently finished long-running operation failed. The index is not
        updated when writing an entity. Some index data may exist.
    """
    STATE_UNSPECIFIED = 0
    OFF = 1
    SERVING = 2
    BUILDING = 3
    CLEARING = 4
    ERROR = 5

  databaseId = _messages.StringField(1)
  indexDefinition = _messages.MessageField('IndexDefinition', 2)
  indexId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class IndexDefinition(_messages.Message):
  """An index definition.

  Fields:
    kind: The kind of entity to index. This field shares the constraints of
      field Key.PathElement.kind.
    properties: A sequence of indexed property definitions.
  """

  kind = _messages.StringField(1)
  properties = _messages.MessageField('IndexedPropertyDefinition', 2, repeated=True)


class IndexedPropertyDefinition(_messages.Message):
  """An indexed property definition.

  Enums:
    ModeValueValuesEnum: The indexed property's mode.

  Fields:
    mode: The indexed property's mode.
    name: The indexed property's name. This field shares the constraints of
      the keys of the map in field Entity.properties. If name includes "."s,
      it may be interpreted as a property name path. Required.
  """

  class ModeValueValuesEnum(_messages.Enum):
    """The indexed property's mode.

    Values:
      MODE_UNSPECIFIED: The mode is unspecified.
      UNORDERED: The property's values are indexed so as to support query by
        equality.
      ASCENDING: The property's values are indexed so as to support sequencing
        in ascending order and also query by <, >, <=, >=, and =.
      DESCENDING: The property's values are indexed so as to support
        sequencing in descending order and also query by <, >, <=, >=, and =.
      KEY_ANCESTRY: The property's key values are indexed by ancestor key,
        supporting query by key ancestry relationship. Currently supported
        only for property "__key__". For example, for an entity with key path
        /Blog:7/Post:11/Comment:5 the indexed ancestor key paths are /Blog:7,
        /Blog:7/Post:11, and /Blog:7/Post:11/Comment:5. (The partition ID of
        all the ancestor keys are the same.)
      GEO: The property's values are indexed by geographic location,
        supporting query by location. (Only geo point values are indexed;
        others are ignored.)
    """
    MODE_UNSPECIFIED = 0
    UNORDERED = 1
    ASCENDING = 2
    DESCENDING = 3
    KEY_ANCESTRY = 4
    GEO = 5

  mode = _messages.EnumField('ModeValueValuesEnum', 1)
  name = _messages.StringField(2)


class Key(_messages.Message):
  """A unique identifier for an entity. If a key's partition ID or any of its
  path kinds or names are reserved/read-only, the key is reserved/read-only. A
  reserved/read-only key is forbidden in certain documented contexts.

  Fields:
    partitionId: Entities are partitioned into subsets, currently identified
      by a project ID and namespace ID. Queries are scoped to a single
      partition.
    path: The entity path. An entity path consists of one or more elements
      composed of a kind and a string or numerical identifier, which identify
      entities. The first element identifies a _root entity_, the second
      element identifies a _child_ of the root entity, the third element
      identifies a child of the second entity, and so forth. The entities
      identified by all prefixes of the path are called the element's
      _ancestors_.  An entity path is always fully complete: *all* of the
      entity's ancestors are required to be in the path along with the entity
      identifier itself. The only exception is that in some documented cases,
      the identifier in the last path element (for the entity) itself may be
      omitted. For example, the last path element of the key of
      `Mutation.insert` may have no identifier.  A path can never be empty,
      and a path can have at most 100 elements.
  """

  partitionId = _messages.MessageField('PartitionId', 1)
  path = _messages.MessageField('PathElement', 2, repeated=True)


class KindExpression(_messages.Message):
  """A representation of a kind.

  Fields:
    name: The name of the kind.
  """

  name = _messages.StringField(1)


class LatLng(_messages.Message):
  """An object representing a latitude/longitude pair. This is expressed as a
  pair of doubles representing degrees latitude and degrees longitude. Unless
  specified otherwise, this must conform to the <a
  href="http://www.unoosa.org/pdf/icg/2012/template/WGS_84.pdf">WGS84
  standard</a>. Values must be within normalized ranges.  Example of
  normalization code in Python:      def NormalizeLongitude(longitude):
  " " "Wraps decimal degrees longitude to [-180.0, 180.0]." " "       q, r =
  divmod(longitude, 360.0)       if r > 180.0 or (r == 180.0 and q <= -1.0):
  return r - 360.0       return r      def NormalizeLatLng(latitude,
  longitude):       " " "Wraps decimal degrees latitude and longitude to
  [-180.0, 180.0] and [-90.0, 90.0], respectively." " "       r = latitude %
  360.0       if r <= 90.0:         return r, NormalizeLongitude(longitude)
  elif r >= 270.0:         return r - 360, NormalizeLongitude(longitude)
  else:         return 180 - r, NormalizeLongitude(longitude + 180.0)
  assert 180.0 == NormalizeLongitude(180.0)     assert -180.0 ==
  NormalizeLongitude(-180.0)     assert -179.0 == NormalizeLongitude(181.0)
  assert (0.0, 0.0) == NormalizeLatLng(360.0, 0.0)     assert (0.0, 0.0) ==
  NormalizeLatLng(-360.0, 0.0)     assert (85.0, 180.0) ==
  NormalizeLatLng(95.0, 0.0)     assert (-85.0, -170.0) ==
  NormalizeLatLng(-95.0, 10.0)     assert (90.0, 10.0) ==
  NormalizeLatLng(90.0, 10.0)     assert (-90.0, -10.0) ==
  NormalizeLatLng(-90.0, -10.0)     assert (0.0, -170.0) ==
  NormalizeLatLng(-180.0, 10.0)     assert (0.0, -170.0) ==
  NormalizeLatLng(180.0, 10.0)     assert (-90.0, 10.0) ==
  NormalizeLatLng(270.0, 10.0)     assert (90.0, 10.0) ==
  NormalizeLatLng(-270.0, 10.0)

  Fields:
    latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
    longitude: The longitude in degrees. It must be in the range [-180.0,
      +180.0].
  """

  latitude = _messages.FloatField(1)
  longitude = _messages.FloatField(2)


class ListIndexesResponse(_messages.Message):
  """The response for google.datastore.v1beta3.DatastoreAdmin.ListIndexes.

  Fields:
    indexes: The indexes.
    nextPageToken: The standard List next-page token.
  """

  indexes = _messages.MessageField('Index', 1, repeated=True)
  nextPageToken = _messages.BytesField(2)


class ListOperationsResponse(_messages.Message):
  """The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class LookupIndexRequest(_messages.Message):
  """The request for google.datastore.v1beta3.DatastoreAdmin.LookupIndex.

  Fields:
    databaseId: The database id.
    indexDefinition: The index definition.
  """

  databaseId = _messages.StringField(1)
  indexDefinition = _messages.MessageField('IndexDefinition', 2)


class LookupRequest(_messages.Message):
  """The request for google.datastore.v1beta3.Datastore.Lookup.

  Fields:
    databaseId: If not empty, the ID of the database against which to make the
      request.
    keys: Keys of entities to look up.
    propertyMask: The properties to return. Defaults to returning all
      properties. If this field is set and an entity has a property not
      referenced in the mask, it will not be included in
      google.datastore.v1beta3.LookupResponse.found.entity.properties. The
      entity's key is always returned. If an
      google.datastore.v1beta3.Value.entity_value is returned, its key is
      returned as well.  The paths in the mask are property paths: dot (`.`)
      separated property names that can be used to reference properties nested
      in google.datastore.v1beta3.Value.entity_value. A property must not
      reference a value inside an google.datastore.v1beta3.Value.array_value.
      None of these property paths may contain the `__key__` property name.
    readOptions: The options for this lookup request.
  """

  databaseId = _messages.StringField(1)
  keys = _messages.MessageField('Key', 2, repeated=True)
  propertyMask = _messages.StringField(3)
  readOptions = _messages.MessageField('ReadOptions', 4)


class LookupResponse(_messages.Message):
  """The response for google.datastore.v1beta3.Datastore.Lookup.

  Fields:
    deferred: A list of keys that were not looked up due to resource
      constraints. The order of results in this field is undefined and has no
      relation to the order of the keys in the input.
    found: Entities found as `ResultType.FULL` entities. The order of results
      in this field is undefined and has no relation to the order of the keys
      in the input.
    missing: Entities not found as `ResultType.KEY_ONLY` entities. The order
      of results in this field is undefined and has no relation to the order
      of the keys in the input.
    transaction: The transaction that was started as part of this Lookup
      request. Set only when
      google.datastore.v1beta3.ReadOptions.begin_transaction was set in
      google.datastore.v1beta3.LookupRequest.read_options.
  """

  deferred = _messages.MessageField('Key', 1, repeated=True)
  found = _messages.MessageField('EntityResult', 2, repeated=True)
  missing = _messages.MessageField('EntityResult', 3, repeated=True)
  transaction = _messages.BytesField(4)


class MultiWatchRequest(_messages.Message):
  """A request for google.datastore.v1beta3.DatastoreWatcher.MultiWatch

  Fields:
    addTargets: TODO(user): Switch to a non-batching API. The set of watch
      targets to add to this stream. changes will be returned with server
      assigned `target_ids` in the same order as targets are specified here.
    databaseId: Database ID against which to make the request.
    removeTargets: The IDs of watch targets to remove from this stream.
  """

  addTargets = _messages.MessageField('WatchTarget', 1, repeated=True)
  databaseId = _messages.StringField(2)
  removeTargets = _messages.IntegerField(3, repeated=True, variant=_messages.Variant.INT32)


class Mutation(_messages.Message):
  """A mutation to apply to an entity.

  Fields:
    baseVersion: The version of the entity that this mutation is being applied
      to. If this does not match the current version on the server, the
      mutation conflicts.
    delete: The key of the entity to delete. The entity may or may not already
      exist. Must have a complete key path and must not be reserved/read-only.
    insert: The entity to insert. The entity must not already exist. The
      entity key's final path element may be incomplete.
    propertyMask: The properties to write in this mutation. This field is
      ignored for `delete`.  If the entity already exists, only properties
      referenced in the mask are updated, others are left untouched.
      Properties referenced in the mask but not in the entity are deleted.
      Properties not referenced in the mask may not be set in the entity.  The
      paths in the mask follow the same rules as specified in
      google.datastore.v1beta3.LookupRequest.property_mask. Additionally, none
      of these property paths may contain a
      google.datastore.v1beta3.Entity.properties.
    update: The entity to update. The entity must already exist. Must have a
      complete key path.
    upsert: The entity to upsert. The entity may or may not already exist. The
      entity key's final path element may be incomplete.
  """

  baseVersion = _messages.IntegerField(1)
  delete = _messages.MessageField('Key', 2)
  insert = _messages.MessageField('Entity', 3)
  propertyMask = _messages.StringField(4)
  update = _messages.MessageField('Entity', 5)
  upsert = _messages.MessageField('Entity', 6)


class MutationResult(_messages.Message):
  """The result of applying a mutation.

  Fields:
    conflictDetected: Whether a conflict was detected for this mutation.
      Always false when a conflict detection strategy field is not set in the
      mutation.
    key: The automatically allocated key. Set only when the mutation allocated
      a key.
    version: The version of the entity on the server after processing the
      mutation. If the mutation doesn't change anything on the server, then
      the version will be the version of the current entity or, if no entity
      is present, a version that is strictly greater than the version of any
      previous entity and less than the version of any possible future entity.
  """

  conflictDetected = _messages.BooleanField(1)
  key = _messages.MessageField('Key', 2)
  version = _messages.IntegerField(3)


class Operation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If true, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping
      above, the `name` should have the format of
      `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class PartitionId(_messages.Message):
  """A partition ID identifies a grouping of entities. The grouping is always
  by project and namespace, however the namespace ID may be empty.  A
  partition ID contains several dimensions: project ID and namespace ID.
  Partition dimensions:  - May be `""`. - Must be valid UTF-8 bytes. - Must
  have values that match regex `[A-Za-z\d\.\-_]{1,100}` If the value of any
  dimension matches regex `__.*__`, the partition is reserved/read-only. A
  reserved/read-only partition ID is forbidden in certain documented contexts.
  Foreign partition IDs (in which the project ID does not match the context
  project ID ) are discouraged. Reads and writes of foreign partition IDs may
  fail if the project is not in an active state.

  Fields:
    databaseId: If not empty, the ID of the database to which the entities
      belong.
    namespaceId: If not empty, the ID of the namespace to which the entities
      belong.
    projectId: The ID of the project to which the entities belong.
  """

  databaseId = _messages.StringField(1)
  namespaceId = _messages.StringField(2)
  projectId = _messages.StringField(3)


class PathElement(_messages.Message):
  """A (kind, ID/name) pair used to construct a key path.  If either name or
  ID is set, the element is complete. If neither is set, the element is
  incomplete.

  Fields:
    id: The auto-allocated ID of the entity. Never equal to zero. Values less
      than zero are discouraged and may not be supported in the future.
    kind: The kind of the entity. A kind matching regex `__.*__` is reserved
      /read-only. A kind must not contain more than 1500 bytes when UTF-8
      encoded. Cannot be `""`.
    name: The name of the entity. A name matching regex `__.*__` is reserved
      /read-only. A name must not be more than 1500 bytes when UTF-8 encoded.
      Cannot be `""`.
  """

  id = _messages.IntegerField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)


class Progress(_messages.Message):
  """Measures the progress of a particular metric.

  Fields:
    workCompleted: Note that this may be greater than work_estimated.
    workEstimated: An estimate of how much work needs to be performed.  May be
      zero if the work estimate is unavailable.
  """

  workCompleted = _messages.IntegerField(1)
  workEstimated = _messages.IntegerField(2)


class Projection(_messages.Message):
  """A representation of a property in a projection.

  Fields:
    property: The property to project.
  """

  property = _messages.MessageField('PropertyReference', 1)


class PropertyFilter(_messages.Message):
  """A filter on a specific property.

  Enums:
    OpValueValuesEnum: The operator to filter by.

  Fields:
    op: The operator to filter by.
    property: The property to filter by.
    value: The value to compare the property to.
  """

  class OpValueValuesEnum(_messages.Enum):
    """The operator to filter by.

    Values:
      OPERATOR_UNSPECIFIED: Unspecified. This value must not be used.
      LESS_THAN: Less than.
      LESS_THAN_OR_EQUAL: Less than or equal.
      GREATER_THAN: Greater than.
      GREATER_THAN_OR_EQUAL: Greater than or equal.
      EQUAL: Equal.
      HAS_ANCESTOR: Has ancestor.
    """
    OPERATOR_UNSPECIFIED = 0
    LESS_THAN = 1
    LESS_THAN_OR_EQUAL = 2
    GREATER_THAN = 3
    GREATER_THAN_OR_EQUAL = 4
    EQUAL = 5
    HAS_ANCESTOR = 6

  op = _messages.EnumField('OpValueValuesEnum', 1)
  property = _messages.MessageField('PropertyReference', 2)
  value = _messages.MessageField('Value', 3)


class PropertyOrder(_messages.Message):
  """The desired order for a specific property.

  Enums:
    DirectionValueValuesEnum: The direction to order by. Defaults to
      `ASCENDING`.

  Fields:
    direction: The direction to order by. Defaults to `ASCENDING`.
    property: The property to order by.
  """

  class DirectionValueValuesEnum(_messages.Enum):
    """The direction to order by. Defaults to `ASCENDING`.

    Values:
      DIRECTION_UNSPECIFIED: Unspecified. This value must not be used.
      ASCENDING: Ascending.
      DESCENDING: Descending.
    """
    DIRECTION_UNSPECIFIED = 0
    ASCENDING = 1
    DESCENDING = 2

  direction = _messages.EnumField('DirectionValueValuesEnum', 1)
  property = _messages.MessageField('PropertyReference', 2)


class PropertyReference(_messages.Message):
  """A reference to a property relative to the kind expressions.

  Fields:
    name: The name of the property. If name includes "."s, it may be
      interpreted as a property name path.
  """

  name = _messages.StringField(1)


class Query(_messages.Message):
  """A query for entities.

  Fields:
    distinctOn: The properties to make distinct. The query results will
      contain the first result for each distinct combination of values for the
      given properties (if empty, all results are returned).
    endCursor: An ending point for the query results. Query cursors are
      returned in query result batches.
    filter: The filter to apply.
    kind: The kinds to query (if empty, returns entities of all kinds).
      Currently at most 1 kind may be specified.
    limit: The maximum number of results to return. Applies after all other
      constraints. Optional. Unspecified is interpreted as no limit. Must be
      >= 0 if specified.
    offset: The number of results to skip. Applies before limit, but after all
      other constraints. Optional. Must be >= 0 if specified.
    order: The order to apply to the query results (if empty, order is
      unspecified).
    projection: The projection to return. Defaults to returning all
      properties.
    startCursor: A starting point for the query results. Query cursors are
      returned in query result batches.
  """

  distinctOn = _messages.MessageField('PropertyReference', 1, repeated=True)
  endCursor = _messages.BytesField(2)
  filter = _messages.MessageField('Filter', 3)
  kind = _messages.MessageField('KindExpression', 4, repeated=True)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  offset = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  order = _messages.MessageField('PropertyOrder', 7, repeated=True)
  projection = _messages.MessageField('Projection', 8, repeated=True)
  startCursor = _messages.BytesField(9)


class QueryResultBatch(_messages.Message):
  """A batch of results produced by a query.

  Enums:
    EntityResultTypeValueValuesEnum: The result type for every entity in
      `entity_results`.
    MoreResultsValueValuesEnum: The state of the query after the current
      batch.

  Fields:
    endCursor: A cursor that points to the position after the last result in
      the batch.
    entityResultType: The result type for every entity in `entity_results`.
    entityResults: The results for this batch.
    moreResults: The state of the query after the current batch.
    skippedCursor: A cursor that points to the position after the last skipped
      result. Will be set when `skipped_results` != 0.
    skippedResults: The number of results skipped, typically because of an
      offset.
    snapshotVersion: The version number of the snapshot this batch was
      returned from. This applies to the range of results from the query's
      `start_cursor` (or the beginning of the query if no cursor was given) to
      this batch's `end_cursor` (not the query's `end_cursor`).  In a single
      transaction, subsequent query result batches for the same query can have
      a greater snapshot version number. Each batch's snapshot version is
      valid for all preceding batches.
  """

  class EntityResultTypeValueValuesEnum(_messages.Enum):
    """The result type for every entity in `entity_results`.

    Values:
      RESULT_TYPE_UNSPECIFIED: Unspecified. This value is never used.
      FULL: The key and properties.
      PROJECTION: A projected subset of properties. The entity may have no
        key.
      KEY_ONLY: Only the key.
    """
    RESULT_TYPE_UNSPECIFIED = 0
    FULL = 1
    PROJECTION = 2
    KEY_ONLY = 3

  class MoreResultsValueValuesEnum(_messages.Enum):
    """The state of the query after the current batch.

    Values:
      MORE_RESULTS_TYPE_UNSPECIFIED: Unspecified. This value is never used.
      NOT_FINISHED: There may be additional batches to fetch from this query.
      MORE_RESULTS_AFTER_LIMIT: The query is finished, but there may be more
        results after the limit.
      MORE_RESULTS_AFTER_CURSOR: The query is finished, but there may be more
        results after the end cursor.
      NO_MORE_RESULTS: The query has been exhausted.
    """
    MORE_RESULTS_TYPE_UNSPECIFIED = 0
    NOT_FINISHED = 1
    MORE_RESULTS_AFTER_LIMIT = 2
    MORE_RESULTS_AFTER_CURSOR = 3
    NO_MORE_RESULTS = 4

  endCursor = _messages.BytesField(1)
  entityResultType = _messages.EnumField('EntityResultTypeValueValuesEnum', 2)
  entityResults = _messages.MessageField('EntityResult', 3, repeated=True)
  moreResults = _messages.EnumField('MoreResultsValueValuesEnum', 4)
  skippedCursor = _messages.BytesField(5)
  skippedResults = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  snapshotVersion = _messages.IntegerField(7)


class ReadOnly(_messages.Message):
  """Options specific to read-only transactions."""


class ReadOptions(_messages.Message):
  """The options shared by read requests.

  Enums:
    ReadConsistencyValueValuesEnum: The non-transactional read consistency to
      use. Cannot be set to `STRONG` for global queries.

  Fields:
    newTransaction: Options for beginning a new transaction for this request.
      The new transaction handle will be returned in the corresponding
      response as either google.datastore.v1beta3.LookupResponse.transaction
      or google.datastore.v1beta3.RunQueryResponse.transaction.
    readConsistency: The non-transactional read consistency to use. Cannot be
      set to `STRONG` for global queries.
    transaction: The transaction in which to read.
  """

  class ReadConsistencyValueValuesEnum(_messages.Enum):
    """The non-transactional read consistency to use. Cannot be set to
    `STRONG` for global queries.

    Values:
      READ_CONSISTENCY_UNSPECIFIED: Unspecified. This value must not be used.
      STRONG: Strong consistency.
      EVENTUAL: Eventual consistency.
    """
    READ_CONSISTENCY_UNSPECIFIED = 0
    STRONG = 1
    EVENTUAL = 2

  newTransaction = _messages.MessageField('TransactionOptions', 1)
  readConsistency = _messages.EnumField('ReadConsistencyValueValuesEnum', 2)
  transaction = _messages.BytesField(3)


class ReadWrite(_messages.Message):
  """Options specific to read / write transactions."""


class Rectangle(_messages.Message):
  """A "rectangle" on the surface of the Earth, defined as the area between
  two meridians and two parallels.

  Fields:
    northeast: The northeast point of the rectangle. Its latitude must be not
      less than that of the southwest point.
    southwest: The southwest point of the rectangle.
  """

  northeast = _messages.MessageField('LatLng', 1)
  southwest = _messages.MessageField('LatLng', 2)


class RollbackRequest(_messages.Message):
  """The request for google.datastore.v1beta3.Datastore.Rollback.

  Fields:
    databaseId: If not empty, the ID of the database against which to make the
      request.
    transaction: The transaction identifier, returned by a call to
      google.datastore.v1beta3.Datastore.BeginTransaction.
  """

  databaseId = _messages.StringField(1)
  transaction = _messages.BytesField(2)


class RollbackResponse(_messages.Message):
  """The response for google.datastore.v1beta3.Datastore.Rollback (an empty
  message).
  """



class RunQueryRequest(_messages.Message):
  """The request for google.datastore.v1beta3.Datastore.RunQuery.

  Fields:
    databaseId: If not empty, the ID of the database against which to make the
      request.
    gqlQuery: The GQL query to run.
    partitionId: Entities are partitioned into subsets, identified by a
      partition ID. Queries are scoped to a single partition. This partition
      ID is normalized with the standard default context partition ID.
    propertyMask: The properties to return. This field must not be set for a
      projection query.  See
      google.datastore.v1beta3.LookupRequest.property_mask.
    query: The query to run.
    readOptions: The options for this query.
  """

  databaseId = _messages.StringField(1)
  gqlQuery = _messages.MessageField('GqlQuery', 2)
  partitionId = _messages.MessageField('PartitionId', 3)
  propertyMask = _messages.StringField(4)
  query = _messages.MessageField('Query', 5)
  readOptions = _messages.MessageField('ReadOptions', 6)


class RunQueryResponse(_messages.Message):
  """The response for google.datastore.v1beta3.Datastore.RunQuery.

  Fields:
    batch: A batch of query results (always present).
    query: The parsed form of the `GqlQuery` from the request, if it was set.
    transaction: The transaction that was started as part of this RunQuery
      request. Set only when
      google.datastore.v1beta3.ReadOptions.begin_transaction was set in
      google.datastore.v1beta3.RunQueryRequest.read_options.
  """

  batch = _messages.MessageField('QueryResultBatch', 1)
  query = _messages.MessageField('Query', 2)
  transaction = _messages.BytesField(3)


class StContainsFilter(_messages.Message):
  """A filter that selects geo point values that are within a given region.

  Fields:
    containedIn: A region within which the property's value should be
      contained.
    property: The property to filter by.
  """

  containedIn = _messages.MessageField('GeoRegion', 1)
  property = _messages.MessageField('PropertyReference', 2)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TransactionOptions(_messages.Message):
  """Options for beginning a new transaction. Transactions can be created
  explicitly with calls to google.datastore.v1beta3.Datastore.BeginTransaction
  or implicitly by setting
  google.datastore.v1beta3.ReadOptions.new_transaction in read requests.

  Fields:
    readOnly: The transaction should only allow reads.
    readWrite: The transaction should allow both reads and writes.
  """

  readOnly = _messages.MessageField('ReadOnly', 1)
  readWrite = _messages.MessageField('ReadWrite', 2)


class UpdateIndexMetadata(_messages.Message):
  """Metadata for build index operations.

  Fields:
    common: Metadata common to all Datastore Admin Operations.
    indexDefinition: The index definition.  Handy for filtering.
    indexId: The format matches that of Index.index_id.
  """

  common = _messages.MessageField('CommonMetadata', 1)
  indexDefinition = _messages.MessageField('IndexDefinition', 2)
  indexId = _messages.StringField(3)


class Value(_messages.Message):
  """A message that can hold any of the supported value types and associated
  metadata.

  Enums:
    NullValueValueValuesEnum: A null value.

  Fields:
    arrayValue: An array value. Cannot contain another array value. A `Value`
      instance that sets field `array_value` must not set fields `meaning` or
      `exclude_from_indexes`.
    blobValue: A blob value. May have at most 1,000,000 bytes. When
      `exclude_from_indexes` is false, may have at most 1500 bytes. In JSON
      requests, must be base64-encoded.
    booleanValue: A boolean value.
    doubleValue: A double value.
    entityValue: An entity value.  - May have no key. - May have a key with an
      incomplete key path. - May have a reserved/read-only key.
    excludeFromIndexes: If the value should be excluded from all indexes
      including those defined explicitly.
    geoPointValue: A geo point value representing a point on the surface of
      Earth.
    integerValue: An integer value.
    keyValue: A key value.
    meaning: The `meaning` field should only be populated for backwards
      compatibility.
    nullValue: A null value.
    stringValue: A UTF-8 encoded string value. When `exclude_from_indexes` is
      false (it is indexed) , may have at most 1500 bytes. Otherwise, may be
      set to at least 1,000,000 bytes.
    timestampValue: A timestamp value. When stored in the Datastore, precise
      only to microseconds; any additional precision is rounded down.
  """

  class NullValueValueValuesEnum(_messages.Enum):
    """A null value.

    Values:
      NULL_VALUE: Null value.
    """
    NULL_VALUE = 0

  arrayValue = _messages.MessageField('ArrayValue', 1)
  blobValue = _messages.BytesField(2)
  booleanValue = _messages.BooleanField(3)
  doubleValue = _messages.FloatField(4)
  entityValue = _messages.MessageField('Entity', 5)
  excludeFromIndexes = _messages.BooleanField(6)
  geoPointValue = _messages.MessageField('LatLng', 7)
  integerValue = _messages.IntegerField(8)
  keyValue = _messages.MessageField('Key', 9)
  meaning = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  nullValue = _messages.EnumField('NullValueValueValuesEnum', 11)
  stringValue = _messages.StringField(12)
  timestampValue = _messages.StringField(13)


class WatchChange(_messages.Message):
  """A change to a set of targets being watched. Usually a change to an
  individual entity, but sometimes a change to the set of entities being
  watched.  If a change was requested (for example removing a target) but
  rejected, a change will be returned with `change_type=NO_CHANGE`,
  `target_ids=<relevant ids>`, and `cause=<error>`. .

  Enums:
    NoChangeValueValuesEnum: No change has occurred. Supports providing an
      updated `resume_token` or returning an error.
    TargetChangeValueValuesEnum: The targets associate with this stream have
      changed. The affected targets are listed in `target_ids`.

  Fields:
    cause: The error that resulted in this change, if applicable.
    continued: If true, more changes are needed to construct a consistent
      snapshot.
    entity: The most recent state of an entity that matches the given
      `target_ids`.
    entityRemoved: An entity no longer matches the given `target_ids`. Only
      `entity.key` and `version` are populated.
    filter: A filter to apply to the *set* of entities previously returned for
      the given `target_ids`. Returned when entities may no longer match the
      given `target_ids` but the exact keys are unknown.
    noChange: No change has occurred. Supports providing an updated
      `resume_token` or returning an error.
    resumeToken: A token that provides a compact representation of all the
      changes that have been received by the caller up to this point
      (including this one) that can be used to resume the stream. May not be
      set on every change. Only valid for the targets specified in
      `target_ids`.
    targetChange: The targets associate with this stream have changed. The
      affected targets are listed in `target_ids`.
    targetIds: The set of targets to which this change applies. When empty,
      the change applies to all targets.
  """

  class NoChangeValueValuesEnum(_messages.Enum):
    """No change has occurred. Supports providing an updated `resume_token` or
    returning an error.

    Values:
      NULL_VALUE: Null value.
    """
    NULL_VALUE = 0

  class TargetChangeValueValuesEnum(_messages.Enum):
    """The targets associate with this stream have changed. The affected
    targets are listed in `target_ids`.

    Values:
      TARGET_CHANGE_UNSPECIFIED: <no description>
      TARGET_ADDED: <no description>
      TARGET_REMOVED: <no description>
    """
    TARGET_CHANGE_UNSPECIFIED = 0
    TARGET_ADDED = 1
    TARGET_REMOVED = 2

  cause = _messages.MessageField('Status', 1)
  continued = _messages.BooleanField(2)
  entity = _messages.MessageField('EntityResult', 3)
  entityRemoved = _messages.MessageField('EntityResult', 4)
  filter = _messages.MessageField('ExistenceFilter', 5)
  noChange = _messages.EnumField('NoChangeValueValuesEnum', 6)
  resumeToken = _messages.BytesField(7)
  targetChange = _messages.EnumField('TargetChangeValueValuesEnum', 8)
  targetIds = _messages.IntegerField(9, repeated=True, variant=_messages.Variant.INT32)


class WatchRequest(_messages.Message):
  """The request for google.datastore.v1beta3.DatastoreWatcher.Watch

  Fields:
    databaseId: Database ID against which to make the request.
    targets: The set of watcher targets to include in the stream. changes will
      be returned with server assigned `target_ids` in the same order as the
      targets are specified here.
  """

  databaseId = _messages.StringField(1)
  targets = _messages.MessageField('WatchTarget', 2, repeated=True)


class WatchTarget(_messages.Message):
  """A specification of a set of entities to watch.

  Fields:
    gqlQuery: The GQL query to watch.
    partitionId: The partition id to watch.
    query: The query to watch.
    resumeToken: A resume token from a stream containing an identical watch
      target.
    targetId: A previously assigned target id. Used to preserve target ids
      when restarting a stream. All targets with previously assigned target
      ids must be added before any new targets.
  """

  gqlQuery = _messages.MessageField('GqlQuery', 1)
  partitionId = _messages.MessageField('PartitionId', 2)
  query = _messages.MessageField('Query', 3)
  resumeToken = _messages.BytesField(4)
  targetId = _messages.IntegerField(5, variant=_messages.Variant.INT32)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'datastore')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'datastore')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'datastore')
