/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.GenericScanner;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.view.ScanStatus;
import org.zaproxy.zap.view.ZapToggleButton;

public abstract class ScanPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    public String prefix;
    private ExtensionAdaptor extension = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JLabel scannedCountNameLabel = null;
    private JLabel foundCountNameLabel = null;
    private List<String> activeScans = new ArrayList<String>();
    private String currentSite = null;
    private JComboBox<String> siteSelect = null;
    private SortedComboBoxModel<String> siteModel = new SortedComboBoxModel();
    private JButton startScanButton = null;
    private JButton stopScanButton = null;
    private ZapToggleButton pauseScanButton = null;
    private JButton optionsButton = null;
    private JProgressBar progressBar = null;
    private Map<String, GenericScanner> scanMap = new HashMap<String, GenericScanner>();
    private AbstractParam scanParam = null;
    private ScanStatus scanStatus = null;
    private Control.Mode mode = Control.getSingleton().getMode();
    private static Logger log = Logger.getLogger(ScanPanel.class);

    public ScanPanel(String string, ImageIcon imageIcon, ExtensionAdaptor extensionAdaptor, AbstractParam abstractParam) {
        this.prefix = string;
        this.extension = extensionAdaptor;
        this.scanParam = abstractParam;
        this.initialize(imageIcon);
        log.debug((Object)("Constructor " + string));
    }

    private void initialize(ImageIcon imageIcon) {
        this.setLayout(new CardLayout());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(474, 251);
        }
        this.setName(Constant.messages.getString(this.prefix + ".panel.title"));
        this.setIcon(imageIcon);
        this.add((Component)this.getPanelCommand(), this.prefix + ".panel");
        this.scanStatus = new ScanStatus(imageIcon, Constant.messages.getString(this.prefix + ".panel.title"));
        if (View.isInitialised()) {
            View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName(this.prefix + ".panel");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getPanelToolbar(), gridBagConstraints);
            this.panelCommand.add(this.getWorkPanel(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    protected GridBagConstraints getGBC(int n, int n2) {
        return this.getGBC(n, n2, 0.0, new Insets(0, 2, 0, 0));
    }

    protected GridBagConstraints getGBC(int n, int n2, double d, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        if (d > 0.0) {
            gridBagConstraints.fill = 2;
        }
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName(this.prefix + ".toolbar");
            int n = 0;
            n = this.addToolBarElements(this.panelToolbar, Location.start, n);
            this.panelToolbar.add((Component)new JLabel(Constant.messages.getString(this.prefix + ".toolbar.site.label")), this.getGBC(n++, 0));
            this.panelToolbar.add(this.getSiteSelect(), this.getGBC(n++, 0));
            n = this.addToolBarElements(this.panelToolbar, Location.beforeButtons, n);
            this.panelToolbar.add((Component)this.getStartScanButton(), this.getGBC(n++, 0));
            this.panelToolbar.add((Component)this.getPauseScanButton(), this.getGBC(n++, 0));
            this.panelToolbar.add((Component)this.getStopScanButton(), this.getGBC(n++, 0));
            n = this.addToolBarElements(this.panelToolbar, Location.beforeProgressBar, n);
            this.panelToolbar.add((Component)this.getProgressBar(), this.getGBC(n++, 0, 1.0, new Insets(0, 5, 0, 5)));
            this.panelToolbar.add((Component)this.getActiveScansNameLabel(), this.getGBC(n++, 0));
            this.panelToolbar.add((Component)this.getActiveScansValueLabel(), this.getGBC(n++, 0));
            n = this.addToolBarElements(this.panelToolbar, Location.afterProgressBar, n);
            this.panelToolbar.add((Component)new JLabel(), this.getGBC(n++, 0, 1.0, new Insets(0, 0, 0, 0)));
            this.panelToolbar.add((Component)this.getOptionsButton(), this.getGBC(n++, 0));
        }
        return this.panelToolbar;
    }

    protected int addToolBarElements(JToolBar jToolBar, Location location, int n) {
        return n;
    }

    private JLabel getActiveScansNameLabel() {
        if (this.scannedCountNameLabel == null) {
            this.scannedCountNameLabel = new JLabel();
            this.scannedCountNameLabel.setText(Constant.messages.getString(this.prefix + ".toolbar.ascans.label"));
        }
        return this.scannedCountNameLabel;
    }

    private JLabel getActiveScansValueLabel() {
        if (this.foundCountNameLabel == null) {
            this.foundCountNameLabel = new JLabel();
            this.foundCountNameLabel.setText(String.valueOf(this.activeScans.size()));
        }
        return this.foundCountNameLabel;
    }

    private void setActiveScanLabels() {
        if (EventQueue.isDispatchThread()) {
            this.setActiveScanLabelsEventHandler();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ScanPanel.this.setActiveScanLabelsEventHandler();
                    }
                });
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void setActiveScanLabelsEventHandler() {
        this.getActiveScansValueLabel().setText(String.valueOf(this.activeScans.size()));
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.activeScans.iterator();
        stringBuilder.append("<html>");
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</html>");
        String string = stringBuilder.toString();
        this.getActiveScansNameLabel().setToolTipText(string);
        this.getActiveScansValueLabel().setToolTipText(string);
        this.scanStatus.setScanCount(this.activeScans.size());
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setSize(new Dimension(80, 20));
            this.progressBar.setStringPainted(true);
            this.progressBar.setEnabled(false);
        }
        return this.progressBar;
    }

    private JButton getStartScanButton() {
        if (this.startScanButton == null) {
            this.startScanButton = new JButton();
            this.startScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.start"));
            this.startScanButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png")));
            this.startScanButton.setEnabled(false);
            this.startScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanPanel.this.startScan();
                }
            });
        }
        return this.startScanButton;
    }

    private JButton getStopScanButton() {
        if (this.stopScanButton == null) {
            this.stopScanButton = new JButton();
            this.stopScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.stop"));
            this.stopScanButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/142.png")));
            this.stopScanButton.setEnabled(false);
            this.stopScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanPanel.this.stopScan(ScanPanel.this.currentSite);
                }
            });
        }
        return this.stopScanButton;
    }

    private JToggleButton getPauseScanButton() {
        if (this.pauseScanButton == null) {
            this.pauseScanButton = new ZapToggleButton();
            this.pauseScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.pause"));
            this.pauseScanButton.setSelectedToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.unpause"));
            this.pauseScanButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/141.png")));
            this.pauseScanButton.setRolloverIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/141.png")));
            this.pauseScanButton.setSelectedIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png")));
            this.pauseScanButton.setRolloverSelectedIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png")));
            this.pauseScanButton.setEnabled(false);
            this.pauseScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanPanel.this.pauseScan(ScanPanel.this.currentSite);
                }
            });
        }
        return this.pauseScanButton;
    }

    private JButton getOptionsButton() {
        if (this.optionsButton == null) {
            this.optionsButton = new JButton();
            this.optionsButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.options"));
            this.optionsButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/041.png")));
            this.optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString(ScanPanel.this.prefix + ".options.title"));
                }
            });
        }
        return this.optionsButton;
    }

    protected JComboBox<String> getSiteSelect() {
        if (this.siteSelect == null) {
            this.siteSelect = new JComboBox<String>(this.siteModel);
            this.siteSelect.addItem(Constant.messages.getString(this.prefix + ".toolbar.site.select"));
            this.siteSelect.setSelectedIndex(0);
            this.siteSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)ScanPanel.this.siteSelect.getSelectedItem();
                    if (string != null && ScanPanel.this.siteSelect.getSelectedIndex() > 0) {
                        ScanPanel.this.siteSelected(string);
                    } else {
                        ScanPanel.this.siteSelected(null);
                    }
                }
            });
        }
        return this.siteSelect;
    }

    public boolean isScanning(SiteNode siteNode, boolean bl) {
        GenericScanner genericScanner;
        String string = this.getSiteFromLabel(ScanPanel.cleanSiteName(siteNode, bl));
        if (string != null && (genericScanner = this.scanMap.get(string)) != null) {
            return genericScanner.isRunning();
        }
        return false;
    }

    public void scanAllInScope() {
        log.debug((Object)"scanSite (all in scope)");
        this.setTabFocus();
        if (this.getStartScanButton().isEnabled()) {
            this.startScan(null, true, true, null, null);
        }
    }

    public void scanAllInContext(Context context) {
        this.scanAllInContext(context, null);
    }

    public void scanAllInContext(Context context, User user) {
        log.debug((Object)("Scan all in context: " + context.getName()));
        this.setTabFocus();
        if (this.getStartScanButton().isEnabled()) {
            this.startScan(null, true, true, context, user);
        }
    }

    public void scanSite(SiteNode siteNode, boolean bl) {
        log.debug((Object)("scanSite " + this.prefix + " node=" + siteNode.getNodeName()));
        this.setTabFocus();
        this.nodeSelected(siteNode, bl);
        if (this.currentSite != null && this.getStartScanButton().isEnabled()) {
            this.startScan(siteNode, false, true, null, null);
        }
    }

    public void scanNode(SiteNode siteNode, boolean bl) {
        this.scanNode(siteNode, bl, null);
    }

    public void scanNode(SiteNode siteNode, boolean bl, User user) {
        log.debug((Object)("scanNode" + this.prefix + " node=" + siteNode.getNodeName()));
        this.setTabFocus();
        this.nodeSelected(siteNode, bl);
        if (this.currentSite != null && this.getStartScanButton().isEnabled()) {
            this.startScan(siteNode, false, false, null, user);
        }
    }

    private String activeSitelabel(String string) {
        return "<html><b>" + string + "</b></html>";
    }

    private String passiveSitelabel(String string) {
        return "<html>" + string + "</html>";
    }

    private String getSiteFromLabel(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("<html><b>")) {
            return string.substring(9, string.indexOf("</b>"));
        }
        if (string.startsWith("<html>")) {
            return string.substring(6, string.indexOf("</html>"));
        }
        return string;
    }

    public void addSite(String string, boolean bl) {
        if (!this.isSiteAdded(string = ScanPanel.cleanSiteName(string, bl))) {
            this.addSite(string);
        }
    }

    private boolean isSiteAdded(String string) {
        return this.siteModel.getIndexOf(this.activeSitelabel(string)) != -1 || this.siteModel.getIndexOf(this.passiveSitelabel(string)) != -1;
    }

    private void addSite(String string) {
        log.debug((Object)("addSite " + string));
        this.siteModel.addElement(this.passiveSitelabel(string));
    }

    protected void siteSelected(String string) {
        this.siteSelected(string, false);
    }

    protected void siteSelected(String string, boolean bl) {
        if (string == null) {
            this.currentSite = null;
            this.switchView("");
            this.resetScanState();
            return;
        }
        if (Control.Mode.safe.equals((Object)this.mode)) {
            return;
        }
        string = this.getSiteFromLabel(string);
        if (bl || !string.equals(this.currentSite)) {
            if (!this.isSiteAdded(string)) {
                return;
            }
            if (this.siteModel.getIndexOf(this.passiveSitelabel(string)) < 0) {
                this.siteModel.setSelectedItem(this.activeSitelabel(string));
            } else {
                this.siteModel.setSelectedItem(this.passiveSitelabel(string));
            }
            GenericScanner genericScanner = this.scanMap.get(string);
            if (genericScanner == null) {
                genericScanner = this.newScanThread(string, this.scanParam);
                this.scanMap.put(string, genericScanner);
            }
            if (genericScanner.isRunning()) {
                this.getStartScanButton().setEnabled(false);
                this.getStopScanButton().setEnabled(true);
                this.getPauseScanButton().setEnabled(true);
                this.getPauseScanButton().setSelected(genericScanner.isPaused());
                this.getProgressBar().setEnabled(true);
            } else {
                this.resetScanButtonsAndProgressBarStates(true);
            }
            this.getProgressBar().setValue(genericScanner.getProgress());
            this.getProgressBar().setMaximum(genericScanner.getMaximum());
            this.currentSite = string;
            this.switchView(this.currentSite);
        }
        if (Control.Mode.protect.equals((Object)this.mode) && !Model.getSingleton().getSession().isInScope(this.getSiteNode(this.currentSite))) {
            this.resetScanButtonsAndProgressBarStates(false);
        }
    }

    private void resetScanButtonsAndProgressBarStates(boolean bl) {
        this.getStartScanButton().setEnabled(bl);
        this.getStopScanButton().setEnabled(false);
        this.getPauseScanButton().setEnabled(false);
        this.getPauseScanButton().setSelected(false);
        this.getProgressBar().setEnabled(false);
    }

    public static String cleanSiteName(String string, boolean bl) {
        boolean bl2 = false;
        if (string.toLowerCase().startsWith("https:")) {
            bl2 = true;
        }
        if (string.indexOf("//") >= 0) {
            string = string.substring(string.indexOf("//") + 2);
        }
        if (string.indexOf(" (") >= 0) {
            string = string.substring(0, string.indexOf(" ("));
        }
        if (string.indexOf(":") >= 0) {
            if (!bl) {
                string = string.substring(0, string.indexOf(":"));
            }
        } else if (bl) {
            string = bl2 ? string + ":443" : string + ":80";
        }
        return string;
    }

    public static String cleanSiteName(SiteNode siteNode, boolean bl) {
        if (siteNode != null) {
            while (siteNode.getParent() != null && siteNode.getParent().getParent() != null) {
                siteNode = (SiteNode)siteNode.getParent();
            }
            return ScanPanel.cleanSiteName(siteNode.getNodeName(), bl);
        }
        return null;
    }

    protected SiteNode getSiteNode(String string) {
        SiteMap siteMap = this.getExtension().getModel().getSession().getSiteTree();
        SiteNode siteNode = (SiteNode)siteMap.getRoot();
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            String string2 = siteNode2.getNodeName();
            if (string2.toLowerCase().startsWith("https:") && !ScanPanel.hasPort(string2)) {
                string2 = string2 + ":443";
            }
            if (string2.toLowerCase().startsWith("http:") && !ScanPanel.hasPort(string2)) {
                string2 = string2 + ":80";
            }
            if (string2.indexOf("//") >= 0) {
                string2 = string2.substring(string2.indexOf("//") + 2);
            }
            if (!string.equals(string2)) continue;
            return siteNode2;
        }
        return null;
    }

    private static boolean hasPort(String string) {
        return string.lastIndexOf(":") != string.indexOf(":");
    }

    public void nodeSelected(SiteNode siteNode, boolean bl) {
        String string = ScanPanel.cleanSiteName(siteNode, bl);
        if (!this.isSiteAdded(string)) {
            this.addSite(string);
        }
        this.siteSelected(string);
    }

    protected abstract GenericScanner newScanThread(String var1, AbstractParam var2);

    protected void startScan() {
        this.startScan(null, false, true, null, null);
    }

    protected void startSan(SiteNode siteNode, boolean bl, boolean bl2, Context context) {
        this.startScan(siteNode, bl, bl2, context, null);
    }

    protected void startScan(SiteNode siteNode, boolean bl, boolean bl2, Context context, User user) {
        this.startScan(siteNode, bl, bl2, context, user, null);
    }

    protected void handleContextSpecificObject(GenericScanner genericScanner, Object[] objectArray) {
    }

    protected void startScan(SiteNode siteNode, boolean bl, boolean bl2, Context context, User user, Object[] objectArray) {
        log.debug((Object)("startScan " + this.prefix + " " + siteNode));
        this.getStartScanButton().setEnabled(false);
        this.getStopScanButton().setEnabled(true);
        this.getPauseScanButton().setEnabled(true);
        this.activeScans.add(this.currentSite);
        GenericScanner genericScanner = this.scanMap.get(this.currentSite);
        if (genericScanner.isStopped()) {
            genericScanner.reset();
            genericScanner = this.newScanThread(this.currentSite, this.scanParam);
            this.scanMap.put(this.currentSite, genericScanner);
        }
        if (bl) {
            genericScanner.setStartNode(null);
            genericScanner.setJustScanInScope(true);
            genericScanner.setScanContext(context);
        } else {
            genericScanner.setJustScanInScope(false);
            genericScanner.setScanContext(null);
            if (genericScanner.getStartNode() == null) {
                genericScanner.setStartNode(siteNode);
            }
        }
        genericScanner.setScanAsUser(user);
        if (context != null) {
            genericScanner.setTechSet(context.getTechSet());
        }
        genericScanner.setScanChildren(bl2);
        if (objectArray != null) {
            this.handleContextSpecificObject(genericScanner, objectArray);
        }
        genericScanner.start();
        this.scanMap.put(this.currentSite, genericScanner);
        this.setActiveScanLabels();
        this.getProgressBar().setEnabled(true);
        this.getProgressBar().setMaximum(genericScanner.getMaximum());
        String string = this.currentSite;
        if (this.siteModel.getIndexOf(this.passiveSitelabel(string)) >= 0) {
            this.siteModel.removeElement(this.passiveSitelabel(string));
            this.siteModel.addElement(this.activeSitelabel(string));
            this.siteModel.setSelectedItem(this.activeSitelabel(string));
        }
        this.switchView(this.currentSite);
    }

    public void stopScan(String string) {
        log.debug((Object)("stopScan " + this.prefix + " on " + string));
        GenericScanner genericScanner = this.scanMap.get(string);
        if (genericScanner != null) {
            genericScanner.stopScan();
        }
    }

    public void pauseScan(String string) {
        log.debug((Object)("pauseScan " + this.prefix + " on " + string));
        GenericScanner genericScanner = this.scanMap.get(string);
        if (genericScanner != null) {
            if (genericScanner.isPaused()) {
                genericScanner.resumeScan();
            } else {
                genericScanner.pauseScan();
            }
        }
    }

    public void scanFinshed(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.scanFinshedEventHandler(string);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanPanel.this.scanFinshedEventHandler(string);
                    }
                });
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void scanFinshedEventHandler(String string) {
        log.debug((Object)("scanFinished " + this.prefix + " on " + this.currentSite));
        if (string != null && string.equals(this.currentSite)) {
            this.resetScanButtonsAndProgressBarStates(true);
        }
        this.activeScans.remove(string);
        this.setActiveScanLabels();
    }

    public void scanProgress(final String string, final int n, final int n2) {
        if (EventQueue.isDispatchThread()) {
            this.scanProgressEventHandler(string, n, n2);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ScanPanel.this.scanProgressEventHandler(string, n, n2);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                log.info((Object)"Interrupt scan progress update on GUI.");
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void scanProgressEventHandler(String string, int n, int n2) {
        if (string.equals(this.currentSite)) {
            this.getProgressBar().setValue(n);
            this.getProgressBar().setMaximum(n2);
        }
    }

    public void reset() {
        log.debug((Object)("reset " + this.prefix));
        this.stopAllScans();
        this.siteModel.removeAllElements();
        this.siteSelect.addItem(Constant.messages.getString(this.prefix + ".toolbar.site.select"));
        this.siteSelect.setSelectedIndex(0);
    }

    private void stopAllScans() {
        for (GenericScanner genericScanner : this.scanMap.values()) {
            genericScanner.stopScan();
            genericScanner.reset();
        }
        for (int i = 0; i < 20 && this.activeScans.size() != 0; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.scanMap.clear();
        this.activeScans.clear();
        this.setActiveScanLabels();
        this.resetScanState();
    }

    private void resetScanState() {
        this.resetScanButtonsAndProgressBarStates(false);
        this.getProgressBar().setValue(0);
    }

    public ExtensionAdaptor getExtension() {
        return this.extension;
    }

    public AbstractParam getScanParam() {
        return this.scanParam;
    }

    public GenericScanner getScanThread(String string) {
        return this.scanMap.get(string);
    }

    public Map<String, GenericScanner> getScanThreads() {
        return this.scanMap;
    }

    public boolean isCurrentSite(String string) {
        return this.currentSite != null && this.currentSite.equals(string);
    }

    public void sessionScopeChanged(Session session) {
        if (this.currentSite != null) {
            this.siteSelected(this.currentSite, true);
        }
    }

    public void sessionModeChanged(Control.Mode mode) {
        this.mode = mode;
        switch (mode) {
            case attack: 
            case standard: 
            case protect: {
                this.getSiteSelect().setEnabled(true);
                if (this.currentSite == null) break;
                this.siteSelected(this.currentSite, true);
                break;
            }
            case safe: {
                this.stopAllScans();
                this.getSiteSelect().setEnabled(false);
            }
        }
    }

    protected String getCurrentSite() {
        return this.currentSite;
    }

    protected void unload() {
        if (View.isInitialised()) {
            View.getSingleton().getMainFrame().getMainFooterPanel().removeFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    protected abstract Component getWorkPanel();

    protected abstract void switchView(String var1);

    protected static enum Location {
        start,
        beforeSites,
        beforeButtons,
        beforeProgressBar,
        afterProgressBar;

    }
}

