/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.StandardParameterParser;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.SingleColumnTableModel;

public class ContextStructurePanel
extends AbstractContextPropertiesPanel {
    private static final String PANEL_NAME = Constant.messages.getString("context.struct.title");
    private static final long serialVersionUID = -1L;
    private JPanel panelSession = null;
    private ZapTextField urlKvPairSeparators = null;
    private ZapTextField urlKeyValueSeparators = null;
    private ZapTextField postKeyValueSeparators = null;
    private ZapTextField postKvPairSeparators = null;
    private JTable tableStructuralParams = null;
    private JScrollPane jScrollPane = null;
    private SingleColumnTableModel model = null;

    public static String getPanelName(int n) {
        return n + ": " + PANEL_NAME;
    }

    public ContextStructurePanel(Context context) {
        super(context.getIndex());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextStructurePanel.getPanelName(this.getContextIndex()));
        this.add((Component)this.getPanel(), this.getPanel().getName());
    }

    private JPanel getPanel() {
        if (this.panelSession == null) {
            this.panelSession = new JPanel();
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.setName("SessionStructure");
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.url.kvpsep")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.panelSession.add((Component)this.getUrlKvPairSeparators(), LayoutHelper.getGBC(1, 0, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.url.kvsep")), LayoutHelper.getGBC(0, 1, 1, 1.0));
            this.panelSession.add((Component)this.getUrlKeyValueSeparators(), LayoutHelper.getGBC(1, 1, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.post.kvpsep")), LayoutHelper.getGBC(0, 2, 1, 1.0));
            this.panelSession.add((Component)this.getPostKvPairSeparators(), LayoutHelper.getGBC(1, 2, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.post.kvsep")), LayoutHelper.getGBC(0, 3, 1, 1.0));
            this.panelSession.add((Component)this.getPostKeyValueSeparators(), LayoutHelper.getGBC(1, 3, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.struct")), LayoutHelper.getGBC(0, 4, 1, 1.0));
            this.panelSession.add((Component)this.getJScrollPane(), LayoutHelper.getGBC(1, 4, 1, 1.0, 1.0, 1, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(), LayoutHelper.getGBC(0, 20, 1, 1.0, 1.0));
        }
        return this.panelSession;
    }

    private ZapTextField getUrlKvPairSeparators() {
        if (this.urlKvPairSeparators == null) {
            this.urlKvPairSeparators = new ZapTextField();
        }
        return this.urlKvPairSeparators;
    }

    private ZapTextField getUrlKeyValueSeparators() {
        if (this.urlKeyValueSeparators == null) {
            this.urlKeyValueSeparators = new ZapTextField();
        }
        return this.urlKeyValueSeparators;
    }

    private ZapTextField getPostKeyValueSeparators() {
        if (this.postKeyValueSeparators == null) {
            this.postKeyValueSeparators = new ZapTextField();
        }
        return this.postKeyValueSeparators;
    }

    private ZapTextField getPostKvPairSeparators() {
        if (this.postKvPairSeparators == null) {
            this.postKvPairSeparators = new ZapTextField();
        }
        return this.postKvPairSeparators;
    }

    private JTable getTableStructualParams() {
        if (this.tableStructuralParams == null) {
            this.tableStructuralParams = new JTable();
            this.tableStructuralParams.setModel(this.getStructuralParamsModel());
            this.tableStructuralParams.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableStructuralParams.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }
        return this.tableStructuralParams;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTableStructualParams());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private SingleColumnTableModel getStructuralParamsModel() {
        if (this.model == null) {
            this.model = new SingleColumnTableModel(Constant.messages.getString("context.struct.table.header.param"));
        }
        return this.model;
    }

    @Override
    public void initContextData(Session session, Context context) {
        StandardParameterParser standardParameterParser;
        ParameterParser parameterParser = context.getUrlParamParser();
        ParameterParser parameterParser2 = context.getPostParamParser();
        if (parameterParser instanceof StandardParameterParser) {
            standardParameterParser = (StandardParameterParser)parameterParser;
            this.getUrlKvPairSeparators().setText(standardParameterParser.getKeyValuePairSeparators());
            this.getUrlKeyValueSeparators().setText(standardParameterParser.getKeyValueSeparators());
            this.getStructuralParamsModel().setLines(standardParameterParser.getStructuralParameters());
        }
        if (parameterParser2 instanceof StandardParameterParser) {
            standardParameterParser = (StandardParameterParser)parameterParser2;
            this.getPostKvPairSeparators().setText(standardParameterParser.getKeyValuePairSeparators());
            this.getPostKeyValueSeparators().setText(standardParameterParser.getKeyValueSeparators());
        }
    }

    @Override
    public void validateContextData(Session session) throws Exception {
        if (this.urlKvPairSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvpsep"));
        }
        if (this.urlKeyValueSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvsep"));
        }
        for (char c : this.urlKvPairSeparators.getText().toCharArray()) {
            if (!this.urlKeyValueSeparators.getText().contains("" + c)) continue;
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.dup"));
        }
        if (this.postKvPairSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvpsep"));
        }
        if (this.postKeyValueSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvsep"));
        }
        for (char c : this.postKvPairSeparators.getText().toCharArray()) {
            if (!this.postKeyValueSeparators.getText().contains("" + c)) continue;
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.dup"));
        }
    }

    private void saveToContext(Context context) {
        StandardParameterParser standardParameterParser;
        ParameterParser parameterParser = context.getUrlParamParser();
        ParameterParser parameterParser2 = context.getPostParamParser();
        if (parameterParser instanceof StandardParameterParser) {
            standardParameterParser = (StandardParameterParser)parameterParser;
            standardParameterParser.setKeyValuePairSeparators(this.getUrlKvPairSeparators().getText());
            standardParameterParser.setKeyValueSeparators(this.getUrlKeyValueSeparators().getText());
            standardParameterParser.setStructuralParameters(this.getStructuralParamsModel().getLines());
            context.setUrlParamParser(standardParameterParser);
        }
        if (parameterParser2 instanceof StandardParameterParser) {
            standardParameterParser = (StandardParameterParser)parameterParser2;
            standardParameterParser.setKeyValuePairSeparators(this.getPostKvPairSeparators().getText());
            standardParameterParser.setKeyValueSeparators(this.getPostKeyValueSeparators().getText());
            context.setPostParamParser(standardParameterParser);
        }
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        Context context = session.getContext(this.getContextIndex());
        this.saveToContext(context);
    }

    @Override
    public void saveTemporaryContextData(Context context) {
        this.saveToContext(context);
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }
}

