/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.response;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpByteHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;

public class ResponseBodyByteHttpPanelViewModel
extends AbstractHttpByteHttpPanelViewModel {
    @Override
    public byte[] getData() {
        if (this.httpMessage == null) {
            return new byte[0];
        }
        if ("gzip".equals(this.httpMessage.getResponseHeader().getHeader("Content-Encoding"))) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.httpMessage.getResponseBody().getBytes());
                GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                InputStreamReader inputStreamReader = new InputStreamReader(gZIPInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuilder stringBuilder = new StringBuilder();
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
                bufferedReader.close();
                inputStreamReader.close();
                gZIPInputStream.close();
                byteArrayInputStream.close();
                return stringBuilder.toString().getBytes();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        return this.httpMessage.getResponseBody().getBytes();
    }

    @Override
    public void setData(byte[] byArray) {
        if (this.httpMessage == null) {
            return;
        }
        if ("gzip".equals(this.httpMessage.getResponseHeader().getHeader("Content-Encoding"))) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)gZIPOutputStream, "UTF-8"));
                bufferedWriter.append(new String(byArray));
                bufferedWriter.close();
                gZIPOutputStream.close();
                byteArrayOutputStream.close();
                this.httpMessage.getResponseBody().setBody(byteArrayOutputStream.toByteArray());
                HttpPanelViewModelUtils.updateResponseContentLength(this.httpMessage);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        } else {
            this.httpMessage.getResponseBody().setBody(byArray);
            HttpPanelViewModelUtils.updateResponseContentLength(this.httpMessage);
        }
    }
}

