/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk.impl.http;

import java.awt.Dimension;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.brk.BreakpointsUiManagerInterface;
import org.zaproxy.zap.extension.brk.ExtensionBreak;
import org.zaproxy.zap.extension.brk.impl.http.BreakAddEditDialog;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointMessage;
import org.zaproxy.zap.extension.brk.impl.http.PopupMenuAddBreakHistory;
import org.zaproxy.zap.extension.brk.impl.http.PopupMenuAddBreakSites;
import org.zaproxy.zap.extension.httppanel.Message;

public class HttpBreakpointsUiManagerInterface
implements BreakpointsUiManagerInterface {
    private BreakAddEditDialog breakDialog = null;
    private ExtensionBreak extensionBreak;
    private PopupMenuAddBreakSites popupMenuAddBreakSites = null;
    private PopupMenuAddBreakHistory popupMenuAddBreakHistory = null;

    public HttpBreakpointsUiManagerInterface(ExtensionHookMenu extensionHookMenu, ExtensionBreak extensionBreak) {
        this.extensionBreak = extensionBreak;
        extensionHookMenu.addPopupMenuItem(this.getPopupMenuAddBreakSites());
        extensionHookMenu.addPopupMenuItem(this.getPopupMenuAddBreakHistory());
    }

    public Class<HttpMessage> getMessageClass() {
        return HttpMessage.class;
    }

    public Class<HttpBreakpointMessage> getBreakpointClass() {
        return HttpBreakpointMessage.class;
    }

    @Override
    public String getType() {
        return "HTTP";
    }

    @Override
    public void handleAddBreakpoint(Message message) {
        this.extensionBreak.dialogShown(ExtensionBreak.DialogType.ADD);
        this.showAddDialog(message);
    }

    public void handleAddBreakpoint(String string) {
        this.extensionBreak.dialogShown(ExtensionBreak.DialogType.ADD);
        this.showAddDialog(string);
    }

    void addBreakpoint(HttpBreakpointMessage httpBreakpointMessage) {
        this.extensionBreak.addBreakpoint(httpBreakpointMessage);
    }

    @Override
    public void handleEditBreakpoint(BreakpointMessageInterface breakpointMessageInterface) {
        this.extensionBreak.dialogShown(ExtensionBreak.DialogType.EDIT);
        this.showEditDialog((HttpBreakpointMessage)breakpointMessageInterface);
    }

    void editBreakpoint(BreakpointMessageInterface breakpointMessageInterface, BreakpointMessageInterface breakpointMessageInterface2) {
        this.extensionBreak.editBreakpoint(breakpointMessageInterface, breakpointMessageInterface2);
    }

    @Override
    public void handleRemoveBreakpoint(BreakpointMessageInterface breakpointMessageInterface) {
        this.extensionBreak.removeBreakpoint(breakpointMessageInterface);
    }

    @Override
    public void reset() {
    }

    private void populateAddDialogAndSetVisible(String string) {
        this.breakDialog.init(new HttpBreakpointMessage(string, HttpBreakpointMessage.Location.url, HttpBreakpointMessage.Match.contains, false, true), true);
        this.breakDialog.setVisible(true);
    }

    private void showAddDialog(Message message) {
        HttpMessage httpMessage = (HttpMessage)message;
        if (httpMessage.getRequestHeader().getURI() != null) {
            this.showAddDialog(httpMessage.getRequestHeader().getURI().toString());
        } else {
            this.showAddDialog("");
        }
    }

    private void showAddDialog(String string) {
        if (this.breakDialog == null) {
            this.breakDialog = new BreakAddEditDialog(this, View.getSingleton().getMainFrame(), new Dimension(407, 255));
        }
        this.populateAddDialogAndSetVisible(string);
    }

    void hideAddDialog() {
        this.breakDialog.dispose();
        this.extensionBreak.dialogClosed();
    }

    private void populateEditDialogAndSetVisible(HttpBreakpointMessage httpBreakpointMessage) {
        this.breakDialog.init(httpBreakpointMessage, false);
        this.breakDialog.setVisible(true);
    }

    private void showEditDialog(HttpBreakpointMessage httpBreakpointMessage) {
        if (this.breakDialog == null) {
            this.breakDialog = new BreakAddEditDialog(this, View.getSingleton().getMainFrame(), new Dimension(407, 255));
        }
        this.populateEditDialogAndSetVisible(httpBreakpointMessage);
    }

    void hideEditDialog() {
        this.breakDialog.dispose();
        this.extensionBreak.dialogClosed();
    }

    private PopupMenuAddBreakSites getPopupMenuAddBreakSites() {
        if (this.popupMenuAddBreakSites == null) {
            this.popupMenuAddBreakSites = new PopupMenuAddBreakSites(this.extensionBreak, this);
        }
        return this.popupMenuAddBreakSites;
    }

    private PopupMenuAddBreakHistory getPopupMenuAddBreakHistory() {
        if (this.popupMenuAddBreakHistory == null) {
            this.popupMenuAddBreakHistory = new PopupMenuAddBreakHistory(this.extensionBreak);
        }
        return this.popupMenuAddBreakHistory;
    }
}

