/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Category;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.VariantUserDefined;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.AbstractParamContainerPanel;
import org.zaproxy.zap.extension.ascan.CustomScanPanel;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.OptionsVariantPanel;
import org.zaproxy.zap.extension.ascan.PolicyAllCategoryPanel;
import org.zaproxy.zap.extension.ascan.PolicyCategoryPanel;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.view.JCheckBoxTree;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class CustomScanDialog
extends StandardFieldsDialog {
    protected static final String[] STD_TAB_LABELS = new String[]{"ascan.custom.tab.scope", "ascan.custom.tab.input", "ascan.custom.tab.custom", "ascan.custom.tab.tech", "ascan.custom.tab.policy"};
    private static final String FIELD_START = "ascan.custom.label.start";
    private static final String FIELD_POLICY = "ascan.custom.label.policy";
    private static final String FIELD_CONTEXT = "ascan.custom.label.context";
    private static final String FIELD_USER = "ascan.custom.label.user";
    private static final String FIELD_RECURSE = "ascan.custom.label.recurse";
    private static final String FIELD_ADVANCED = "ascan.custom.label.adv";
    private static final String FIELD_DISABLE_VARIANTS_MSG = "variant.options.disable";
    private static final Logger logger = Logger.getLogger(CustomScanDialog.class);
    private static final long serialVersionUID = 1L;
    private JButton[] extraButtons = null;
    private ExtensionActiveScan extension = null;
    private final ExtensionUserManagement extUserMgmt = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
    private int headerLength = -1;
    private int urlPathStart = -1;
    private Target target = null;
    private ScannerParam scannerParam = null;
    private OptionsParam optionsParam = null;
    private JPanel customPanel = null;
    private JPanel techPanel = null;
    private ZapTextArea requestField = null;
    private JButton addCustomButton = null;
    private JButton removeCustomButton = null;
    private JList<Highlighter.Highlight> injectionPointList = null;
    private final DefaultListModel<Highlighter.Highlight> injectionPointModel = new DefaultListModel();
    private final JLabel customPanelStatus = new JLabel();
    private JCheckBox disableNonCustomVectors = null;
    private JCheckBoxTree techTree = null;
    private final HashMap<Tech, DefaultMutableTreeNode> techToNodeMap = new HashMap();
    private TreeModel techModel = null;
    private ScanPolicy scanPolicy = null;
    private PolicyAllCategoryPanel policyAllCategoryPanel = null;
    private OptionsVariantPanel variantPanel = null;
    private List<PolicyCategoryPanel> categoryPanels = Collections.emptyList();
    private List<CustomScanPanel> customPanels = null;
    private boolean showingAdvTabs = true;

    public CustomScanDialog(ExtensionActiveScan extensionActiveScan, String[] stringArray, List<CustomScanPanel> list, Frame frame, Dimension dimension) {
        super(frame, "ascan.custom.title", dimension, stringArray);
        this.extension = extensionActiveScan;
        this.customPanels = list;
        this.reset(false);
    }

    public void init(Target target) {
        int n;
        if (target != null) {
            this.target = target;
        }
        logger.debug((Object)("init " + this.target));
        this.removeAllFields();
        this.injectionPointModel.clear();
        this.headerLength = -1;
        this.urlPathStart = -1;
        if (this.scanPolicy == null) {
            this.scanPolicy = this.extension.getPolicyManager().getDefaultScanPolicy();
        }
        this.addTargetSelectField(0, FIELD_START, this.target, false, false);
        this.addComboField(0, FIELD_POLICY, this.extension.getPolicyManager().getAllPolicyNames(), this.scanPolicy.getName());
        this.addComboField(0, FIELD_CONTEXT, new String[0], "");
        this.addComboField(0, FIELD_USER, new String[0], "");
        this.addCheckBoxField(0, FIELD_RECURSE, true);
        this.addCheckBoxField(0, FIELD_ADVANCED, this.extension.getScannerParam().isShowAdvancedDialog());
        this.addFieldListener(FIELD_POLICY, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomScanDialog.this.policySelected();
            }
        });
        this.addPadding(0);
        this.customPanelStatus.setText(Constant.messages.getString("ascan.custom.status.recurse"));
        this.addFieldListener(FIELD_CONTEXT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomScanDialog.this.setUsers();
                CustomScanDialog.this.setTech();
            }
        });
        this.addFieldListener(FIELD_RECURSE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomScanDialog.this.setFieldStates();
            }
        });
        this.addFieldListener(FIELD_ADVANCED, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomScanDialog.this.setAdvancedOptions(CustomScanDialog.this.getBoolValue(CustomScanDialog.FIELD_ADVANCED));
            }
        });
        this.getVariantPanel().initParam(this.scannerParam);
        this.setCustomTabPanel(1, this.getVariantPanel());
        this.setCustomTabPanel(2, this.getCustomPanel());
        this.setCustomTabPanel(3, this.getTechPanel());
        AbstractParamContainerPanel abstractParamContainerPanel = new AbstractParamContainerPanel(Constant.messages.getString("ascan.custom.tab.policy"));
        String[] stringArray = new String[]{};
        abstractParamContainerPanel.addParamPanel(null, this.getPolicyAllCategoryPanel(true), false);
        this.categoryPanels = new ArrayList<PolicyCategoryPanel>(Category.getAllNames().length);
        for (n = 0; n < Category.getAllNames().length; ++n) {
            PolicyCategoryPanel policyCategoryPanel = new PolicyCategoryPanel(n, this.scanPolicy.getPluginFactory(), this.scanPolicy.getDefaultThreshold());
            abstractParamContainerPanel.addParamPanel(stringArray, Category.getName(n), policyCategoryPanel, true);
            this.categoryPanels.add(policyCategoryPanel);
        }
        abstractParamContainerPanel.showDialog(true);
        this.setCustomTabPanel(4, abstractParamContainerPanel);
        n = 5;
        if (this.customPanels != null) {
            for (CustomScanPanel customScanPanel : this.customPanels) {
                this.setCustomTabPanel(n, customScanPanel.getPanel(true));
                ++n;
            }
        }
        if (target != null) {
            this.populateRequestField(this.target.getStartNode());
            this.targetSelected(FIELD_START, this.target);
            this.setUsers();
            this.setTech();
        }
        this.setAdvancedOptions(this.extension.getScannerParam().isShowAdvancedDialog());
        this.pack();
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.advascan";
    }

    private PolicyAllCategoryPanel getPolicyAllCategoryPanel(boolean bl) {
        if (this.policyAllCategoryPanel == null) {
            this.policyAllCategoryPanel = new PolicyAllCategoryPanel(this, this.extension, this.scanPolicy, true);
            this.policyAllCategoryPanel.setName(Constant.messages.getString("ascan.custom.tab.policy"));
        } else if (bl) {
            this.policyAllCategoryPanel.reloadPolicies();
        }
        return this.policyAllCategoryPanel;
    }

    private void policySelected() {
        String string = this.getStringValue(FIELD_POLICY);
        try {
            this.scanPolicy = this.extension.getPolicyManager().getPolicy(string);
            this.getPolicyAllCategoryPanel(false).setScanPolicy(this.scanPolicy);
            for (PolicyCategoryPanel policyCategoryPanel : this.categoryPanels) {
                policyCategoryPanel.setPluginFactory(this.scanPolicy.getPluginFactory(), this.scanPolicy.getDefaultThreshold());
            }
        }
        catch (ConfigurationException configurationException) {
            logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
        }
    }

    private void setAdvancedOptions(boolean bl) {
        this.getField(FIELD_POLICY).setEnabled(!bl);
        if (bl) {
            ((JComboBox)this.getField(FIELD_POLICY)).setToolTipText(Constant.messages.getString("ascan.custom.tooltip.policy"));
        } else {
            ((JComboBox)this.getField(FIELD_POLICY)).setToolTipText("");
        }
        if (this.showingAdvTabs == bl) {
            return;
        }
        this.setTabsVisible(new String[]{"ascan.custom.tab.input", "ascan.custom.tab.custom", "ascan.custom.tab.tech", "ascan.custom.tab.policy"}, bl);
        if (this.customPanels != null) {
            for (CustomScanPanel customScanPanel : this.customPanels) {
                this.setTabsVisible(new String[]{customScanPanel.getLabel()}, bl);
            }
        }
        this.showingAdvTabs = bl;
        this.extension.getScannerParam().setShowAdvancedDialog(bl);
    }

    private void populateRequestField(SiteNode siteNode) {
        try {
            if (siteNode == null || siteNode.getHistoryReference() == null || siteNode.getHistoryReference().getHttpMessage() == null) {
                this.getRequestField().setText("");
            } else {
                HttpMessage httpMessage = siteNode.getHistoryReference().getHttpMessage();
                String string = httpMessage.getRequestHeader().toString();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                this.headerLength = string.length();
                this.urlPathStart = string.indexOf("/", string.indexOf("://") + 2) + 1;
                stringBuilder.append(httpMessage.getRequestBody().toString());
                this.getRequestField().setText(stringBuilder.toString());
                JCheckBox jCheckBox = (JCheckBox)this.getField(FIELD_RECURSE);
                jCheckBox.setEnabled(siteNode.getChildCount() > 0);
                jCheckBox.setSelected(siteNode.getChildCount() > 0);
            }
            this.setFieldStates();
        }
        catch (DatabaseException | HttpMalformedHeaderException exception) {
            this.getRequestField().setText("");
        }
    }

    @Override
    public void targetSelected(String string, Target target) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (target != null) {
            this.target = target;
            if (target.getStartNode() != null) {
                this.populateRequestField(target.getStartNode());
                Session session = Model.getSingleton().getSession();
                List<Context> list = session.getContextsForNode(target.getStartNode());
                for (Context context : list) {
                    arrayList.add(context.getName());
                }
            } else if (target.getContext() != null) {
                arrayList.add(target.getContext().getName());
            }
            this.setTech();
        }
        this.setComboFields(FIELD_CONTEXT, arrayList, "");
        this.getField(FIELD_CONTEXT).setEnabled(arrayList.size() > 0);
    }

    private Context getSelectedContext() {
        String string = this.getStringValue(FIELD_CONTEXT);
        if (this.extUserMgmt != null && !this.isEmptyField(FIELD_CONTEXT)) {
            Session session = Model.getSingleton().getSession();
            return session.getContext(string);
        }
        return null;
    }

    private User getSelectedUser() {
        Context context = this.getSelectedContext();
        if (context != null) {
            String string = this.getStringValue(FIELD_USER);
            List<User> list = this.extUserMgmt.getContextUserAuthManager(context.getIndex()).getUsers();
            for (User user : list) {
                if (!string.equals(user.getName())) continue;
                return user;
            }
        }
        return null;
    }

    private void setUsers() {
        Context context = this.getSelectedContext();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (context != null) {
            List<User> list = this.extUserMgmt.getContextUserAuthManager(context.getIndex()).getUsers();
            arrayList.add("");
            for (User user : list) {
                arrayList.add(user.getName());
            }
        }
        this.setComboFields(FIELD_USER, arrayList, "");
        this.getField(FIELD_USER).setEnabled(arrayList.size() > 1);
    }

    private void setTech() {
        Context context = this.getSelectedContext();
        TechSet techSet = new TechSet(Tech.builtInTech);
        Iterator<Tech> iterator = techSet.getIncludeTech().iterator();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Constant.messages.getString("ascan.custom.tab.tech.node"));
        while (iterator.hasNext()) {
            Tech tech = iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode2 = tech.getParent() != null ? this.techToNodeMap.get(tech.getParent()) : null;
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
            }
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(tech.getUiName());
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            this.techToNodeMap.put(tech, defaultMutableTreeNode3);
        }
        this.techModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.techTree.setModel(this.techModel);
        this.techTree.expandAll();
        TreePath treePath = new TreePath(defaultMutableTreeNode);
        this.techTree.checkSubTree(treePath, true);
        this.techTree.setCheckBoxEnabled(treePath, false);
        if (context != null) {
            TechSet techSet2 = context.getTechSet();
            Iterator<Map.Entry<Tech, DefaultMutableTreeNode>> iterator2 = this.techToNodeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Tech, DefaultMutableTreeNode> entry = iterator2.next();
                TreePath treePath2 = this.getTechPath(entry.getValue());
                if (!techSet2.includes(entry.getKey())) continue;
                this.getTechTree().check(treePath2, true);
            }
        }
    }

    private TreePath getTechPath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (treeNode != null) {
            arrayList.add(treeNode);
            treeNode = treeNode.getParent();
        }
        Collections.reverse(arrayList);
        return new TreePath(arrayList.toArray());
    }

    private ZapTextArea getRequestField() {
        if (this.requestField == null) {
            this.requestField = new ZapTextArea();
            this.requestField.setEditable(false);
            this.requestField.setLineWrap(true);
            this.requestField.getCaret().setVisible(true);
        }
        return this.requestField;
    }

    private OptionsVariantPanel getVariantPanel() {
        if (this.variantPanel == null) {
            this.variantPanel = new OptionsVariantPanel();
        }
        return this.variantPanel;
    }

    private JPanel getCustomPanel() {
        if (this.customPanel == null) {
            this.customPanel = new JPanel(new GridBagLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setViewportView(this.getRequestField());
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.getRequestField().addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    CustomScanDialog.this.setFieldStates();
                }
            });
            jPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 0, 1, 0.5));
            jPanel.add((Component)this.getAddCustomButton(), LayoutHelper.getGBC(1, 0, 1, 1, 0.0, 0.0, 1, 18, new Insets(5, 5, 5, 5)));
            jPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 0, 1, 0.5));
            jPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 1, 1, 0.5));
            jPanel.add((Component)this.getRemoveCustomButton(), LayoutHelper.getGBC(1, 1, 1, 1, 0.0, 0.0, 1, 18, new Insets(5, 5, 5, 5)));
            jPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 1, 1, 0.5));
            JScrollPane jScrollPane2 = new JScrollPane(this.getInjectionPointList());
            jScrollPane2.setVerticalScrollBarPolicy(20);
            jPanel.add((Component)new JLabel(Constant.messages.getString("ascan.custom.label.vectors")), LayoutHelper.getGBC(0, 2, 3, 0.0, 0.0));
            jPanel.add((Component)jScrollPane2, LayoutHelper.getGBC(0, 3, 3, 1.0, 1.0));
            JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jPanel);
            jSplitPane.setDividerLocation(550);
            this.customPanel.add((Component)jSplitPane, LayoutHelper.getGBC(0, 0, 1, 1, 1.0, 1.0));
            this.customPanel.add((Component)this.customPanelStatus, LayoutHelper.getGBC(0, 1, 1, 1, 1.0, 0.0));
            this.customPanel.add((Component)this.getDisableNonCustomVectors(), LayoutHelper.getGBC(0, 2, 1, 1, 1.0, 0.0));
        }
        return this.customPanel;
    }

    private JButton getAddCustomButton() {
        if (this.addCustomButton == null) {
            this.addCustomButton = new JButton(Constant.messages.getString("ascan.custom.button.pt.add"));
            this.addCustomButton.setEnabled(false);
            this.addCustomButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CustomScanDialog.this.getRequestField().getSelectionStart();
                    if (n >= 0) {
                        int n2 = CustomScanDialog.this.getRequestField().getSelectionEnd();
                        Highlighter highlighter = CustomScanDialog.this.getRequestField().getHighlighter();
                        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.RED);
                        try {
                            Highlighter.Highlight highlight = (Highlighter.Highlight)highlighter.addHighlight(n, n2, defaultHighlightPainter);
                            CustomScanDialog.this.injectionPointModel.addElement(highlight);
                            CustomScanDialog.this.getRequestField().setSelectionStart(n2);
                            CustomScanDialog.this.getRequestField().setSelectionEnd(n2);
                            CustomScanDialog.this.getRequestField().getCaret().setVisible(true);
                        }
                        catch (BadLocationException badLocationException) {
                            logger.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                        }
                    }
                }
            });
        }
        return this.addCustomButton;
    }

    private JButton getRemoveCustomButton() {
        if (this.removeCustomButton == null) {
            this.removeCustomButton = new JButton(Constant.messages.getString("ascan.custom.button.pt.rem"));
            this.removeCustomButton.setEnabled(false);
            this.removeCustomButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CustomScanDialog.this.getRequestField().getSelectionStart();
                    if (n >= 0) {
                        int n2 = CustomScanDialog.this.getRequestField().getSelectionEnd();
                        Highlighter highlighter = CustomScanDialog.this.getRequestField().getHighlighter();
                        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
                        if (highlightArray != null && highlightArray.length > 0) {
                            for (Highlighter.Highlight highlight : highlightArray) {
                                if (!CustomScanDialog.this.selectionIncludesHighlight(n, n2, highlight)) continue;
                                highlighter.removeHighlight(highlight);
                                CustomScanDialog.this.injectionPointModel.removeElement(highlight);
                            }
                        }
                        CustomScanDialog.this.getRequestField().setSelectionStart(n2);
                        CustomScanDialog.this.getRequestField().setSelectionEnd(n2);
                        CustomScanDialog.this.getRequestField().getCaret().setVisible(true);
                    }
                }
            });
        }
        return this.removeCustomButton;
    }

    private JCheckBox getDisableNonCustomVectors() {
        if (this.disableNonCustomVectors == null) {
            this.disableNonCustomVectors = new JCheckBox(Constant.messages.getString("ascan.custom.label.disableiv"));
            this.disableNonCustomVectors.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomScanDialog.this.getVariantPanel().setAllInjectableAndRPC(!CustomScanDialog.this.disableNonCustomVectors.isSelected());
                    if (CustomScanDialog.this.disableNonCustomVectors.isSelected()) {
                        CustomScanDialog.this.setFieldValue(CustomScanDialog.FIELD_DISABLE_VARIANTS_MSG, Constant.messages.getString("ascan.custom.warn.disabled"));
                    } else {
                        CustomScanDialog.this.setFieldValue(CustomScanDialog.FIELD_DISABLE_VARIANTS_MSG, "");
                    }
                }
            });
        }
        return this.disableNonCustomVectors;
    }

    private JPanel getTechPanel() {
        if (this.techPanel == null) {
            this.techPanel = new JPanel(new GridBagLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setViewportView(this.getTechTree());
            jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
            this.techPanel.add((Component)jScrollPane, LayoutHelper.getGBC(0, 0, 1, 1, 1.0, 1.0));
        }
        return this.techPanel;
    }

    private JCheckBoxTree getTechTree() {
        if (this.techTree == null) {
            this.techTree = new JCheckBoxTree(){
                private static final long serialVersionUID = 1L;

                @Override
                protected void setExpandedState(TreePath treePath, boolean bl) {
                    if (bl) {
                        super.setExpandedState(treePath, bl);
                    }
                }
            };
            this.setTech();
        }
        return this.techTree;
    }

    private void setFieldStates() {
        int n = this.getRequestField().getSelectionStart();
        if (this.getBoolValue(FIELD_RECURSE).booleanValue()) {
            this.customPanelStatus.setText(Constant.messages.getString("ascan.custom.status.recurse"));
            this.getAddCustomButton().setEnabled(false);
            this.getRemoveCustomButton().setEnabled(false);
            this.getDisableNonCustomVectors().setEnabled(false);
        } else {
            this.customPanelStatus.setText(Constant.messages.getString("ascan.custom.status.highlight"));
            if (n >= 0) {
                int n2 = this.getRequestField().getSelectionEnd();
                if (this.selectionIncludesHighlight(n, n2, this.getRequestField().getHighlighter().getHighlights())) {
                    this.getAddCustomButton().setEnabled(false);
                    this.getRemoveCustomButton().setEnabled(true);
                } else if (n < this.urlPathStart) {
                    this.getAddCustomButton().setEnabled(false);
                } else if (n < this.headerLength && n2 > this.headerLength) {
                    this.getAddCustomButton().setEnabled(false);
                    this.getRemoveCustomButton().setEnabled(false);
                } else {
                    this.getAddCustomButton().setEnabled(true);
                    this.getRemoveCustomButton().setEnabled(false);
                }
            } else {
                this.getAddCustomButton().setEnabled(false);
                this.getRemoveCustomButton().setEnabled(false);
            }
            this.getDisableNonCustomVectors().setEnabled(true);
        }
        this.getRequestField().getCaret().setVisible(true);
    }

    private TechSet getTechSet() {
        TechSet techSet = new TechSet();
        for (Map.Entry<Tech, DefaultMutableTreeNode> entry : this.techToNodeMap.entrySet()) {
            TreePath treePath = this.getTechPath(entry.getValue());
            Tech tech = entry.getKey();
            if (this.getTechTree().isSelectedFully(treePath)) {
                techSet.include(tech);
                continue;
            }
            techSet.exclude(tech);
        }
        return techSet;
    }

    private JList<Highlighter.Highlight> getInjectionPointList() {
        if (this.injectionPointList == null) {
            this.injectionPointList = new JList<Highlighter.Highlight>(this.injectionPointModel);
            this.injectionPointList.setCellRenderer(new ListCellRenderer<Highlighter.Highlight>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends Highlighter.Highlight> jList, Highlighter.Highlight highlight, int n, boolean bl, boolean bl2) {
                    String string = "";
                    try {
                        string = CustomScanDialog.this.getRequestField().getText(highlight.getStartOffset(), highlight.getEndOffset() - highlight.getStartOffset());
                        if (string.length() > 8) {
                            string = string.substring(0, 8) + "..";
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    return new JLabel("[" + highlight.getStartOffset() + "," + highlight.getEndOffset() + "]: " + string);
                }
            });
        }
        return this.injectionPointList;
    }

    private boolean selectionIncludesHighlight(int n, int n2, Highlighter.Highlight highlight) {
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter;
        if (highlight.getPainter() instanceof DefaultHighlighter.DefaultHighlightPainter && (defaultHighlightPainter = (DefaultHighlighter.DefaultHighlightPainter)highlight.getPainter()).getColor() != null && defaultHighlightPainter.getColor().equals(Color.RED)) {
            return n < highlight.getEndOffset() && n2 > highlight.getStartOffset();
        }
        return false;
    }

    private boolean selectionIncludesHighlight(int n, int n2, Highlighter.Highlight[] highlightArray) {
        for (Highlighter.Highlight highlight : highlightArray) {
            if (!this.selectionIncludesHighlight(n, n2, highlight)) continue;
            return true;
        }
        return false;
    }

    private void reset(boolean bl) {
        XMLConfiguration xMLConfiguration = (XMLConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)this.extension.getScannerParam().getConfig());
        this.scannerParam = new ScannerParam();
        this.scannerParam.load((FileConfiguration)xMLConfiguration);
        this.optionsParam = new OptionsParam();
        this.optionsParam.load((FileConfiguration)xMLConfiguration);
        if (bl) {
            this.init(this.target);
            this.repaint();
        }
    }

    @Override
    public String getSaveButtonText() {
        return Constant.messages.getString("ascan.custom.button.scan");
    }

    @Override
    public JButton[] getExtraButtons() {
        if (this.extraButtons == null) {
            JButton jButton = new JButton(Constant.messages.getString("ascan.custom.button.reset"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomScanDialog.this.reset(true);
                }
            });
            this.extraButtons = new JButton[]{jButton};
        }
        return this.extraButtons;
    }

    @Override
    public void save() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.scanPolicy);
        if (this.getBoolValue(FIELD_ADVANCED).booleanValue()) {
            Object[] objectArray;
            if (this.target == null && this.customPanels != null) {
                for (CustomScanPanel customScanPanel : this.customPanels) {
                    this.target = customScanPanel.getTarget();
                    if (this.target == null) continue;
                    break;
                }
            }
            this.getVariantPanel().saveParam(this.scannerParam);
            if (this.getDisableNonCustomVectors().isSelected()) {
                this.scannerParam.setTargetParamsInjectable(0);
                this.scannerParam.setTargetParamsEnabledRPC(0);
            }
            if (!this.getBoolValue(FIELD_RECURSE).booleanValue() && this.injectionPointModel.getSize() > 0) {
                Iterator<CustomScanPanel> iterator = (Iterator<CustomScanPanel>)new int[this.injectionPointModel.getSize()][];
                for (int i = 0; i < this.injectionPointModel.getSize(); ++i) {
                    objectArray = this.injectionPointModel.elementAt(i);
                    iterator[i] = new int[2];
                    iterator[i][0] = objectArray.getStartOffset();
                    iterator[i][1] = objectArray.getEndOffset();
                }
                try {
                    if (this.target != null && this.target.getStartNode() != null) {
                        VariantUserDefined.setInjectionPoints(this.target.getStartNode().getHistoryReference().getURI().toString(), (int[][])iterator);
                        this.enableUserDefinedRPC();
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            this.scannerParam.setHostPerScan(this.extension.getScannerParam().getHostPerScan());
            this.scannerParam.setThreadPerHost(this.extension.getScannerParam().getThreadPerHost());
            this.scannerParam.setHandleAntiCSRFTokens(this.extension.getScannerParam().getHandleAntiCSRFTokens());
            this.scannerParam.setMaxResultsToList(this.extension.getScannerParam().getMaxResultsToList());
            arrayList.add(this.scannerParam);
            arrayList.add(this.getTechSet());
            if (this.customPanels != null) {
                for (CustomScanPanel customScanPanel : this.customPanels) {
                    objectArray = customScanPanel.getContextSpecificObjects();
                    if (objectArray == null) continue;
                    for (Object object : objectArray) {
                        arrayList.add(object);
                    }
                }
            }
        }
        this.target.setRecurse(this.getBoolValue(FIELD_RECURSE));
        if (this.target.getContext() == null && this.getSelectedContext() != null) {
            this.target.setContext(this.getSelectedContext());
        }
        this.extension.startScan(this.target, this.getSelectedUser(), arrayList.toArray());
    }

    @Override
    public String validateFields() {
        Object object;
        if (Control.Mode.safe == Control.getSingleton().getMode()) {
            return Constant.messages.getString("ascan.custom.notSafe.error");
        }
        if (this.customPanels != null) {
            for (CustomScanPanel object2 : this.customPanels) {
                object = object2.validateFields();
                if (object == null) continue;
                return object;
            }
            for (CustomScanPanel customScanPanel : this.customPanels) {
                object = customScanPanel.getTarget();
                if (object == null || !((Target)object).isValid()) continue;
                return null;
            }
        }
        if (this.target == null || !this.target.isValid()) {
            return Constant.messages.getString("ascan.custom.nostart.error");
        }
        switch (Control.getSingleton().getMode()) {
            case protect: {
                List<StructuralNode> list = this.target.getStartNodes();
                if (list == null) break;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SiteNode siteNode;
                    object = (StructuralNode)iterator.next();
                    if (!(object instanceof StructuralSiteNode) || (siteNode = ((StructuralSiteNode)object).getSiteNode()).isIncludedInScope()) continue;
                    return Constant.messages.getString("ascan.custom.targetNotInScope.error", siteNode.getHierarchicNodeName());
                }
                break;
            }
        }
        return null;
    }

    public void enableUserDefinedRPC() {
        int n = this.scannerParam.getTargetParamsEnabledRPC();
        this.scannerParam.setTargetParamsEnabledRPC(n |= 0x100);
    }
}

