/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.ZapApiIgnore;

public abstract class ApiImplementor {
    private static final String GET_OPTION_PREFIX = "option";
    private static final String SET_OPTION_PREFIX = "setOption";
    private static final String ADD_OPTION_PREFIX = "addOption";
    private static final String REMOVE_OPTION_PREFIX = "removeOption";
    private List<ApiAction> apiActions = new ArrayList<ApiAction>();
    private List<ApiView> apiViews = new ArrayList<ApiView>();
    private List<ApiOther> apiOthers = new ArrayList<ApiOther>();
    private List<String> apiShortcuts = new ArrayList<String>();
    private AbstractParam param = null;

    public List<ApiView> getApiViews() {
        return this.apiViews;
    }

    public List<ApiAction> getApiActions() {
        return this.apiActions;
    }

    public List<ApiOther> getApiOthers() {
        return this.apiOthers;
    }

    public void addApiView(ApiView apiView) {
        this.apiViews.add(apiView);
    }

    public void addApiOthers(ApiOther apiOther) {
        this.apiOthers.add(apiOther);
    }

    public void addApiAction(ApiAction apiAction) {
        this.apiActions.add(apiAction);
    }

    public void addApiShortcut(String string) {
        this.apiShortcuts.add(string);
    }

    public void addApiOptions(AbstractParam abstractParam) {
        this.param = abstractParam;
        Method[] methodArray = abstractParam.getClass().getDeclaredMethods();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Method method : methodArray) {
            if (ApiImplementor.isIgnored(method)) continue;
            if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
                this.addApiView(new ApiView(GET_OPTION_PREFIX + method.getName().substring(3)));
            }
            if (method.getName().startsWith("is") && method.getParameterTypes().length == 0) {
                this.addApiView(new ApiView(GET_OPTION_PREFIX + method.getName().substring(2)));
            }
            if (method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(String.class)) {
                this.addApiAction(new ApiAction(SET_OPTION_PREFIX + method.getName().substring(3), new String[]{"String"}));
                arrayList.add(method.getName());
            }
            if (method.getName().startsWith("add") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(String.class)) {
                this.addApiAction(new ApiAction(ADD_OPTION_PREFIX + method.getName().substring(3), new String[]{"String"}));
                arrayList.add(method.getName());
            }
            if (!method.getName().startsWith("remove") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            this.addApiAction(new ApiAction(REMOVE_OPTION_PREFIX + method.getName().substring(6), new String[]{"String"}));
            arrayList.add(method.getName());
        }
        for (Method method : methodArray) {
            if (ApiImplementor.isIgnored(method) || !method.getName().startsWith("set") || method.getParameterTypes().length != 1 || arrayList.contains(method.getName())) continue;
            if (method.getParameterTypes()[0].equals(Integer.class) || method.getParameterTypes()[0].equals(Integer.TYPE)) {
                this.addApiAction(new ApiAction(SET_OPTION_PREFIX + method.getName().substring(3), new String[]{"Integer"}));
                arrayList.add(method.getName());
                continue;
            }
            if (!method.getParameterTypes()[0].equals(Boolean.class) && !method.getParameterTypes()[0].equals(Boolean.TYPE)) continue;
            this.addApiAction(new ApiAction(SET_OPTION_PREFIX + method.getName().substring(3), new String[]{"Boolean"}));
            arrayList.add(method.getName());
        }
    }

    private static boolean isIgnored(Method method) {
        return method.getAnnotation(ZapApiIgnore.class) != null;
    }

    public ApiResponse handleApiOptionView(String string, JSONObject jSONObject) throws ApiException {
        if (this.param == null) {
            return null;
        }
        if (string.startsWith(GET_OPTION_PREFIX)) {
            Method[] methodArray;
            string = string.substring(GET_OPTION_PREFIX.length());
            for (Method method : methodArray = this.param.getClass().getDeclaredMethods()) {
                if (ApiImplementor.isIgnored(method) || !method.getName().equals("get" + string) && !method.getName().equals("is" + string) || method.getParameterTypes().length != 0) continue;
                try {
                    return new ApiResponseElement(string, method.invoke((Object)this.param, new Object[0]).toString());
                }
                catch (Exception exception) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                }
            }
        }
        return null;
    }

    public ApiResponse handleApiOptionAction(String string, JSONObject jSONObject) throws ApiException {
        if (this.param == null) {
            return null;
        }
        boolean bl = false;
        if (string.startsWith(SET_OPTION_PREFIX)) {
            string = "set" + string.substring(SET_OPTION_PREFIX.length());
            bl = true;
        } else if (string.startsWith(ADD_OPTION_PREFIX)) {
            string = "add" + string.substring(ADD_OPTION_PREFIX.length());
            bl = true;
        } else if (string.startsWith(REMOVE_OPTION_PREFIX)) {
            string = "remove" + string.substring(REMOVE_OPTION_PREFIX.length());
            bl = true;
        }
        if (bl) {
            try {
                Method[] methodArray;
                for (Method method : methodArray = this.param.getClass().getDeclaredMethods()) {
                    if (ApiImplementor.isIgnored(method) || !method.getName().equals(string) || method.getParameterTypes().length != 1) continue;
                    Object object = null;
                    if (method.getParameterTypes()[0].equals(String.class)) {
                        object = jSONObject.getString("String");
                    } else {
                        if (method.getParameterTypes()[0].equals(Integer.class) || method.getParameterTypes()[0].equals(Integer.TYPE)) {
                            try {
                                object = jSONObject.getInt("Integer");
                            }
                            catch (JSONException jSONException) {
                                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "Integer");
                            }
                        }
                        if (method.getParameterTypes()[0].equals(Boolean.class) || method.getParameterTypes()[0].equals(Boolean.TYPE)) {
                            try {
                                object = jSONObject.getBoolean("Boolean");
                            }
                            catch (JSONException jSONException) {
                                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "Boolean");
                            }
                        }
                    }
                    if (object == null) continue;
                    method.invoke((Object)this.param, object);
                    return ApiResponseElement.OK;
                }
            }
            catch (ApiException apiException) {
                throw apiException;
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
            }
        }
        return null;
    }

    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        throw new ApiException(ApiException.Type.BAD_VIEW, string);
    }

    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        throw new ApiException(ApiException.Type.BAD_ACTION, string);
    }

    public HttpMessage handleApiOther(HttpMessage httpMessage, String string, JSONObject jSONObject) throws ApiException {
        throw new ApiException(ApiException.Type.BAD_OTHER, string);
    }

    public String handleCallBack(HttpMessage httpMessage) throws ApiException {
        throw new ApiException(ApiException.Type.URL_NOT_FOUND, httpMessage.getRequestHeader().getURI().toString());
    }

    public HttpMessage handleShortcut(HttpMessage httpMessage) throws ApiException {
        throw new ApiException(ApiException.Type.URL_NOT_FOUND, httpMessage.getRequestHeader().getURI().toString());
    }

    public abstract String getPrefix();

    public ApiAction getApiAction(String string) {
        for (ApiAction apiAction : this.apiActions) {
            if (!apiAction.getName().equals(string)) continue;
            return apiAction;
        }
        return null;
    }

    public ApiView getApiView(String string) {
        for (ApiView apiView : this.apiViews) {
            if (!apiView.getName().equals(string)) continue;
            return apiView;
        }
        return null;
    }

    public ApiOther getApiOther(String string) {
        for (ApiOther apiOther : this.apiOthers) {
            if (!apiOther.getName().equals(string)) continue;
            return apiOther;
        }
        return null;
    }

    protected List<String> getApiShortcuts() {
        return this.apiShortcuts;
    }

    protected int getParam(JSONObject jSONObject, String string, int n) {
        try {
            return jSONObject.getInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    protected String getParam(JSONObject jSONObject, String string, String string2) {
        try {
            return jSONObject.getString(string);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    protected boolean getParam(JSONObject jSONObject, String string, boolean bl) {
        try {
            return jSONObject.getBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public void addCustomHeaders(String string, API.RequestType requestType, HttpMessage httpMessage) {
    }
}

