/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.utils.XMLStringUtil;

public class ApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Type type;
    private final String detail;
    private final Logger logger = Logger.getLogger(this.getClass());

    public ApiException(Type type) {
        this(type, null, null);
    }

    public ApiException(Type type, Throwable throwable) {
        this(type, null, throwable);
    }

    public ApiException(Type type, String string) {
        this(type, string, null);
    }

    public ApiException(Type type, String string, Throwable throwable) {
        super(type.name().toLowerCase(), throwable);
        this.type = type;
        this.detail = string;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        if (!bl) {
            return Constant.messages.getString("api.error." + super.getMessage());
        }
        if (this.detail != null) {
            return Constant.messages.getString("api.error." + super.getMessage()) + " (" + super.getMessage() + ") : " + this.detail;
        }
        return Constant.messages.getString("api.error." + super.getMessage()) + " (" + super.getMessage() + ")";
    }

    public String toString(API.Format format, boolean bl) {
        switch (format) {
            case HTML: 
            case UI: {
                return StringEscapeUtils.escapeHtml((String)this.toString(bl));
            }
            case XML: {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    Element element = document.createElement("Exception");
                    document.appendChild(element);
                    element.setAttribute("type", "exception");
                    element.setAttribute("code", this.getMessage());
                    if (bl && this.detail != null) {
                        element.setAttribute("detail", XMLStringUtil.escapeControlChrs(this.detail));
                    }
                    element.appendChild(document.createTextNode(XMLStringUtil.escapeControlChrs(this.toString(bl))));
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource dOMSource = new DOMSource(document);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult streamResult = new StreamResult(stringWriter);
                    transformer.transform(dOMSource, streamResult);
                    return stringWriter.toString();
                }
                catch (Exception exception) {
                    this.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    break;
                }
            }
            case JSON: {
                return this.toJSON(bl).toString();
            }
        }
        return null;
    }

    private JSONObject toJSON(boolean bl) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"code", (Object)super.getMessage());
        jSONObject.put((Object)"message", (Object)Constant.messages.getString("api.error." + super.getMessage()));
        if (bl && this.detail != null) {
            jSONObject.put((Object)"detail", (Object)this.detail);
        }
        return jSONObject;
    }

    public static enum Type {
        BAD_FORMAT,
        BAD_TYPE,
        NO_IMPLEMENTOR,
        BAD_ACTION,
        BAD_VIEW,
        BAD_OTHER,
        INTERNAL_ERROR,
        MISSING_PARAMETER,
        URL_NOT_FOUND,
        HREF_NOT_FOUND,
        SCAN_IN_PROGRESS,
        DISABLED,
        ALREADY_EXISTS,
        DOES_NOT_EXIST,
        ILLEGAL_PARAMETER,
        CONTEXT_NOT_FOUND,
        USER_NOT_FOUND,
        URL_NOT_IN_CONTEXT,
        BAD_API_KEY,
        SCRIPT_NOT_FOUND,
        BAD_SCRIPT_FORMAT,
        NO_ACCESS;

    }
}

