/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class SessionGeneralPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -8337361808959321380L;
    private JPanel panelSession = null;
    private ZapTextField txtSessionName = null;
    private ZapTextArea txtDescription = null;
    private ZapTextArea location = null;

    public SessionGeneralPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("session.general"));
        this.add((Component)this.getPanelSession(), this.getPanelSession().getName());
    }

    private JPanel getPanelSession() {
        if (this.panelSession == null) {
            this.panelSession = new JPanel();
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.setName(Constant.messages.getString("session.general"));
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelSession.setSize(180, 101);
            }
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("session.label.name")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.panelSession.add((Component)this.getTxtSessionName(), LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("session.label.loc")), LayoutHelper.getGBC(0, 2, 1, 1.0));
            this.panelSession.add((Component)this.getSessionLocation(), LayoutHelper.getGBC(0, 3, 1, 1.0));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("session.label.desc")), LayoutHelper.getGBC(0, 4, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)this.getTxtDescription(), LayoutHelper.getGBC(0, 5, 1, 1.0, 1.0, 1, new Insets(2, 0, 2, 0)));
        }
        return this.panelSession;
    }

    private ZapTextField getTxtSessionName() {
        if (this.txtSessionName == null) {
            this.txtSessionName = new ZapTextField();
        }
        return this.txtSessionName;
    }

    private ZapTextArea getTxtDescription() {
        if (this.txtDescription == null) {
            this.txtDescription = new ZapTextArea();
            this.txtDescription.setBorder(BorderFactory.createBevelBorder(1));
            this.txtDescription.setLineWrap(true);
        }
        return this.txtDescription;
    }

    private ZapTextArea getSessionLocation() {
        if (this.location == null) {
            this.location = new ZapTextArea();
            this.location.setEditable(false);
        }
        return this.location;
    }

    @Override
    public void initParam(Object object) {
        Session session = (Session)object;
        this.getTxtSessionName().setText(session.getSessionName());
        this.getTxtSessionName().discardAllEdits();
        this.getTxtDescription().setText(session.getSessionDesc());
        this.getTxtDescription().discardAllEdits();
        if (session.getFileName() != null) {
            this.getSessionLocation().setText(session.getFileName());
            this.getSessionLocation().setToolTipText(session.getFileName());
        }
    }

    @Override
    public void validateParam(Object object) {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        Session session = (Session)object;
        boolean bl = false;
        if (!this.getTxtSessionName().getText().equals(session.getSessionName())) {
            session.setSessionName(this.getTxtSessionName().getText());
            bl = true;
        }
        if (!this.getTxtDescription().getText().equals(session.getSessionDesc())) {
            session.setSessionDesc(this.getTxtDescription().getText());
            bl = true;
        }
        if (bl && !session.isNewState()) {
            Control.getSingleton().saveSession(session.getFileName());
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.sessprop";
    }
}

