/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.Filter;

public class AllFilterTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("filter.table.name"), Constant.messages.getString("filter.table.enabled"), ""};
    private List<Filter> allFilters = new Vector<Filter>();

    private void setAllFilters(List<Filter> list) {
        this.allFilters = list;
    }

    public void setTable(List<Filter> list) {
        this.setAllFilters(list);
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 1) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        Filter filter = this.getAllFilters().get(n);
        switch (n2) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = filter.isPropertyExists();
            }
        }
        return bl;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Filter filter = this.allFilters.get(n);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                filter.setEnabled((Boolean)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.getAllFilters().size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        Filter filter = this.getAllFilters().get(n);
        switch (n2) {
            case 0: {
                object = filter.getName();
                break;
            }
            case 1: {
                object = filter.isEnabled();
                break;
            }
            case 2: {
                if (filter.isPropertyExists()) {
                    object = "...";
                    break;
                }
                object = "";
                break;
            }
            default: {
                object = "";
            }
        }
        return object;
    }

    void setAllFilterEnabled(boolean bl) {
        for (int i = 0; i < this.getAllFilters().size(); ++i) {
            Filter filter = this.getAllFilters().get(i);
            filter.setEnabled(bl);
        }
        this.fireTableDataChanged();
    }

    public List<Filter> getAllFilters() {
        if (this.allFilters == null) {
            this.allFilters = new Vector<Filter>();
        }
        return this.allFilters;
    }
}

