/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordStructure;
import org.parosproxy.paros.db.TableStructure;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableStructure
extends ParosAbstractTable
implements TableStructure {
    private static final String TABLE_NAME = "STRUCTURE";
    private static final String STRUCTUREID = "STRUCTUREID";
    private static final String SESSIONID = "SESSIONID";
    private static final String PARENTID = "PARENTID";
    private static final String HISTORYID = "HISTORYID";
    private static final String NAME = "NAME";
    private static final String NAMEHASH = "NAMEHASH";
    private static final String URL = "URL";
    private static final String METHOD = "METHOD";
    private PreparedStatement psRead = null;
    private PreparedStatement psFind = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psGetChildren = null;
    private PreparedStatement psGetChildCount = null;

    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(connection, TABLE_NAME)) {
                DbUtils.executeAndClose(connection.prepareStatement("CREATE cached TABLE STRUCTURE (STRUCTUREID bigint generated by default as identity (start with 1), SESSIONID bigint not null, PARENTID bigint not null, HISTORYID int, NAME varchar(8192) not null, NAMEHASH bigint not null, URL varchar(8192) not null, METHOD varchar(10) not null)"));
            }
            this.psRead = connection.prepareStatement("SELECT * FROM STRUCTURE WHERE SESSIONID = ? AND STRUCTUREID = ?");
            this.psFind = connection.prepareStatement("SELECT * FROM STRUCTURE WHERE SESSIONID = ? AND NAMEHASH = ?");
            this.psInsert = connection.prepareStatement("INSERT INTO STRUCTURE (SESSIONID, PARENTID, HISTORYID, NAME, NAMEHASH, URL) VALUES (?, ?, ?, ?, ?, ?)");
            this.psGetIdLastInsert = connection.prepareCall("CALL IDENTITY();");
            this.psGetChildren = connection.prepareStatement("SELECT * FROM STRUCTURE WHERE SESSIONID = ? AND PARENTID = ?");
            this.psGetChildCount = connection.prepareStatement("SELECT COUNT(*) FROM STRUCTURE WHERE SESSIONID = ? AND PARENTID = ?");
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordStructure read(long l, long l2) throws DatabaseException {
        try {
            this.psRead.setLong(1, l);
            this.psRead.setLong(2, l2);
            try (ResultSet resultSet = this.psRead.executeQuery();){
                RecordStructure recordStructure = this.build(resultSet);
                resultSet.close();
                RecordStructure recordStructure2 = recordStructure;
                return recordStructure2;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public RecordStructure insert(long l, long l2, int n, String string, String string2, String string3) throws DatabaseException {
        try {
            long l3;
            this.psInsert.setLong(1, l);
            this.psInsert.setLong(2, l2);
            this.psInsert.setInt(3, n);
            this.psInsert.setString(4, string);
            this.psInsert.setInt(5, string.hashCode());
            this.psInsert.setString(6, string2);
            this.psInsert.setString(7, string3);
            this.psInsert.executeUpdate();
            try (ResultSet resultSet = this.psGetIdLastInsert.executeQuery();){
                resultSet.next();
                l3 = resultSet.getLong(1);
            }
            return this.read(l, l3);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecordStructure find(long l, String string, String string2) throws DatabaseException {
        try {
            this.psFind.setLong(1, l);
            this.psFind.setInt(2, string.hashCode());
            this.psFind.setString(3, string2);
            try (ResultSet resultSet = this.psFind.executeQuery();){
                do {
                    if (!resultSet.next()) return null;
                } while (!string.equals(resultSet.getString(NAME)));
                RecordStructure recordStructure = this.build(resultSet);
                return recordStructure;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<RecordStructure> getChildren(long l, long l2) throws DatabaseException {
        try {
            this.psGetChildren.setLong(1, l);
            this.psGetChildren.setLong(2, l2);
            ArrayList<RecordStructure> arrayList = new ArrayList<RecordStructure>();
            try (ResultSet resultSet = this.psGetChildren.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.build(resultSet));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getChildCount(long l, long l2) throws DatabaseException {
        try {
            this.psGetChildCount.setLong(1, l);
            this.psGetChildCount.setLong(2, l2);
            try (ResultSet resultSet = this.psGetChildCount.executeQuery();){
                if (!resultSet.next()) return 0L;
                long l3 = resultSet.getLong(1);
                return l3;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public void deleteLeaf(long l, long l2) throws DatabaseException {
    }

    @Override
    public void deleteSubtree(long l, long l2) throws DatabaseException {
    }

    private RecordStructure build(ResultSet resultSet) throws DatabaseException {
        try {
            RecordStructure recordStructure = null;
            if (resultSet.next()) {
                recordStructure = new RecordStructure(resultSet.getLong(SESSIONID), resultSet.getLong(STRUCTUREID), resultSet.getLong(PARENTID), resultSet.getInt(HISTORYID), resultSet.getString(NAME), resultSet.getString(URL), resultSet.getString(METHOD));
            }
            return recordStructure;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }
}

