/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.OptionsDialog;
import org.parosproxy.paros.view.View;

public class MenuToolsControl {
    private static final Logger logger = Logger.getLogger(MenuToolsControl.class);
    private View view = null;
    private Model model = null;
    private Control control = null;

    public MenuToolsControl() {
        this.view = View.getSingleton();
        this.model = Model.getSingleton();
        this.control = Control.getSingleton();
    }

    public MenuToolsControl(Model model, View view, Control control) {
        this.model = model;
        this.view = view;
        this.control = control;
    }

    public void options() {
        this.options(null);
    }

    public void options(String string) {
        OptionsDialog optionsDialog = this.view.getOptionsDialog(Constant.messages.getString("options.dialog.title"));
        optionsDialog.initParam(this.model.getOptionsParam());
        int n = optionsDialog.showDialog(false, string);
        if (n == 0) {
            try {
                this.model.getOptionsParam().getConfig().save();
            }
            catch (ConfigurationException configurationException) {
                logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                this.view.showWarningDialog(Constant.messages.getString("menu.tools.options.errorSavingOptions"));
                return;
            }
            this.control.getExtensionLoader().optionsChangedAllPlugin(this.model.getOptionsParam());
            this.control.getProxy().stopServer();
            this.control.getProxy().startServer();
        }
    }
}

