/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.ui;

import ch.csnc.extension.ui.DriverTableModel;
import ch.csnc.extension.util.DriverConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.AbstractFrame;
import org.zaproxy.zap.utils.ZapTextField;

public class DriversView
extends AbstractFrame {
    private static final long serialVersionUID = -7502331281272992501L;
    private DriverTableModel driverTableModel;
    private JTable driverTable;
    private JButton addButton;
    private JButton browseButton;
    private JButton closeButton;
    private JButton deleteButton;
    private JScrollPane driverScrollPane;
    private JLabel fileLabel;
    private ZapTextField fileTextField;
    private JLabel nameLabel;
    private ZapTextField nameTextField;
    private JLabel slotLabel;
    private ZapTextField slotTextField;
    private JLabel slotListIndexLabel;
    private ZapTextField slotListIndexTextField;

    public DriversView(DriverConfiguration driverConfiguration) {
        this.driverTableModel = new DriverTableModel(driverConfiguration);
        this.initComponents();
        this.setVisible(true);
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new ZapTextField();
        this.browseButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new ZapTextField();
        this.slotLabel = new JLabel();
        this.slotTextField = new ZapTextField();
        this.slotListIndexLabel = new JLabel();
        this.slotListIndexTextField = new ZapTextField();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.closeButton = new JButton();
        this.driverScrollPane = new JScrollPane();
        this.driverTable = new JTable();
        this.setTitle(Constant.messages.getString("certificates.pkcs11.drivers.title"));
        this.fileLabel.setText(Constant.messages.getString("certificates.pkcs11.drivers.label.path"));
        this.browseButton.setText(Constant.messages.getString("certificates.pkcs11.drivers.button.browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriversView.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.nameLabel.setText(Constant.messages.getString("certificates.pkcs11.drivers.label.name"));
        this.slotLabel.setText(Constant.messages.getString("certificates.pkcs11.drivers.label.slot"));
        this.slotListIndexLabel.setText(Constant.messages.getString("certificates.pkcs11.drivers.label.slotIndex"));
        this.addButton.setText(Constant.messages.getString("certificates.pkcs11.drivers.button.add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriversView.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.deleteButton.setText(Constant.messages.getString("certificates.pkcs11.drivers.button.delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriversView.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        this.closeButton.setText(Constant.messages.getString("certificates.pkcs11.drivers.button.close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriversView.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.driverTable.setModel(this.driverTableModel);
        this.driverScrollPane.setViewportView(this.driverTable);
        if (!Model.getSingleton().getOptionsParam().getExperimentalFeaturesParam().isExerimentalSliSupportEnabled()) {
            this.slotTextField.setEnabled(false);
        }
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileLabel).addComponent(this.nameLabel).addComponent(this.slotLabel).addComponent(this.slotListIndexLabel).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.nameTextField, GroupLayout.Alignment.LEADING).addComponent(this.slotTextField, GroupLayout.Alignment.LEADING).addComponent(this.slotListIndexTextField, GroupLayout.Alignment.LEADING).addComponent(this.fileTextField, GroupLayout.Alignment.LEADING, -1, 322, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton, -1, 80, Short.MAX_VALUE).addComponent(this.browseButton)))).addContainerGap(165, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(499, 499, 499).addComponent(this.closeButton, -1, 74, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.driverScrollPane, -1, 561, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(499, Short.MAX_VALUE).addComponent(this.deleteButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.browseButton, 0, 0, Short.MAX_VALUE).addComponent(this.fileTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slotLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.slotTextField, -2, -1, -2)).addGap(28, 28, 28).addComponent(this.slotListIndexLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.slotListIndexTextField, -2, -1, -2).addComponent(this.addButton, -2, 19, -2)).addGap(28, 28, 28).addComponent(this.driverScrollPane, -2, 195, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.closeButton, -2, 10, -2).addContainerGap()));
        groupLayout.linkSize(1, this.addButton, this.browseButton, this.closeButton, this.deleteButton, this.fileTextField, this.nameTextField);
        for (int i = 0; i < this.driverTableModel.getColumnCount(); ++i) {
            this.driverTable.getColumnModel().getColumn(i).setPreferredWidth(this.driverTableModel.getPreferredWith(i));
        }
        this.pack();
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "DLL/dylib";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".dll") || file.getName().toLowerCase().endsWith(".dylib");
            }
        });
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            this.fileTextField.setText(jFileChooser.getSelectedFile().toString());
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.nameTextField.getText();
        String string2 = this.fileTextField.getText();
        int n = -1;
        int n2 = -1;
        try {
            n = Integer.parseInt(this.slotTextField.getText());
        }
        catch (Exception exception) {
            this.slotTextField.setText("0");
        }
        try {
            n2 = Integer.parseInt(this.slotListIndexTextField.getText());
        }
        catch (Exception exception) {
            this.slotListIndexTextField.setText("0");
        }
        if (string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0 && n > -1 && n2 > -1) {
            this.driverTableModel.addDriver(string, string2, n, n2);
            this.nameTextField.setText("");
            this.fileTextField.setText("");
            this.slotTextField.setText("0");
            this.slotListIndexTextField.setText("0");
        }
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.driverTable.getSelectedRow();
        if (n > -1) {
            this.driverTableModel.deleteDriver(n);
            this.nameTextField.setText("");
            this.fileTextField.setText("");
            this.slotTextField.setText("0");
            this.slotListIndexTextField.setText("0");
        }
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

