/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.ui;

import ch.csnc.extension.util.DriverConfiguration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DriverTableModel
extends AbstractTableModel
implements Observer {
    private static final long serialVersionUID = -9114670362713975727L;
    private DriverConfiguration driverConfig;
    private Vector<String> names;
    private Vector<String> paths;
    private Vector<Integer> slots;
    private Vector<Integer> slotListIndexes;

    public DriverTableModel(DriverConfiguration driverConfiguration) {
        this.driverConfig = driverConfiguration;
        driverConfiguration.addObserver(this);
        this.names = driverConfiguration.getNames();
        this.paths = driverConfiguration.getPaths();
        this.slots = driverConfiguration.getSlots();
        this.slotListIndexes = driverConfiguration.getSlotIndexes();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.names.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.names.get(n);
        }
        if (n2 == 1) {
            return this.paths.get(n);
        }
        if (n2 == 2) {
            return this.slots.get(n);
        }
        if (n2 == 3) {
            return this.slotListIndexes.get(n);
        }
        return "";
    }

    int getPreferredWith(int n) {
        if (n == 0) {
            return 75;
        }
        if (n == 1) {
            return 300;
        }
        if (n == 2) {
            return 15;
        }
        if (n == 3) {
            return 15;
        }
        return 0;
    }

    void addDriver(String string, String string2, int n, int n2) {
        this.names.add(string);
        this.paths.add(string2);
        this.slots.add(n);
        this.slotListIndexes.add(n2);
        this.updateConfiguration();
    }

    void deleteDriver(int n) {
        this.names.remove(n);
        this.paths.remove(n);
        this.slots.remove(n);
        this.slotListIndexes.remove(n);
        this.updateConfiguration();
    }

    private void updateConfiguration() {
        this.driverConfig.setNames(this.names);
        this.driverConfig.setPaths(this.paths);
        this.driverConfig.setSlots(this.slots);
        this.driverConfig.setSlotListIndexes(this.slotListIndexes);
        this.driverConfig.write();
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "Name";
        }
        if (n == 1) {
            return "Path";
        }
        if (n == 2) {
            return "Slot";
        }
        if (n == 3) {
            return "SlotListIndex";
        }
        throw new IllegalArgumentException("Invalid column number: " + n);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.fireTableDataChanged();
    }
}

