/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.httpclient;

import ch.csnc.extension.httpclient.PKCS11Configuration;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PKCS11ConfigurationUnitTest {
    private static final String NAME = "Provider Name";
    private static final String LIBRARY = "path/to/library";
    private PKCS11Configuration configuration;
    private PKCS11Configuration.PCKS11ConfigurationBuilder configurationBuilder;

    private static PKCS11Configuration.PCKS11ConfigurationBuilder getConfigurationBuilderWithNameAndLibrarySet() {
        return PKCS11Configuration.builder().setName(NAME).setLibrary(LIBRARY);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionWhenBuildingAConfigurationWithoutNameAndLibrary() {
        PKCS11Configuration.builder().build();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionWhenBuildingAConfigurationWithoutName() {
        PKCS11Configuration.builder().setLibrary(LIBRARY).build();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionWhenCreatingAConfigurationWithoutLibrary() {
        PKCS11Configuration.builder().setName(NAME).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenSettingAnEmptyName() {
        PKCS11Configuration.builder().setName("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenSettingANullName() {
        PKCS11Configuration.builder().setName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenSettingAnEmptyLibrary() {
        PKCS11Configuration.builder().setLibrary("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenSettingANullLibrary() {
        PKCS11Configuration.builder().setLibrary(null);
    }

    @Test
    public void shouldCreateConfigurationWithNonEmptyNameAndNonEmptyLibrary() {
        String string = "ProviderName";
        String string2 = "Library";
        PKCS11Configuration.builder().setName(string).setLibrary(string2).build();
    }

    @Test
    public void shouldRetrieveNameSet() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().build();
        String string = this.configuration.getName();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)NAME)));
    }

    @Test
    public void shouldRetrieveLibrarySet() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().build();
        String string = this.configuration.getLibrary();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)LIBRARY)));
    }

    @Test
    public void shouldRetrieveDefaultSlotListIndexFromNewlyCreatedConfiguration() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().build();
        int n = this.configuration.getSlotListIndex();
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void shouldRetrieveUndefinedSlotIdFromNewlyCreatedConfiguration() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().build();
        int n = this.configuration.getSlotId();
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)-1)));
    }

    @Test
    public void shouldRetrieveStringRepresentationFromNewlyCreatedConfiguration() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().build();
        String string = this.configuration.toString();
        Assert.assertThat((Object)string, (Matcher)Matchers.containsString((String)"name = \"Provider Name\""));
        Assert.assertThat((Object)string, (Matcher)Matchers.containsString((String)"library = path/to/library"));
        Assert.assertThat((Object)string, (Matcher)Matchers.containsString((String)"slotListIndex = 0"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenSettingNegativeSlotListIndex() {
        this.configurationBuilder = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet();
        this.configurationBuilder.setSlotListIndex(-1);
    }

    @Test
    public void shouldRetrieveDescriptionSet() {
        String string = "Description of Provider X";
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setDescription(string).build();
        String string2 = this.configuration.getDescription();
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
    }

    @Test
    public void shouldRetrieveNullDescriptionSet() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setDescription(null).build();
        String string = this.configuration.getDescription();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldRetrieveEmptyDescriptionSet() {
        String string = "";
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setDescription(string).build();
        String string2 = this.configuration.getDescription();
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
    }

    @Test
    public void shouldRetrieveUndefinedDescriptionFromNewlyCreatedConfiguration() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().build();
        String string = this.configuration.getDescription();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldRetrieveStringRepresentationWithDescriptionSet() {
        String string = "Description of Provider X";
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setDescription(string).build();
        String string2 = this.configuration.toString();
        Assert.assertThat((Object)string2, (Matcher)Matchers.containsString((String)("description = " + string)));
    }

    @Test
    public void shouldRetrieveStringRepresentationWithOutDescriptionWhenEmptyDescriptionSet() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setDescription("").build();
        String string = this.configuration.toString();
        Assert.assertThat((Object)string, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"description = ")));
    }

    @Test
    public void shouldRetrieveStringRepresentationWithOutDescriptionWhenNullDescriptionSet() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setDescription(null).build();
        String string = this.configuration.toString();
        Assert.assertThat((Object)string, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"description = ")));
    }

    @Test
    public void shouldRetrieveSlotListIndexSet() {
        int n = 1;
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setSlotListIndex(n).build();
        int n2 = this.configuration.getSlotListIndex();
        Assert.assertThat((Object)n2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)n)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenSettingNegativeSlotId() {
        this.configurationBuilder = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet();
        this.configurationBuilder.setSlotId(-1);
    }

    @Test
    public void shouldRetrieveSlotIdSet() {
        int n = 1;
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setSlotId(n).build();
        int n2 = this.configuration.getSlotId();
        Assert.assertThat((Object)n2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)n)));
    }

    @Test
    public void shouldRetrieveSlotIdAsUndefinedGivenASlotListIndexSet() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setSlotListIndex(1).build();
        int n = this.configuration.getSlotId();
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)-1)));
    }

    @Test
    public void shouldRetrieveSlotListIndexAsUndefinedGivenASlotIdSet() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setSlotId(1).build();
        int n = this.configuration.getSlotListIndex();
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)-1)));
    }

    @Test
    public void shouldRetrieveStringRepresentationWithAttributeSlotInsteadOfAttributeSlotListIndexGivenASlotIdSet() {
        int n = 1;
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().setSlotId(n).build();
        String string = this.configuration.toString();
        Assert.assertThat((Object)string, (Matcher)Matchers.containsString((String)("slot = " + n)));
        Assert.assertThat((Object)string, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"slotListIndex")));
    }

    @Test
    public void shouldRetrieveStringRepresentationWithBackslashesPresentInNameEscapedWithBackslashes() {
        String string = "\\";
        this.configuration = PKCS11Configuration.builder().setName(string).setLibrary(LIBRARY).build();
        String string2 = this.configuration.toString();
        Assert.assertThat((Object)string2, (Matcher)Matchers.containsString((String)"\\\\"));
    }

    @Test
    public void shouldRetrieveStringRepresentationWithQuotationMarksPresentInNameEscapedWithBackslashes() {
        String string = "\"";
        this.configuration = PKCS11Configuration.builder().setName(string).setLibrary(LIBRARY).build();
        String string2 = this.configuration.toString();
        Assert.assertThat((Object)string2, (Matcher)Matchers.containsString((String)"\\\""));
    }

    @Test
    public void shouldRetrieveInputStream() {
        this.configuration = PKCS11ConfigurationUnitTest.getConfigurationBuilderWithNameAndLibrarySet().build();
        InputStream inputStream = this.configuration.toInpuStream();
        Assert.assertThat((Object)inputStream, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }
}

