/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.viewers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.io.FileHandler;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.util.NonWrappingTextPane;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class WindowViewerFrame
extends JFrame
implements DocumentListener {
    private static final int SIZE_X = 550;
    private static final int SIZE_Y = 525;
    private static final long serialVersionUID = -4765698531680118534L;
    private static final Color HILIT_COLOR = Color.LIGHT_GRAY;
    private static final Color ERROR_COLOR = Color.PINK;
    private static final String CANCEL_ACTION = "cancel-search";
    private final Color entryBg;
    private final transient Highlighter hilit;
    private final transient Highlighter.HighlightPainter painter;
    private final JTextPane listTextArea;
    private final JTextField entry;
    private final JLabel status;
    private int lastIndex = 0;

    public WindowViewerFrame(AbstractPanel parent, File inputFile) {
        super("JBroFuzz - File Viewer - " + inputFile.getName());
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel listPanel = new JPanel();
        listPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(inputFile.getName()), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        listPanel.setLayout(new BorderLayout());
        boolean wrapText = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.FUZZING[3].getId(), false);
        this.listTextArea = wrapText ? new JTextPane() : new NonWrappingTextPane();
        this.listTextArea.setFont(new Font("Monospaced", 0, 12));
        this.listTextArea.setEditable(false);
        this.entry = new JTextField(10);
        this.status = new JLabel("Enter text to search:");
        this.hilit = new DefaultHighlighter();
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(HILIT_COLOR);
        this.listTextArea.setHighlighter(this.hilit);
        this.entryBg = this.entry.getBackground();
        this.entry.getDocument().addDocumentListener(this);
        InputMap im = this.entry.getInputMap(2);
        ActionMap am = this.entry.getActionMap();
        im.put(KeyStroke.getKeyStroke("ESCAPE"), CANCEL_ACTION);
        am.put(CANCEL_ACTION, new CancelAction());
        AbstractPanel.popupText(this.listTextArea, false, true, false, true);
        JScrollPane listTextScrollPane = new JScrollPane(this.listTextArea);
        listTextScrollPane.setVerticalScrollBarPolicy(20);
        listTextScrollPane.setHorizontalScrollBarPolicy(30);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setString("   ");
        progressBar.setStringPainted(true);
        JPanel bottomPanel = new JPanel(new FlowLayout(2, 15, 15));
        bottomPanel.add(this.status);
        bottomPanel.add(this.entry);
        bottomPanel.add(progressBar);
        this.listTextArea.setCaretPosition(0);
        listPanel.add(listTextScrollPane);
        pane.add((Component)listPanel, "Center");
        pane.add((Component)bottomPanel, "South");
        this.setLocation(parent.getLocationOnScreen().x + 100, parent.getLocationOnScreen().y + 20);
        this.setSize(550, 525);
        this.setResizable(true);
        this.setVisible(true);
        this.setMinimumSize(new Dimension(550, 525));
        this.setDefaultCloseOperation(2);
        this.listTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    WindowViewerFrame.this.dispose();
                }
                if (ke.getKeyCode() == 10) {
                    WindowViewerFrame.this.search();
                }
            }
        });
        this.entry.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    WindowViewerFrame.this.search();
                }
            }
        });
        class FileLoader
        extends SwingWorker<String, Object> {
            private final /* synthetic */ JProgressBar val$progressBar;
            private final /* synthetic */ File val$inputFile;

            FileLoader(JProgressBar jProgressBar, File file) {
                this.val$progressBar = jProgressBar;
                this.val$inputFile = file;
            }

            @Override
            public String doInBackground() {
                this.val$progressBar.setIndeterminate(true);
                WindowViewerFrame.this.listTextArea.setText(FileHandler.readFile(this.val$inputFile));
                return "done";
            }

            @Override
            protected void done() {
                this.val$progressBar.setIndeterminate(false);
                this.val$progressBar.setValue(100);
                WindowViewerFrame.this.listTextArea.repaint();
            }
        }
        new FileLoader(progressBar, inputFile).execute();
    }

    private void search() {
        this.hilit.removeAllHighlights();
        String s = this.entry.getText();
        if (s.length() <= 0) {
            this.message("Nothing to search");
            return;
        }
        try {
            String content = this.listTextArea.getDocument().getText(0, this.listTextArea.getDocument().getLength());
            int index = content.indexOf(s, 0);
            if (this.lastIndex != 0 && this.lastIndex >= index) {
                int tempIndex;
                index = tempIndex = content.indexOf(s, this.lastIndex + 1);
            }
            if (index >= 0) {
                int end = index + s.length();
                this.hilit.addHighlight(index, end, this.painter);
                this.listTextArea.setCaretPosition(index);
                this.entry.setBackground(this.entryBg);
                this.message("Phrase found: '" + s + "'");
                this.lastIndex = index;
            } else if (this.lastIndex > 0) {
                this.entry.setBackground(ERROR_COLOR);
                this.message("End reached. Starting from top again...");
                this.lastIndex = 0;
            } else {
                this.entry.setBackground(ERROR_COLOR);
                this.message("Phrase not found...");
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void message(String msg) {
        this.status.setText(StringUtils.abbreviate(msg, 40));
    }

    public void highlightText(DocumentEvent ev) {
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        this.search();
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
        this.search();
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
        this.search();
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 9875234L;

        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WindowViewerFrame.this.hilit.removeAllHighlights();
            WindowViewerFrame.this.entry.setText("");
            WindowViewerFrame.this.entry.setBackground(WindowViewerFrame.this.entryBg);
            WindowViewerFrame.this.dispose();
        }
    }
}

