/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.fuzz.ui.FuzzingPanel;
import org.owasp.jbrofuzz.graph.GraphingPanel;
import org.owasp.jbrofuzz.payloads.PayloadsPanel;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.system.SystemPanel;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.menu.JBroFuzzMenuBar;
import org.owasp.jbrofuzz.ui.menu.JBroFuzzToolBar;
import org.owasp.jbrofuzz.update.StartUpdateCheck;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class JBroFuzzWindow
extends JFrame {
    private static final long serialVersionUID = -8055724052613595729L;
    private static final int SIZE_X = 700;
    private static final int SIZE_Y = 500;
    public static final int ID_PANEL_GRAPHING = 121;
    public static final int ID_PANEL_FUZZING = 124;
    public static final int ID_PANEL_PAYLOADS = 125;
    public static final int ID_PANEL_SYSTEM = 126;
    private final JBroFuzz mJBroFuzz;
    private final JBroFuzzMenuBar mb;
    private JTabbedPane tp;
    private final GraphingPanel gp;
    private final PayloadsPanel pp;
    private final FuzzingPanel fp;
    private final SystemPanel cp;
    private final JBroFuzzToolBar tb;
    private File currentFile;
    private boolean isCurrentFileSet;

    public JBroFuzzWindow(JBroFuzz mJBroFuzz) {
        super(" JBroFuzz - Untitled ");
        this.mJBroFuzz = mJBroFuzz;
        this.currentFile = new File(String.valueOf(System.getProperty("user.home")) + File.separator + "Untitled.jbrofuzz");
        this.isCurrentFileSet = false;
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.mb = new JBroFuzzMenuBar(this);
        this.setJMenuBar(this.mb);
        this.tb = new JBroFuzzToolBar(this);
        this.gp = new GraphingPanel(this);
        this.fp = new FuzzingPanel(this);
        this.pp = new PayloadsPanel(this);
        this.cp = new SystemPanel(this);
        boolean tabsAtTop = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.GENERAL[1].getId(), true);
        this.tp = tabsAtTop ? new JTabbedPane(1) : new JTabbedPane(3);
        this.tp.setOpaque(false);
        this.tp.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.tp.add(this.fp.getName(), this.fp);
        this.tp.add(this.gp.getName(), this.gp);
        this.tp.add(this.pp.getName(), this.pp);
        this.tp.add(this.cp.getName(), this.cp);
        this.tp.setSelectedIndex(0);
        this.tp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                int c = pane.getSelectedIndex();
                if (c >= 0) {
                    boolean[] b = new boolean[]{((AbstractPanel)pane.getComponent(c)).isStartedEnabled(), ((AbstractPanel)pane.getComponent(c)).isStoppedEnabled(), ((AbstractPanel)pane.getComponent(c)).isPauseEnabled(), ((AbstractPanel)pane.getComponent(c)).isAddedEnabled(), ((AbstractPanel)pane.getComponent(c)).isRemovedEnabled()};
                    JBroFuzzWindow.this.tb.setEnabledPanelOptions(b);
                    JBroFuzzWindow.this.mb.setEnabledPanelOptions(b);
                }
            }
        });
        pane.add((Component)this.tb, "First");
        pane.add((Component)this.tp, "Center");
        Logger.log("System Launch, Welcome!", 1);
        boolean checkNewVersion = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.GENERAL[0].getId(), true);
        if (checkNewVersion) {
            new StartUpdateCheck(this).execute();
        }
    }

    public static void createAndShowGUI(JBroFuzzWindow mJBroFuzzWindow) {
        int ySize;
        mJBroFuzzWindow.setMinimumSize(new Dimension(127, 127));
        mJBroFuzzWindow.setIconImage(ImageCreator.IMG_FRAME.getImage());
        mJBroFuzzWindow.setDefaultCloseOperation(0);
        mJBroFuzzWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent wEvent) {
                JBroFuzzWindow.this.closeFrame();
            }
        });
        int xLocation = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.UI[0].getId(), 50);
        int yLocation = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.UI[1].getId(), 100);
        mJBroFuzzWindow.setLocation(xLocation, yLocation);
        int xSize = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.UI[2].getId(), 700);
        if (xSize < 127) {
            xSize = 127;
        }
        if ((ySize = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.UI[3].getId(), 500)) < 127) {
            ySize = 127;
        }
        mJBroFuzzWindow.setSize(new Dimension(xSize, ySize));
        mJBroFuzzWindow.setResizable(true);
        mJBroFuzzWindow.setVisible(true);
    }

    public void closeFrame() {
        String sRequest;
        this.fp.stop();
        this.gp.stop();
        this.pp.stop();
        this.cp.stop();
        if ((this.getExtendedState() & 6) == 6) {
            JBroFuzz.PREFS.putInt(JBroFuzzPrefs.UI[0].getId(), this.getLocation().x);
            JBroFuzz.PREFS.putInt(JBroFuzzPrefs.UI[1].getId(), this.getLocation().y);
        } else {
            JBroFuzz.PREFS.putInt(JBroFuzzPrefs.UI[3].getId(), this.getSize().height);
            JBroFuzz.PREFS.putInt(JBroFuzzPrefs.UI[2].getId(), this.getSize().width);
            JBroFuzz.PREFS.putInt(JBroFuzzPrefs.UI[0].getId(), this.getLocation().x);
            JBroFuzz.PREFS.putInt(JBroFuzzPrefs.UI[1].getId(), this.getLocation().y);
        }
        String sURL = this.fp.getTextURL();
        if (sURL.length() < 8192) {
            JBroFuzz.PREFS.put("fuzz.ui.url_text", this.fp.getTextURL());
        }
        if ((sRequest = this.fp.getTextRequest()).length() < 8192) {
            JBroFuzz.PREFS.put("fuzz.ui.request_text", this.fp.getTextRequest());
        }
        this.dispose();
        Logger.log("System Exit. Goodbye...", 1);
    }

    public File getCurrentFileOpened() {
        return this.currentFile;
    }

    public JBroFuzz getJBroFuzz() {
        return this.mJBroFuzz;
    }

    public JBroFuzzMenuBar getJBroMenuBar() {
        return this.mb;
    }

    public JBroFuzzToolBar getJBroToolBar() {
        return this.tb;
    }

    public FuzzingPanel getPanelFuzzing() {
        return this.fp;
    }

    public PayloadsPanel getPanelPayloads() {
        return this.pp;
    }

    public GraphingPanel getPanelWebDirectories() {
        return this.gp;
    }

    public JTabbedPane getTp() {
        return this.tp;
    }

    public boolean isCurrentFileOpened() {
        return this.isCurrentFileSet;
    }

    private boolean isTabOpen(String name) {
        int i = 0;
        while (i < this.tp.getTabCount()) {
            if (name.equals(((AbstractPanel)this.tp.getComponent(i)).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setCloseFile() {
        this.isCurrentFileSet = false;
        this.currentFile = new File(String.valueOf(System.getProperty("user.home")) + File.separator + "Untitled.jbrofuzz");
    }

    public void setOpenFileTo(File f) {
        this.currentFile = f;
        this.isCurrentFileSet = true;
        String name = f.getName();
        if (name.endsWith(".jbrofuzz")) {
            name = name.substring(0, name.indexOf(".jbrofuzz"));
        }
        this.setTitle(name);
    }

    public void setTabHide(int n) {
        if (n == 125 && this.isTabOpen(this.pp.getName())) {
            this.tp.remove(this.pp);
        }
        if (n == 124 && this.isTabOpen(this.fp.getName())) {
            this.tp.remove(this.fp);
        }
        if (n == 126 && this.isTabOpen(this.cp.getName())) {
            this.tp.remove(this.cp);
        }
        if (n == 121 && this.isTabOpen(this.gp.getName())) {
            this.tp.remove(this.gp);
        }
    }

    public void setTabShow(int n) {
        if (n == 125) {
            if (!this.isTabOpen(this.pp.getName())) {
                this.tp.addTab(this.pp.getName(), this.pp);
            }
            this.tp.setSelectedComponent(this.pp);
        }
        if (n == 124) {
            if (!this.isTabOpen(this.fp.getName())) {
                this.tp.addTab(this.fp.getName(), this.fp);
            }
            this.tp.setSelectedComponent(this.fp);
        }
        if (n == 126) {
            if (!this.isTabOpen(this.cp.getName())) {
                this.tp.addTab(this.cp.getName(), this.cp);
            }
            this.tp.setSelectedComponent(this.cp);
        }
        if (n == 121) {
            if (!this.isTabOpen(this.gp.getName())) {
                this.tp.addTab(this.gp.getName(), this.gp);
            }
            this.tp.setSelectedComponent(this.gp);
        }
    }

    @Override
    public void setTitle(String s) {
        super.setTitle(" JBroFuzz - " + JBroFuzzFormat.centerAbbreviate(s, 256));
    }
}

