/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;

public class Button
extends ButtonBase {
    private BooleanProperty defaultButton;
    private BooleanProperty cancelButton;
    private static final String DEFAULT_STYLE_CLASS = "button";
    private static final String PSEUDO_CLASS_DEFAULT = "default";
    private static final String PSEUDO_CLASS_CANCEL = "cancel";
    private static final long PSEUDO_CLASS_DEFAULT_MASK = StyleManager.getInstance().getPseudoclassMask("default");
    private static final long PSEUDO_CLASS_CANCEL_MASK = StyleManager.getInstance().getPseudoclassMask("cancel");

    public Button() {
        this.initialize();
    }

    public Button(String string) {
        super(string);
        this.initialize();
    }

    public Button(String string, Node node) {
        super(string, node);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setMnemonicParsing(true);
    }

    public final void setDefaultButton(boolean bl) {
        this.defaultButtonProperty().set(bl);
    }

    public final boolean isDefaultButton() {
        return this.defaultButton == null ? false : this.defaultButton.get();
    }

    public final BooleanProperty defaultButtonProperty() {
        if (this.defaultButton == null) {
            this.defaultButton = new BooleanPropertyBase(false){

                @Override
                protected void invalidated() {
                    Button.this.impl_pseudoClassStateChanged(Button.PSEUDO_CLASS_DEFAULT);
                }

                @Override
                public Object getBean() {
                    return Button.this;
                }

                @Override
                public String getName() {
                    return "defaultButton";
                }
            };
        }
        return this.defaultButton;
    }

    public final void setCancelButton(boolean bl) {
        this.cancelButtonProperty().set(bl);
    }

    public final boolean isCancelButton() {
        return this.cancelButton == null ? false : this.cancelButton.get();
    }

    public final BooleanProperty cancelButtonProperty() {
        if (this.cancelButton == null) {
            this.cancelButton = new BooleanPropertyBase(false){

                @Override
                protected void invalidated() {
                    Button.this.impl_pseudoClassStateChanged(Button.PSEUDO_CLASS_CANCEL);
                }

                @Override
                public Object getBean() {
                    return Button.this;
                }

                @Override
                public String getName() {
                    return "cancelButton";
                }
            };
        }
        return this.cancelButton;
    }

    @Override
    public void fire() {
        this.fireEvent(new ActionEvent());
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.isDefaultButton()) {
            l |= PSEUDO_CLASS_DEFAULT_MASK;
        }
        if (this.isCancelButton()) {
            l |= PSEUDO_CLASS_CANCEL_MASK;
        }
        return l;
    }
}

