/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.TextBinding;
import com.sun.javafx.scene.control.skin.ContextMenuContent;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.Mnemonic;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class Utils {
    static Text helper = new Text();

    static double computeTextWidth(Font font, String string, double d) {
        helper.setText(string);
        helper.setFont(font);
        helper.setWrappingWidth(0.0);
        double d2 = Math.min(helper.prefWidth(-1.0), d);
        helper.setWrappingWidth((int)Math.ceil(d2));
        return Math.ceil(helper.getLayoutBounds().getWidth());
    }

    static double computeTextHeight(Font font, String string, double d) {
        helper.setText(string);
        helper.setFont(font);
        helper.setWrappingWidth((int)d);
        return helper.getLayoutBounds().getHeight();
    }

    static String computeClippedText(Font font, String string, double d, OverrunStyle overrunStyle, String string2) {
        char c;
        String string3;
        if (font == null) {
            throw new IllegalArgumentException("Must specify a font");
        }
        OverrunStyle overrunStyle2 = overrunStyle == null || OverrunStyle.CLIP.equals((Object)overrunStyle) ? OverrunStyle.ELLIPSIS : overrunStyle;
        String string4 = string3 = OverrunStyle.CLIP.equals((Object)overrunStyle) ? "" : string2;
        if (string == null || "".equals(string)) {
            return string;
        }
        double d2 = Utils.computeTextWidth(font, string, 0.0);
        if (d2 - d < (double)0.001f) {
            return string;
        }
        double d3 = Utils.computeTextWidth(font, string3, 0.0);
        double d4 = d - d3;
        if (d < d3) {
            return "";
        }
        if (overrunStyle2.equals((Object)OverrunStyle.ELLIPSIS) || overrunStyle2.equals((Object)OverrunStyle.WORD_ELLIPSIS) || overrunStyle2.equals((Object)OverrunStyle.LEADING_ELLIPSIS) || overrunStyle2.equals((Object)OverrunStyle.LEADING_WORD_ELLIPSIS)) {
            String string5;
            int n;
            boolean bl = OverrunStyle.WORD_ELLIPSIS.equals((Object)overrunStyle2) || OverrunStyle.LEADING_WORD_ELLIPSIS.equals((Object)overrunStyle2);
            double d5 = 0.0;
            int n2 = -1;
            int n3 = 0;
            int n4 = overrunStyle2.equals((Object)OverrunStyle.LEADING_ELLIPSIS) || overrunStyle2.equals((Object)OverrunStyle.LEADING_WORD_ELLIPSIS) ? string.length() - 1 : 0;
            int n5 = n4 == 0 ? string.length() - 1 : 0;
            int n6 = n = n4 == 0 ? 1 : -1;
            boolean bl2 = n4 == 0 ? n4 > n5 : n4 < n5;
            int n7 = n4;
            while (!bl2) {
                n3 = n7;
                char c2 = string.charAt(n3);
                d5 = Utils.computeTextWidth(font, n4 == 0 ? string.substring(0, n7 + 1) : string.substring(n7, n4 + 1), 0.0);
                if (Character.isWhitespace(c2)) {
                    n2 = n3;
                }
                if (d5 > d4) break;
                bl2 = n4 == 0 ? n7 >= n5 : n7 <= n5;
                n7 += n;
            }
            int n8 = n7 = !bl || n2 == -1 ? 1 : 0;
            String string6 = n4 == 0 ? string.substring(0, n7 != 0 ? n3 : n2) : (string5 = string.substring((n7 != 0 ? n3 : n2) + 1));
            if (OverrunStyle.ELLIPSIS.equals((Object)overrunStyle2) || OverrunStyle.WORD_ELLIPSIS.equals((Object)overrunStyle2)) {
                return string5 + string3;
            }
            return string3 + string5;
        }
        int n = 0;
        int n9 = 0;
        int n10 = -1;
        int n11 = -1;
        n = -1;
        n9 = -1;
        double d6 = 0.0;
        for (int i = 0; i <= string.length() - 1; ++i) {
            c = string.charAt(i);
            if ((d6 += Utils.computeTextWidth(font, "" + c, 0.0)) > d4) break;
            n = i;
            if (Character.isWhitespace(c)) {
                n10 = n;
            }
            int n12 = string.length() - 1 - i;
            c = string.charAt(n12);
            if ((d6 += Utils.computeTextWidth(font, "" + c, 0.0)) > d4) break;
            n9 = n12;
            if (!Character.isWhitespace(c)) continue;
            n11 = n9;
        }
        if (n < 0) {
            return string3;
        }
        if (OverrunStyle.CENTER_ELLIPSIS.equals((Object)overrunStyle2)) {
            if (n9 < 0) {
                return string.substring(0, n + 1) + string3;
            }
            return string.substring(0, n + 1) + string3 + string.substring(n9);
        }
        boolean bl = Character.isWhitespace(string.charAt(n + 1));
        int n13 = n10 == -1 || bl ? n + 1 : n10;
        String string7 = string.substring(0, n13);
        if (n9 < 0) {
            return string7 + string3;
        }
        c = (char)(Character.isWhitespace(string.charAt(n9 - 1)) ? 1 : 0);
        n13 = n11 == -1 || c != '\u0000' ? n9 : n11 + 1;
        String string8 = string.substring(n13);
        return string7 + string3 + string8;
    }

    static String computeClippedWrappedText(Font font, String string, double d, double d2, OverrunStyle overrunStyle, String string2) {
        Point2D point2D;
        int n;
        if (font == null) {
            throw new IllegalArgumentException("Must specify a font");
        }
        String string3 = overrunStyle == OverrunStyle.CLIP ? "" : string2;
        int n2 = string3.length();
        double d3 = Utils.computeTextWidth(font, string3, 0.0);
        double d4 = Utils.computeTextHeight(font, string3, 0.0);
        if (d < d3 || d2 < d4) {
            return "";
        }
        helper.setText(string);
        helper.setFont(font);
        helper.setWrappingWidth((int)Math.ceil(d));
        boolean bl = overrunStyle == OverrunStyle.LEADING_ELLIPSIS || overrunStyle == OverrunStyle.LEADING_WORD_ELLIPSIS;
        boolean bl2 = overrunStyle == OverrunStyle.CENTER_ELLIPSIS || overrunStyle == OverrunStyle.CENTER_WORD_ELLIPSIS;
        boolean bl3 = !bl && !bl2;
        boolean bl4 = overrunStyle == OverrunStyle.WORD_ELLIPSIS || overrunStyle == OverrunStyle.LEADING_WORD_ELLIPSIS || overrunStyle == OverrunStyle.CENTER_WORD_ELLIPSIS;
        String string4 = string;
        int n3 = string4 != null ? string4.length() : 0;
        int n4 = -1;
        Point2D point2D2 = null;
        if (bl2) {
            point2D2 = new Point2D((d - d3) / 2.0, d2 / 2.0 - helper.getBaselineOffset());
        }
        if ((n = helper.impl_hitTestChar(point2D = new Point2D(0.0, d2 - helper.getBaselineOffset())).getCharIndex()) >= n3) {
            return string;
        }
        if (bl2) {
            n = helper.impl_hitTestChar(point2D2).getCharIndex();
        }
        if (n > 0 && n < n3) {
            int n5;
            int n6;
            if (bl2 || bl3) {
                n6 = n;
                if (bl2) {
                    if (bl4) {
                        n5 = Utils.lastBreakCharIndex(string, n6 + 1);
                        if (n5 >= 0) {
                            n6 = n5 + 1;
                        } else {
                            n5 = Utils.firstBreakCharIndex(string, n6);
                            if (n5 >= 0) {
                                n6 = n5 + 1;
                            }
                        }
                    }
                    n4 = n6 + n2;
                }
                string4 = string4.substring(0, n6) + string3;
            }
            if (bl || bl2) {
                n6 = Math.max(0, n3 - n - 10);
                if (n6 > 0 && bl4) {
                    n5 = Utils.lastBreakCharIndex(string, n6 + 1);
                    if (n5 >= 0) {
                        n6 = n5 + 1;
                    } else {
                        n5 = Utils.firstBreakCharIndex(string, n6);
                        if (n5 >= 0) {
                            n6 = n5 + 1;
                        }
                    }
                }
                string4 = bl2 ? string4 + string.substring(n6) : string3 + string.substring(n6);
            }
            while (true) {
                int n7;
                helper.setText(string4);
                n6 = helper.impl_hitTestChar(point2D).getCharIndex();
                if (bl2 && n6 < n4) {
                    if (n6 > 0 && string4.charAt(n6 - 1) == '\n') {
                        --n6;
                    }
                    string4 = string.substring(0, n6) + string3;
                    break;
                }
                if (n6 <= 0 || n6 >= string4.length()) break;
                if (bl) {
                    n5 = n2 + 1;
                    if (bl4 && (n7 = Utils.firstBreakCharIndex(string4, n5)) >= 0) {
                        n5 = n7 + 1;
                    }
                    string4 = string3 + string4.substring(n5);
                    continue;
                }
                if (bl2) {
                    n5 = n4 + 1;
                    if (bl4 && (n7 = Utils.firstBreakCharIndex(string4, n5)) >= 0) {
                        n5 = n7 + 1;
                    }
                    string4 = string4.substring(0, n4) + string4.substring(n5);
                    continue;
                }
                n5 = string4.length() - n2 - 1;
                if (bl4 && (n7 = Utils.lastBreakCharIndex(string4, n5)) >= 0) {
                    n5 = n7;
                }
                string4 = string4.substring(0, n5) + string3;
            }
        }
        return string4;
    }

    private static int firstBreakCharIndex(String string, int n) {
        char[] cArray = string.toCharArray();
        for (int i = n; i < cArray.length; ++i) {
            if (!Utils.isPreferredBreakCharacter(cArray[i])) continue;
            return i;
        }
        return -1;
    }

    private static int lastBreakCharIndex(String string, int n) {
        char[] cArray = string.toCharArray();
        for (int i = n; i >= 0; --i) {
            if (!Utils.isPreferredBreakCharacter(cArray[i])) continue;
            return i;
        }
        return -1;
    }

    private static boolean isPreferredBreakCharacter(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        switch (c) {
            case '.': 
            case ':': 
            case ';': {
                return true;
            }
        }
        return false;
    }

    private static boolean requiresComplexLayout(Font font, String string) {
        return false;
    }

    static int computeStartOfWord(Font font, String string, int n) {
        if ("".equals(string) || n < 0) {
            return 0;
        }
        if (string.length() <= n) {
            return string.length();
        }
        if (Character.isWhitespace(string.charAt(n))) {
            return n;
        }
        boolean bl = Utils.requiresComplexLayout(font, string);
        if (bl) {
            return 0;
        }
        int n2 = n;
        while (--n2 >= 0) {
            if (!Character.isWhitespace(string.charAt(n2))) continue;
            return n2 + 1;
        }
        return 0;
    }

    static int computeEndOfWord(Font font, String string, int n) {
        if (string.equals("") || n < 0) {
            return 0;
        }
        if (string.length() <= n) {
            return string.length();
        }
        if (Character.isWhitespace(string.charAt(n))) {
            return n;
        }
        boolean bl = Utils.requiresComplexLayout(font, string);
        if (bl) {
            return string.length();
        }
        int n2 = n;
        while (++n2 < string.length()) {
            if (!Character.isWhitespace(string.charAt(n2))) continue;
            return n2;
        }
        return string.length();
    }

    public static double boundedSize(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), Math.max(d2, d3));
    }

    static void addMnemonics(ContextMenu contextMenu, Scene scene) {
        if (!PlatformUtil.isMac()) {
            ContextMenuContent contextMenuContent = (ContextMenuContent)contextMenu.getSkin().getNode();
            for (int i = 0; i < contextMenu.getItems().size(); ++i) {
                TextBinding textBinding;
                int n;
                MenuItem menuItem = (MenuItem)contextMenu.getItems().get(i);
                if (!menuItem.isMnemonicParsing() || (n = (textBinding = new TextBinding(menuItem.getText())).getMnemonicIndex()) < 0) continue;
                KeyCode keyCode = textBinding.getMnemonic();
                KeyCodeCombination keyCodeCombination = new KeyCodeCombination(keyCode, PlatformUtil.isMac() ? KeyCombination.META_DOWN : KeyCombination.ALT_DOWN);
                Mnemonic mnemonic = new Mnemonic(contextMenuContent.getLabelAt(i), keyCodeCombination);
                scene.addMnemonic(mnemonic);
            }
        }
    }

    static void removeMnemonics(ContextMenu contextMenu, Scene scene) {
        if (!PlatformUtil.isMac()) {
            ContextMenuContent contextMenuContent = (ContextMenuContent)contextMenu.getSkin().getNode();
            for (int i = 0; i < contextMenu.getItems().size(); ++i) {
                TextBinding textBinding;
                int n;
                MenuItem menuItem = (MenuItem)contextMenu.getItems().get(i);
                if (!menuItem.isMnemonicParsing() || (n = (textBinding = new TextBinding(menuItem.getText())).getMnemonicIndex()) < 0) continue;
                KeyCode keyCode = textBinding.getMnemonic();
                KeyCodeCombination keyCodeCombination = new KeyCodeCombination(keyCode, PlatformUtil.isMac() ? KeyCombination.META_DOWN : KeyCombination.ALT_DOWN);
                ObservableList observableList = (ObservableList)scene.getMnemonics().get(keyCodeCombination);
                if (observableList == null) continue;
                for (int j = 0; j < observableList.size(); ++j) {
                    if (((Mnemonic)observableList.get(j)).getNode() != contextMenuContent.getLabelAt(i)) continue;
                    observableList.remove(j);
                }
            }
        }
    }

    static double computeXOffset(double d, double d2, HPos hPos) {
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (d - d2) / 2.0;
            }
            case RIGHT: {
                return d - d2;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double d, double d2, VPos vPos) {
        switch (vPos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (d - d2) / 2.0;
            }
            case BOTTOM: {
                return d - d2;
            }
        }
        return 0.0;
    }
}

