/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.examples;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ApiResponseElement;
import org.zaproxy.clientapi.core.ApiResponseList;
import org.zaproxy.clientapi.core.ApiResponseSet;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;

public class AuthenticationApiExample {
    private static final String ZAP_ADDRESS = "localhost";
    private static final int ZAP_PORT = 8090;
    private static final String ZAP_API_KEY = null;

    private static void listAuthInformation(ClientApi clientApi) throws ClientApiException {
        LinkedList<String> linkedList = new LinkedList<String>();
        ApiResponseList apiResponseList = (ApiResponseList)clientApi.authentication.getSupportedAuthenticationMethods();
        for (ApiResponse object : apiResponseList.getItems()) {
            linkedList.add(((ApiResponseElement)object).getValue());
        }
        System.out.println("Supported authentication methods: " + linkedList);
        for (String string : linkedList) {
            ApiResponseList apiResponseList2 = (ApiResponseList)clientApi.authentication.getAuthenticationMethodConfigParams(string);
            for (ApiResponse apiResponse : apiResponseList2.getItems()) {
                ApiResponseSet apiResponseSet = (ApiResponseSet)apiResponse;
                System.out.println("'" + string + "' config param: " + apiResponseSet.getAttribute("name") + " (" + (apiResponseSet.getAttribute("mandatory").equals("true") ? "mandatory" : "optional") + ")");
            }
        }
    }

    private static void listUserConfigInformation(ClientApi clientApi) throws ClientApiException {
        String string = "1";
        ApiResponseList apiResponseList = (ApiResponseList)clientApi.users.getAuthenticationCredentialsConfigParams(string);
        StringBuilder stringBuilder = new StringBuilder("Users' config params: ");
        for (ApiResponse apiResponse : apiResponseList.getItems()) {
            ApiResponseSet apiResponseSet = (ApiResponseSet)apiResponse;
            stringBuilder.append(apiResponseSet.getAttribute("name")).append(" (");
            stringBuilder.append(apiResponseSet.getAttribute("mandatory").equals("true") ? "mandatory" : "optional");
            stringBuilder.append("), ");
        }
        System.out.println(stringBuilder.deleteCharAt(stringBuilder.length() - 2).toString());
    }

    private static void setLoggedInIndicator(ClientApi clientApi) throws UnsupportedEncodingException, ClientApiException {
        String string = "<a href=\"logout.jsp\"></a>";
        String string2 = "1";
        clientApi.authentication.setLoggedInIndicator(ZAP_API_KEY, string2, Pattern.quote(string));
        System.out.println("Configured logged in indicator regex: " + ((ApiResponseElement)clientApi.authentication.getLoggedInIndicator(string2)).getValue());
    }

    private static void setFormBasedAuthenticationForBodgeit(ClientApi clientApi) throws ClientApiException, UnsupportedEncodingException {
        String string = "1";
        String string2 = "http://localhost:8080/bodgeit/login.jsp";
        String string3 = "username={%username%}&password={%password%}";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("loginUrl=").append(URLEncoder.encode(string2, "UTF-8"));
        stringBuilder.append("&loginRequestData=").append(URLEncoder.encode(string3, "UTF-8"));
        System.out.println("Setting form based authentication configuration as: " + stringBuilder.toString());
        clientApi.authentication.setAuthenticationMethod(ZAP_API_KEY, string, "formBasedAuthentication", stringBuilder.toString());
        System.out.println("Authentication config: " + clientApi.authentication.getAuthenticationMethod(string).toString(0));
    }

    private static void setUserAuthConfigForBodgeit(ClientApi clientApi) throws ClientApiException, UnsupportedEncodingException {
        String string = "1";
        String string2 = "Test User";
        String string3 = "test@example.com";
        String string4 = "weakPassword";
        String string5 = AuthenticationApiExample.extractUserId(clientApi.users.newUser(ZAP_API_KEY, string, string2));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("username=").append(URLEncoder.encode(string3, "UTF-8"));
        stringBuilder.append("&password=").append(URLEncoder.encode(string4, "UTF-8"));
        System.out.println("Setting user authentication configuration as: " + stringBuilder.toString());
        clientApi.users.setAuthenticationCredentials(ZAP_API_KEY, string, string5, stringBuilder.toString());
        System.out.println("Authentication config: " + clientApi.users.getUserById(string, string5).toString(0));
    }

    private static String extractUserId(ApiResponse apiResponse) {
        return ((ApiResponseElement)apiResponse).getValue();
    }

    public static void main(String[] stringArray) throws ClientApiException, UnsupportedEncodingException {
        ClientApi clientApi = new ClientApi(ZAP_ADDRESS, 8090);
        AuthenticationApiExample.listAuthInformation(clientApi);
        System.out.println("-------------");
        AuthenticationApiExample.setFormBasedAuthenticationForBodgeit(clientApi);
        System.out.println("-------------");
        AuthenticationApiExample.setLoggedInIndicator(clientApi);
        System.out.println("-------------");
        AuthenticationApiExample.listUserConfigInformation(clientApi);
        System.out.println("-------------");
        AuthenticationApiExample.setUserAuthConfigForBodgeit(clientApi);
    }
}

