/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.ListManagedBlock;

class BlockListImpl
implements BlockList {
    private ListManagedBlock[] _blocks = new ListManagedBlock[0];
    private BlockAllocationTableReader _bat = null;

    protected BlockListImpl() {
    }

    protected void setBlocks(ListManagedBlock[] listManagedBlockArray) {
        this._blocks = listManagedBlockArray;
    }

    public void zap(int n) {
        if (n >= 0 && n < this._blocks.length) {
            this._blocks[n] = null;
        }
    }

    public ListManagedBlock remove(int n) throws IOException {
        ListManagedBlock listManagedBlock = null;
        try {
            listManagedBlock = this._blocks[n];
            if (listManagedBlock == null) {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("block[ ").append(n).append(" ] already removed"))));
            }
            this._blocks[n] = null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Cannot remove block[ ").append(n).append(" ]; out of range"))));
        }
        return listManagedBlock;
    }

    public ListManagedBlock[] fetchBlocks(int n) throws IOException {
        if (this._bat == null) {
            throw new IOException("Improperly initialized list: no block allocation table provided");
        }
        return this._bat.fetchBlocks(n, this);
    }

    public void setBAT(BlockAllocationTableReader blockAllocationTableReader) throws IOException {
        if (this._bat != null) {
            throw new IOException("Attempt to replace existing BlockAllocationTable");
        }
        this._bat = blockAllocationTableReader;
    }
}

