/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.utils;

import net.sourceforge.jffmpeg.codecs.utils.FFMpegException;

public class VLCTable {
    protected long[][] vlcCodes;
    protected int[] codeLength = new int[4096];
    protected int[] codeValue = new int[4096];
    protected VLCTable[] nextLevel = new VLCTable[4096];

    protected VLCTable() {
    }

    public final int getCodeLength(int n) {
        return this.codeLength[n];
    }

    public final int getCodeValue(int n) {
        return this.codeValue[n];
    }

    public final VLCTable getNextLevel(int n) {
        return this.nextLevel[n];
    }

    protected void createHighSpeedTable() {
        for (int i = 0; i < this.vlcCodes.length; ++i) {
            int n = (int)this.vlcCodes[i][0];
            int n2 = (int)this.vlcCodes[i][1];
            if (n2 == 0) continue;
            this.writeTable(i, n, n2);
        }
    }

    protected void writeTable(int n, int n2, int n3) {
        if (n3 < 13) {
            int n4 = n2 << 12 - n3;
            int n5 = n2 + 1 << 12 - n3;
            for (int i = n4; i < n5; ++i) {
                this.codeLength[i] = n3;
                this.codeValue[i] = n;
            }
        } else {
            int n6 = n2 >> n3 - 12;
            int n7 = n2 & ~(65535 << n3 - 12);
            this.codeLength[n6] = -1;
            if (this.nextLevel[n6] == null) {
                this.nextLevel[n6] = new VLCTable();
            }
            this.nextLevel[n6].writeTable(n, n7, n3 - 12);
        }
    }

    public int decode(int n, int n2) throws FFMpegException {
        boolean bl = true;
        for (int i = 0; i < this.vlcCodes.length; ++i) {
            bl &= this.vlcCodes[i][1] < (long)n2;
            if (this.vlcCodes[i][1] != (long)n2 || this.vlcCodes[i][0] != (long)n) continue;
            return i;
        }
        if (bl) {
            throw new FFMpegException("Illegal VLC code");
        }
        return -1;
    }
}

