/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.vorbis.mapping;

public class Mdct {
    public static final float cPI3_8 = 0.38268343f;
    public static final float cPI2_8 = 0.70710677f;
    public static final float cPI1_8 = 0.9238795f;
    private int n;
    private int log2n;
    private float[] trig;
    private int[] bitrev;
    private float scale;

    public Mdct(int n) {
        int n2;
        this.n = n;
        this.bitrev = new int[n / 4];
        float[] fArray = new float[n + n / 4];
        int n3 = n >> 1;
        this.log2n = (int)Math.rint(Math.log(n) / Math.log(2.0));
        this.trig = fArray;
        for (n2 = 0; n2 < n / 4; ++n2) {
            fArray[n2 * 2] = (float)Math.cos(Math.PI / (double)n * (double)(4 * n2));
            fArray[n2 * 2 + 1] = (float)(-Math.sin(Math.PI / (double)n * (double)(4 * n2)));
            fArray[n3 + n2 * 2] = (float)Math.cos(Math.PI / (double)(2 * n) * (double)(2 * n2 + 1));
            fArray[n3 + n2 * 2 + 1] = (float)Math.sin(Math.PI / (double)(2 * n) * (double)(2 * n2 + 1));
        }
        for (n2 = 0; n2 < n / 8; ++n2) {
            fArray[n + n2 * 2] = (float)(Math.cos(Math.PI / (double)n * (double)(4 * n2 + 2)) * 0.5);
            fArray[n + n2 * 2 + 1] = (float)(-Math.sin(Math.PI / (double)n * (double)(4 * n2 + 2)) * 0.5);
        }
        n2 = (1 << this.log2n - 1) - 1;
        int n4 = 1 << this.log2n - 2;
        for (int i = 0; i < n / 8; ++i) {
            int n5 = 0;
            int n6 = 0;
            while (n4 >> n6 != 0) {
                if ((n4 >> n6 & i) != 0) {
                    n5 |= 1 << n6;
                }
                ++n6;
            }
            this.bitrev[i * 2] = (~n5 & n2) - 1;
            this.bitrev[i * 2 + 1] = n5;
        }
        this.scale = 4.0f / (float)n;
    }

    public void mdct_backward(float[] fArray, float[] fArray2) {
        int n = this.n >> 1;
        int n2 = this.n >> 2;
        int n3 = n - 7;
        int n4 = n + n2;
        int n5 = n2;
        do {
            fArray2[n4 -= 4] = -fArray[n3 + 2] * this.trig[n5 + 3] - fArray[n3 + 0] * this.trig[n5 + 2];
            fArray2[n4 + 1] = fArray[n3 + 0] * this.trig[n5 + 3] - fArray[n3 + 2] * this.trig[n5 + 2];
            fArray2[n4 + 2] = -fArray[n3 + 6] * this.trig[n5 + 1] - fArray[n3 + 4] * this.trig[n5 + 0];
            fArray2[n4 + 3] = fArray[n3 + 4] * this.trig[n5 + 1] - fArray[n3 + 6] * this.trig[n5 + 0];
            n5 += 4;
        } while ((n3 -= 8) >= 0);
        n3 = n - 8;
        n4 = n + n2;
        n5 = n2;
        do {
            fArray2[n4 + 0] = fArray[n3 + 4] * this.trig[(n5 -= 4) + 3] + fArray[n3 + 6] * this.trig[n5 + 2];
            fArray2[n4 + 1] = fArray[n3 + 4] * this.trig[n5 + 2] - fArray[n3 + 6] * this.trig[n5 + 3];
            fArray2[n4 + 2] = fArray[n3 + 0] * this.trig[n5 + 1] + fArray[n3 + 2] * this.trig[n5 + 0];
            fArray2[n4 + 3] = fArray[n3 + 0] * this.trig[n5 + 0] - fArray[n3 + 2] * this.trig[n5 + 1];
            n4 += 4;
        } while ((n3 -= 8) >= 0);
        this.mdct_butterflies(fArray2, n, n);
        this.mdct_bitreverse(fArray2);
        int n6 = n + n2;
        int n7 = n + n2;
        n3 = 0;
        n5 = n;
        do {
            fArray2[(n6 -= 4) + 3] = fArray2[n3 + 0] * this.trig[n5 + 1] - fArray2[n3 + 1] * this.trig[n5 + 0];
            fArray2[n7 + 0] = -(fArray2[n3 + 0] * this.trig[n5 + 0] + fArray2[n3 + 1] * this.trig[n5 + 1]);
            fArray2[n6 + 2] = fArray2[n3 + 2] * this.trig[n5 + 3] - fArray2[n3 + 3] * this.trig[n5 + 2];
            fArray2[n7 + 1] = -(fArray2[n3 + 2] * this.trig[n5 + 2] + fArray2[n3 + 3] * this.trig[n5 + 3]);
            fArray2[n6 + 1] = fArray2[n3 + 4] * this.trig[n5 + 5] - fArray2[n3 + 5] * this.trig[n5 + 4];
            fArray2[n7 + 2] = -(fArray2[n3 + 4] * this.trig[n5 + 4] + fArray2[n3 + 5] * this.trig[n5 + 5]);
            fArray2[n6 + 0] = fArray2[n3 + 6] * this.trig[n5 + 7] - fArray2[n3 + 7] * this.trig[n5 + 6];
            fArray2[n7 + 3] = -(fArray2[n3 + 6] * this.trig[n5 + 6] + fArray2[n3 + 7] * this.trig[n5 + 7]);
            n7 += 4;
            n5 += 8;
        } while ((n3 += 8) < n6);
        n3 = n + n2;
        n7 = n6 = n2;
        do {
            fArray2[(n6 -= 4) + 3] = fArray2[(n3 -= 4) + 3];
            fArray2[n7 + 0] = -fArray2[n3 + 3];
            fArray2[n6 + 2] = fArray2[n3 + 2];
            fArray2[n7 + 1] = -fArray2[n3 + 2];
            fArray2[n6 + 1] = fArray2[n3 + 1];
            fArray2[n7 + 2] = -fArray2[n3 + 1];
            fArray2[n6 + 0] = fArray2[n3 + 0];
            fArray2[n7 + 3] = -fArray2[n3 + 0];
        } while ((n7 += 4) < n3);
        n3 = n + n2;
        n6 = n + n2;
        n7 = n;
        do {
            fArray2[(n6 -= 4) + 0] = fArray2[n3 + 3];
            fArray2[n6 + 1] = fArray2[n3 + 2];
            fArray2[n6 + 2] = fArray2[n3 + 1];
            fArray2[n6 + 3] = fArray2[n3 + 0];
            n3 += 4;
        } while (n6 > n7);
    }

    private void mdct_butterflies(float[] fArray, int n, int n2) {
        int n3 = this.log2n - 5;
        if (--n3 > 0) {
            this.mdct_butterfly_first(fArray, n, n2);
        }
        int n4 = 1;
        while (--n3 > 0) {
            for (int i = 0; i < 1 << n4; ++i) {
                this.mdct_butterfly_generic(fArray, n + (n2 >> n4) * i, n2 >> n4, 4 << n4);
            }
            ++n4;
        }
        for (n4 = 0; n4 < n2; n4 += 32) {
            this.mdct_butterfly_32(fArray, n + n4);
        }
    }

    private void mdct_butterfly_first(float[] fArray, int n, int n2) {
        int n3 = n + n2 - 8;
        int n4 = n + (n2 >> 1) - 8;
        int n5 = 0;
        do {
            float f = fArray[n3 + 6] - fArray[n4 + 6];
            float f2 = fArray[n3 + 7] - fArray[n4 + 7];
            int n6 = n3 + 6;
            fArray[n6] = fArray[n6] + fArray[n4 + 6];
            int n7 = n3 + 7;
            fArray[n7] = fArray[n7] + fArray[n4 + 7];
            fArray[n4 + 6] = f2 * this.trig[n5 + 1] + f * this.trig[n5 + 0];
            fArray[n4 + 7] = f2 * this.trig[n5 + 0] - f * this.trig[n5 + 1];
            f = fArray[n3 + 4] - fArray[n4 + 4];
            f2 = fArray[n3 + 5] - fArray[n4 + 5];
            int n8 = n3 + 4;
            fArray[n8] = fArray[n8] + fArray[n4 + 4];
            int n9 = n3 + 5;
            fArray[n9] = fArray[n9] + fArray[n4 + 5];
            fArray[n4 + 4] = f2 * this.trig[n5 + 5] + f * this.trig[n5 + 4];
            fArray[n4 + 5] = f2 * this.trig[n5 + 4] - f * this.trig[n5 + 5];
            f = fArray[n3 + 2] - fArray[n4 + 2];
            f2 = fArray[n3 + 3] - fArray[n4 + 3];
            int n10 = n3 + 2;
            fArray[n10] = fArray[n10] + fArray[n4 + 2];
            int n11 = n3 + 3;
            fArray[n11] = fArray[n11] + fArray[n4 + 3];
            fArray[n4 + 2] = f2 * this.trig[n5 + 9] + f * this.trig[n5 + 8];
            fArray[n4 + 3] = f2 * this.trig[n5 + 8] - f * this.trig[n5 + 9];
            f = fArray[n3 + 0] - fArray[n4 + 0];
            f2 = fArray[n3 + 1] - fArray[n4 + 1];
            int n12 = n3 + 0;
            fArray[n12] = fArray[n12] + fArray[n4 + 0];
            int n13 = n3 + 1;
            fArray[n13] = fArray[n13] + fArray[n4 + 1];
            fArray[n4 + 0] = f2 * this.trig[n5 + 13] + f * this.trig[n5 + 12];
            fArray[n4 + 1] = f2 * this.trig[n5 + 12] - f * this.trig[n5 + 13];
            n3 -= 8;
            n5 += 16;
        } while ((n4 -= 8) >= n);
    }

    private void mdct_butterfly_generic(float[] fArray, int n, int n2, int n3) {
        int n4 = n + n2 - 8;
        int n5 = n + (n2 >> 1) - 8;
        int n6 = 0;
        do {
            float f = fArray[n4 + 6] - fArray[n5 + 6];
            float f2 = fArray[n4 + 7] - fArray[n5 + 7];
            int n7 = n4 + 6;
            fArray[n7] = fArray[n7] + fArray[n5 + 6];
            int n8 = n4 + 7;
            fArray[n8] = fArray[n8] + fArray[n5 + 7];
            fArray[n5 + 6] = f2 * this.trig[n6 + 1] + f * this.trig[n6 + 0];
            fArray[n5 + 7] = f2 * this.trig[n6 + 0] - f * this.trig[n6 + 1];
            n6 += n3;
            f = fArray[n4 + 4] - fArray[n5 + 4];
            f2 = fArray[n4 + 5] - fArray[n5 + 5];
            int n9 = n4 + 4;
            fArray[n9] = fArray[n9] + fArray[n5 + 4];
            int n10 = n4 + 5;
            fArray[n10] = fArray[n10] + fArray[n5 + 5];
            fArray[n5 + 4] = f2 * this.trig[n6 + 1] + f * this.trig[n6 + 0];
            fArray[n5 + 5] = f2 * this.trig[n6 + 0] - f * this.trig[n6 + 1];
            n6 += n3;
            f = fArray[n4 + 2] - fArray[n5 + 2];
            f2 = fArray[n4 + 3] - fArray[n5 + 3];
            int n11 = n4 + 2;
            fArray[n11] = fArray[n11] + fArray[n5 + 2];
            int n12 = n4 + 3;
            fArray[n12] = fArray[n12] + fArray[n5 + 3];
            fArray[n5 + 2] = f2 * this.trig[n6 + 1] + f * this.trig[n6 + 0];
            fArray[n5 + 3] = f2 * this.trig[n6 + 0] - f * this.trig[n6 + 1];
            n6 += n3;
            f = fArray[n4 + 0] - fArray[n5 + 0];
            f2 = fArray[n4 + 1] - fArray[n5 + 1];
            int n13 = n4 + 0;
            fArray[n13] = fArray[n13] + fArray[n5 + 0];
            int n14 = n4 + 1;
            fArray[n14] = fArray[n14] + fArray[n5 + 1];
            fArray[n5 + 0] = f2 * this.trig[n6 + 1] + f * this.trig[n6 + 0];
            fArray[n5 + 1] = f2 * this.trig[n6 + 0] - f * this.trig[n6 + 1];
            n6 += n3;
            n4 -= 8;
        } while ((n5 -= 8) >= n);
    }

    private void mdct_butterfly_32(float[] fArray, int n) {
        float f = fArray[n + 30] - fArray[n + 14];
        float f2 = fArray[n + 31] - fArray[n + 15];
        int n2 = n + 30;
        fArray[n2] = fArray[n2] + fArray[n + 14];
        int n3 = n + 31;
        fArray[n3] = fArray[n3] + fArray[n + 15];
        fArray[n + 14] = f;
        fArray[n + 15] = f2;
        f = fArray[n + 28] - fArray[n + 12];
        f2 = fArray[n + 29] - fArray[n + 13];
        int n4 = n + 28;
        fArray[n4] = fArray[n4] + fArray[n + 12];
        int n5 = n + 29;
        fArray[n5] = fArray[n5] + fArray[n + 13];
        fArray[n + 12] = f * 0.9238795f - f2 * 0.38268343f;
        fArray[n + 13] = f * 0.38268343f + f2 * 0.9238795f;
        f = fArray[n + 26] - fArray[n + 10];
        f2 = fArray[n + 27] - fArray[n + 11];
        int n6 = n + 26;
        fArray[n6] = fArray[n6] + fArray[n + 10];
        int n7 = n + 27;
        fArray[n7] = fArray[n7] + fArray[n + 11];
        fArray[n + 10] = (f - f2) * 0.70710677f;
        fArray[n + 11] = (f + f2) * 0.70710677f;
        f = fArray[n + 24] - fArray[n + 8];
        f2 = fArray[n + 25] - fArray[n + 9];
        int n8 = n + 24;
        fArray[n8] = fArray[n8] + fArray[n + 8];
        int n9 = n + 25;
        fArray[n9] = fArray[n9] + fArray[n + 9];
        fArray[n + 8] = f * 0.38268343f - f2 * 0.9238795f;
        fArray[n + 9] = f2 * 0.38268343f + f * 0.9238795f;
        f = fArray[n + 22] - fArray[n + 6];
        f2 = fArray[n + 7] - fArray[n + 23];
        int n10 = n + 22;
        fArray[n10] = fArray[n10] + fArray[n + 6];
        int n11 = n + 23;
        fArray[n11] = fArray[n11] + fArray[n + 7];
        fArray[n + 6] = f2;
        fArray[n + 7] = f;
        f = fArray[n + 4] - fArray[n + 20];
        f2 = fArray[n + 5] - fArray[n + 21];
        int n12 = n + 20;
        fArray[n12] = fArray[n12] + fArray[n + 4];
        int n13 = n + 21;
        fArray[n13] = fArray[n13] + fArray[n + 5];
        fArray[n + 4] = f2 * 0.9238795f + f * 0.38268343f;
        fArray[n + 5] = f2 * 0.38268343f - f * 0.9238795f;
        f = fArray[n + 2] - fArray[n + 18];
        f2 = fArray[n + 3] - fArray[n + 19];
        int n14 = n + 18;
        fArray[n14] = fArray[n14] + fArray[n + 2];
        int n15 = n + 19;
        fArray[n15] = fArray[n15] + fArray[n + 3];
        fArray[n + 2] = (f2 + f) * 0.70710677f;
        fArray[n + 3] = (f2 - f) * 0.70710677f;
        f = fArray[n + 0] - fArray[n + 16];
        f2 = fArray[n + 1] - fArray[n + 17];
        int n16 = n + 16;
        fArray[n16] = fArray[n16] + fArray[n + 0];
        int n17 = n + 17;
        fArray[n17] = fArray[n17] + fArray[n + 1];
        fArray[n + 0] = f2 * 0.38268343f + f * 0.9238795f;
        fArray[n + 1] = f2 * 0.9238795f - f * 0.38268343f;
        this.mdct_butterfly_16(fArray, n);
        this.mdct_butterfly_16(fArray, n + 16);
    }

    private void mdct_butterfly_16(float[] fArray, int n) {
        float f = fArray[n + 1] - fArray[n + 9];
        float f2 = fArray[n + 0] - fArray[n + 8];
        int n2 = n + 8;
        fArray[n2] = fArray[n2] + fArray[n + 0];
        int n3 = n + 9;
        fArray[n3] = fArray[n3] + fArray[n + 1];
        fArray[n + 0] = (f + f2) * 0.70710677f;
        fArray[n + 1] = (f - f2) * 0.70710677f;
        f = fArray[n + 3] - fArray[n + 11];
        f2 = fArray[n + 10] - fArray[n + 2];
        int n4 = n + 10;
        fArray[n4] = fArray[n4] + fArray[n + 2];
        int n5 = n + 11;
        fArray[n5] = fArray[n5] + fArray[n + 3];
        fArray[n + 2] = f;
        fArray[n + 3] = f2;
        f = fArray[n + 12] - fArray[n + 4];
        f2 = fArray[n + 13] - fArray[n + 5];
        int n6 = n + 12;
        fArray[n6] = fArray[n6] + fArray[n + 4];
        int n7 = n + 13;
        fArray[n7] = fArray[n7] + fArray[n + 5];
        fArray[n + 4] = (f - f2) * 0.70710677f;
        fArray[n + 5] = (f + f2) * 0.70710677f;
        f = fArray[n + 14] - fArray[n + 6];
        f2 = fArray[n + 15] - fArray[n + 7];
        int n8 = n + 14;
        fArray[n8] = fArray[n8] + fArray[n + 6];
        int n9 = n + 15;
        fArray[n9] = fArray[n9] + fArray[n + 7];
        fArray[n + 6] = f;
        fArray[n + 7] = f2;
        this.mdct_butterfly_8(fArray, n);
        this.mdct_butterfly_8(fArray, n + 8);
    }

    private void mdct_butterfly_8(float[] fArray, int n) {
        float f = fArray[n + 6] + fArray[n + 2];
        float f2 = fArray[n + 6] - fArray[n + 2];
        float f3 = fArray[n + 4] + fArray[n + 0];
        float f4 = fArray[n + 4] - fArray[n + 0];
        fArray[n + 6] = f + f3;
        fArray[n + 4] = f - f3;
        f = fArray[n + 5] - fArray[n + 1];
        f3 = fArray[n + 7] - fArray[n + 3];
        fArray[n + 0] = f2 + f;
        fArray[n + 2] = f2 - f;
        f = fArray[n + 5] + fArray[n + 1];
        f2 = fArray[n + 7] + fArray[n + 3];
        fArray[n + 3] = f3 + f4;
        fArray[n + 1] = f3 - f4;
        fArray[n + 7] = f2 + f;
        fArray[n + 5] = f2 - f;
    }

    private void mdct_bitreverse(float[] fArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.n >> 1;
        int n5 = this.n;
        do {
            int n6 = n4 + this.bitrev[n2 + 0];
            int n7 = n4 + this.bitrev[n2 + 1];
            float f = fArray[n6 + 1] - fArray[n7 + 1];
            float f2 = fArray[n6 + 0] + fArray[n7 + 0];
            float f3 = f2 * this.trig[n5 + 0] + f * this.trig[n5 + 1];
            float f4 = f2 * this.trig[n5 + 1] - f * this.trig[n5 + 0];
            f = (fArray[n6 + 1] + fArray[n7 + 1]) / 2.0f;
            f2 = (fArray[n6 + 0] - fArray[n7 + 0]) / 2.0f;
            fArray[n3 + 0] = f + f3;
            fArray[(n -= 4) + 2] = f - f3;
            fArray[n3 + 1] = f2 + f4;
            fArray[n + 3] = f4 - f2;
            n6 = n4 + this.bitrev[n2 + 2];
            n7 = n4 + this.bitrev[n2 + 3];
            f = fArray[n6 + 1] - fArray[n7 + 1];
            f2 = fArray[n6 + 0] + fArray[n7 + 0];
            f3 = f2 * this.trig[n5 + 2] + f * this.trig[n5 + 3];
            f4 = f2 * this.trig[n5 + 3] - f * this.trig[n5 + 2];
            f = (fArray[n6 + 1] + fArray[n7 + 1]) / 2.0f;
            f2 = (fArray[n6 + 0] - fArray[n7 + 0]) / 2.0f;
            fArray[n3 + 2] = f + f3;
            fArray[n + 0] = f - f3;
            fArray[n3 + 3] = f2 + f4;
            fArray[n + 1] = f4 - f2;
            n5 += 4;
            n2 += 4;
        } while ((n3 += 4) < n);
    }
}

