/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNodeList
implements NodeList,
Serializable,
Cloneable {
    XMLNSNode parent;
    XMLNode[] nodeArray;
    int nodeCount;
    int flags;
    long cstate = 0L;
    static XMLNodeList EMPTY_NODELIST = new XMLNodeList();
    static final int LIVE_NODELIST = 65536;

    private native int xdbGetLength(long var1, long var3);

    private native long xdbGetChild(long var1, long var3, long var5);

    public XMLNodeList() {
        this.flags |= 1;
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[4];
    }

    public XMLNodeList(int n) {
        this.flags |= 1;
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[n];
    }

    public XMLNodeList(XMLNSNode xMLNSNode) {
        this.parent = xMLNSNode;
        switch (xMLNSNode.flags & 3) {
            case 1: {
                this.flags |= 1;
                break;
            }
            case 2: {
                this.flags |= 2;
            }
        }
        this.flags |= 0x10000;
    }

    XMLNodeList(XMLDocument xMLDocument, long l) {
        this.flags |= 2;
        this.cstate = l;
        this.parent = xMLDocument;
    }

    public XMLNodeList(NodeList nodeList) {
        this.flags |= 1;
        this.nodeCount = nodeList.getLength();
        this.nodeArray = new XMLNode[this.nodeCount];
        for (int i = 0; i < this.nodeCount; ++i) {
            this.nodeArray[i] = (XMLNode)nodeList.item(i);
        }
    }

    public void setDebugFlag() {
        this.flags |= 1;
    }

    public int getLength() {
        switch (this.flags & 3) {
            case 1: {
                if (this.parent != null) {
                    int n = 0;
                    Node node = this.parent.getFirstChild();
                    if (node instanceof XMLDeclPI) {
                        --n;
                    }
                    while (node != null) {
                        ++n;
                        node = node.getNextSibling();
                    }
                    return n;
                }
                return this.nodeCount;
            }
            case 2: {
                if ((this.flags & 0x10000) == 65536) {
                    this.cstate = this.parent.xdbGetChildNodes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                }
                if (this.cstate == 0L) break;
                return this.xdbGetLength(this.parent.xdbGetCtx(), this.cstate);
            }
        }
        return 0;
    }

    public Node item(int n) {
        switch (this.flags & 3) {
            case 1: {
                if (this.parent != null) {
                    Node node = this.parent.getFirstChild();
                    if (node instanceof XMLDeclPI) {
                        ++n;
                    }
                    while (node != null) {
                        if (n == 0) {
                            return node;
                        }
                        --n;
                        node = node.getNextSibling();
                    }
                    return null;
                }
                if (n >= 0 && n < this.nodeCount) {
                    return this.nodeArray[n];
                }
                return null;
            }
            case 2: {
                long l;
                if ((this.flags & 0x10000) == 65536) {
                    this.cstate = this.parent.xdbGetChildNodes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                }
                if (this.cstate == 0L || (l = this.xdbGetChild(this.parent.xdbGetCtx(), this.cstate, n)) == 0L) break;
                return this.parent.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    void ensureCapacity() {
        if (this.nodeCount >= this.nodeArray.length) {
            XMLNode[] xMLNodeArray = this.nodeArray;
            this.nodeArray = new XMLNode[this.nodeArray.length * 2];
            System.arraycopy(xMLNodeArray, 0, this.nodeArray, 0, xMLNodeArray.length);
        }
    }

    public void addNode(Node node) {
        switch (this.flags & 3) {
            case 1: {
                this.ensureCapacity();
                this.nodeArray[this.nodeCount] = (XMLNode)node;
                ++this.nodeCount;
                break;
            }
        }
    }
}

