/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XSDCharClass;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDRegexProgram;

class XSDRegexVM
implements XSDConstantValues {
    private int fpos;
    private int count;
    private static final int F_COUNT = 0x1000000;
    XSDRegexProgram program;
    String value;
    int idx;
    int len;

    XSDRegexVM() {
    }

    void setProgram(XSDRegexProgram xSDRegexProgram) {
        this.program = xSDRegexProgram;
    }

    static boolean isXMLSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static boolean isWEsc(char c) {
        int n = 1643118592;
        int n2 = Character.getType(c);
        if ((n & 1 << n2) != 0) {
            return false;
        }
        n = 28672;
        if ((n & 1 << n2) != 0) {
            return false;
        }
        n = 360449;
        return (n & 1 << n2) == 0;
    }

    protected int matchNodes(int n, int n2, int n3) throws XSDException {
        int n4 = n3;
        int n5 = this.len;
        char[] cArray = this.program.instruction;
        XSDCharClass[] xSDCharClassArray = this.program.chClass;
        int n6 = n;
        block12: while (n6 < n2) {
            char c = cArray[n6];
            int n7 = n6 + (short)cArray[n6 + 2];
            char c2 = cArray[n6 + 1];
            switch (c) {
                case 'G': 
                case 'N': {
                    break;
                }
                case '(': {
                    return this.matchNodes(n7, 65536, n4);
                }
                case ')': {
                    return this.matchNodes(n7, 65536, n4);
                }
                case '\\': {
                    if (n4 >= n5) {
                        return -1;
                    }
                    if (xSDCharClassArray[c2].match(this.value.charAt(n4++))) break;
                    return -1;
                }
                case '.': {
                    if (n4 < n5 && this.value.charAt(n4++) != '\n') break;
                    return -1;
                }
                case 'A': {
                    int n8;
                    if (n4 >= n5) {
                        return -1;
                    }
                    char c3 = c2;
                    int n9 = n6 + 3;
                    if (n5 - n4 < c3) {
                        return -1;
                    }
                    for (n8 = 0; n8 < c3; ++n8) {
                        if (this.value.charAt(n4++) == cArray[n9 + n8]) continue;
                        return this.detect(n4 - 1);
                    }
                    break;
                }
                case 'P': 
                case 'p': {
                    if (n4 >= n5) {
                        return -1;
                    }
                    if (xSDCharClassArray[c2].match(this.value.charAt(n4++))) break;
                    return this.detect(n4 - 1);
                }
                case '[': {
                    if (n4 >= n5) {
                        return -1;
                    }
                    int n8 = this.value.charAt(n4);
                    if (!xSDCharClassArray[cArray[n6 + 3]].match((char)n8)) {
                        return this.detect(n4);
                    }
                    ++n4;
                    break;
                }
                case '|': {
                    short s;
                    if (cArray[n7] != '|') {
                        n6 += 3;
                        continue block12;
                    }
                    do {
                        int n10;
                        if ((n10 = this.matchNodes(n6 + 3, 65536, n4)) != this.len) continue;
                        return n10;
                    } while ((s = (short)cArray[n6 + 2]) != 0 && cArray[n6 += s] == '|');
                    return -1;
                }
                case 'E': {
                    return n4;
                }
                default: {
                    this.error(24000, "Invalid opcode.");
                }
            }
            n6 = n7;
        }
        this.error(24000, "Reach an invalid state.");
        return -1;
    }

    boolean match(String string) throws XSDException {
        if (this.program == null) {
            this.error(24000, "Invalid state.");
        }
        this.value = string;
        this.len = string.length();
        this.fpos = -1;
        this.count = 0;
        int n = this.matchNodes(0, 65536, 0);
        return n == this.len;
    }

    private int detect(int n) throws XSDException {
        if (n == this.fpos) {
            ++this.count;
            if (this.count == 10) {
                this.program.checkChar(this.value.charAt(n));
            }
        } else {
            if (n > this.fpos) {
                this.fpos = n;
                this.count = 0;
                return -1;
            }
            return -1;
        }
        if (this.count > 0x1000000) {
            this.error(24000, "Regex Error");
        }
        return -1;
    }

    private void error(int n, String string) throws XSDException {
        throw new XSDException(n, string);
    }

    private void error2(int n, String string, String string2) throws XSDException {
        throw new XSDException(n, string, string2);
    }
}

