/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.util.FastVector;

public class XSDComplexType
extends XSDNode {
    XSDGroup group;
    XSDGroup typeGroup;
    XSDAttrGroup attrGroup;
    XSDSimpleType simpleType;
    BitSet properties;
    boolean simpleContent;
    int content;
    String derivedBy;
    String refNamespace;
    String refLocalname;
    String includingNS;
    XSDNode base;
    int refState;
    boolean parsed;
    static XSDComplexType urType;
    static BitSet BlockAll;
    static BitSet FinalAll;
    static BitSet BFNONE;

    public static void init() throws XSDException {
    }

    XSDComplexType() {
        this.nodeType = 1;
        this.base = null;
        this.derivedBy = "#undef";
        this.refState = 6;
        this.content = 21;
        this.attrGroup = new XSDAttrGroup(6);
        this.attrGroup.parent = this;
        this.properties = new BitSet(8);
        this.parsed = true;
    }

    void initTypeGroup(int n) {
        this.typeGroup = new XSDGroup();
        this.typeGroup.order = n;
        if (n == 0) {
            this.typeGroup.minOccurs = 1;
            this.typeGroup.maxOccurs = 1;
        } else if (n == 1) {
            this.typeGroup.minOccurs = 0;
            this.typeGroup.maxOccurs = 0x7FFFFFF8;
        }
        this.typeGroup.parent = this;
    }

    void setTypeGroup(XSDGroup xSDGroup) {
        this.typeGroup = xSDGroup;
        this.typeGroup.parent = this;
    }

    public XSDSimpleType getSimpleType() {
        return this.simpleType;
    }

    public XSDNode getNamedBaseType() {
        if (this.name != null || this == urType) {
            return this;
        }
        if (this.base != null) {
            return this.base.getNamedBaseType();
        }
        return null;
    }

    int postProcess(FastVector fastVector, Hashtable hashtable) throws Exception {
        if (this.group == null) {
            this.group = new XSDGroup();
            this.group.topGroup = true;
            this.group.parent = this;
            this.group.order = 0;
            this.group.minOccurs = 1;
            this.group.maxOccurs = 1;
            if (this.typeGroup == null) {
                if (this.simpleType != null) {
                    this.simpleType.parseDerivation();
                    this.group.nodeVector.addElement(this.simpleType);
                    this.group.vectorSize = this.group.nodeVector.size();
                }
            } else {
                this.group.addParticleNode(this.typeGroup);
            }
        }
        this.resolveAttrGroup();
        if (this.derivedBy == "restriction" && this.base != null && !this.isValidRestriction((XSDComplexType)this.base)) {
            throw new XSDException(24226, this.base.name, this.domNode);
        }
        this.group.postProcess(fastVector, hashtable);
        return 0;
    }

    boolean isValidRestriction(XSDComplexType xSDComplexType) {
        if (xSDComplexType == urType) {
            return true;
        }
        if (!this.attrGroup.isValidRestriction(xSDComplexType.attrGroup)) {
            return false;
        }
        if (this.simpleContent && xSDComplexType.simpleContent) {
            return this.simpleType.isDerivedFrom(xSDComplexType.simpleType, BFNONE);
        }
        if (this.content == 10 && !xSDComplexType.isEmptiable()) {
            return false;
        }
        return this.content != 13 || xSDComplexType.content == 13;
    }

    public XSDGroup getGroup() {
        return this.group;
    }

    void resolveAttrGroup() throws XSDException {
        this.attrGroup.resolveGroup();
    }

    public XSDGroup getTypeGroup() {
        return this.typeGroup;
    }

    XSDAttrGroup getAttrGroup() {
        return this.attrGroup;
    }

    void setBaseRef(String string, String string2) {
        this.refLocalname = string2;
        this.refNamespace = string;
        this.refState = 7;
    }

    void setBaseType(XSDNode xSDNode) {
        this.base = xSDNode;
        this.refState = 6;
    }

    public XSDNode getBaseType() {
        return this.base;
    }

    public String getRefLocalname() {
        return this.refLocalname;
    }

    void setDerivedBy(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 != "restriction" && string2 != "extension") {
            throw new XSDException();
        }
        this.derivedBy = string2;
        this.attrGroup.restriction = string2 == "restriction";
    }

    void setContent(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 == "textOnly") {
            this.content = 11;
        } else if (string2 == "mixed") {
            this.content = 13;
        } else if (string2 == "elementOnly") {
            this.content = 12;
        } else if (string2 == "empty") {
            this.content = 10;
        } else {
            throw new XSDException();
        }
    }

    void setMixedContent(boolean bl) {
        this.content = bl ? 13 : 12;
    }

    public int getContent() {
        return this.content;
    }

    BitSet getProperties() {
        return this.properties;
    }

    void setAbstract(boolean bl) {
        if (bl) {
            this.properties.set(7);
        }
    }

    void setSimpleContent(boolean bl) {
        this.simpleContent = bl;
    }

    boolean isParsed() {
        return this.parsed;
    }

    public boolean isAbstract() {
        return this.properties.get(7);
    }

    public boolean isSimpleContent() {
        return this.simpleContent;
    }

    boolean isEmptiable() {
        if (this.simpleContent) {
            return true;
        }
        if (this.content == 10) {
            return true;
        }
        if (this.typeGroup != null) {
            return this.typeGroup.isEmptiable();
        }
        return true;
    }

    public XSDNode[] getElementSet() {
        if (this.typeGroup != null) {
            Vector vector = this.typeGroup.getNodeVector();
            Object[] objectArray = new XSDNode[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public XSDNode[] getBaseElementSet() {
        if (this.base != null && this.base instanceof XSDComplexType) {
            Vector vector = ((XSDComplexType)this.base).getTypeGroup().getNodeVector();
            Object[] objectArray = new XSDNode[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public XSDNode[] getAttributeSet() {
        int n = this.attrGroup.length();
        if (this.attrGroup.wildcard != null) {
            ++n;
        }
        XSDNode[] xSDNodeArray = new XSDNode[n];
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                xSDNodeArray[i] = new XSDElement((XSDAttribute)this.attrGroup.item(i));
            }
            xSDNodeArray[n - 1] = this.attrGroup.wildcard != null ? this.attrGroup.wildcard : new XSDElement((XSDAttribute)this.attrGroup.item(n - 1));
        }
        return xSDNodeArray;
    }

    public XSDAttribute[] getAttributeDeclarations() {
        int n = this.attrGroup.length();
        XSDAttribute[] xSDAttributeArray = new XSDAttribute[n];
        System.arraycopy(this.attrGroup.nodeVector, 0, xSDAttributeArray, 0, n);
        return xSDAttributeArray;
    }

    public XSDAny getAttributeWildcard() {
        return this.attrGroup.wildcard;
    }

    public XSDNode[] getBaseAttributeSet() {
        if (this.base == this) {
            return null;
        }
        if (this.base != null && this.base instanceof XSDComplexType) {
            return ((XSDComplexType)this.base).getAttributeSet();
        }
        return null;
    }

    public short getDerivationMethod() {
        if (this.derivedBy == "restriction") {
            return 2;
        }
        if (this.derivedBy == "extension") {
            return 1;
        }
        return 0;
    }

    public String getDerivedMethod() {
        return this.derivedBy;
    }

    public boolean isUrType() {
        return this == urType;
    }

    boolean isDerivedFrom(XSDNode xSDNode, BitSet bitSet) {
        boolean bl = false;
        boolean bl2 = false;
        XSDNode xSDNode2 = this;
        while (xSDNode2 != null) {
            XSDNode xSDNode3 = xSDNode2.isNodeType(1) ? ((XSDComplexType)xSDNode2).getBaseType() : ((XSDSimpleType)xSDNode2).getBase();
            if (xSDNode2 == xSDNode) {
                return !(bl && bitSet.get(2) || bl2 && bitSet.get(1));
            }
            if (this.derivedBy == "restriction") {
                bl = true;
            }
            if (this.derivedBy == "extension") {
                bl2 = true;
            }
            if (xSDNode3 == null || xSDNode2 == xSDNode3) break;
            xSDNode2 = xSDNode3;
            bitSet.or(xSDNode2.getProperties());
        }
        return false;
    }

    boolean isSubstitutableFor(XSDNode xSDNode, boolean bl, boolean bl2) {
        if (this == xSDNode) {
            return true;
        }
        if (bl && this.derivedBy == "restriction") {
            return false;
        }
        if (bl2 && this.derivedBy == "extension") {
            return false;
        }
        if (this.base == null || this == urType) {
            return false;
        }
        return this.base.isSubstitutableFor(xSDNode, bl, bl2);
    }

    String getBlockString() {
        if (this.properties.get(1)) {
            if (this.properties.get(2)) {
                return "#all";
            }
            return "extension";
        }
        if (this.properties.get(2)) {
            return "restriction";
        }
        return "";
    }

    String getFinalString() {
        if (this.properties.get(3)) {
            if (this.properties.get(4)) {
                return "extension restriction";
            }
            return "extension";
        }
        if (this.properties.get(4)) {
            return "restriction";
        }
        return "";
    }

    void print(int n) {
        String string;
        this.printSTag(n);
        if (this.isAbstract()) {
            System.out.println(XSDComplexType.indent(n) + "abstract = true");
        } else {
            System.out.println(XSDComplexType.indent(n) + "abstract = false");
        }
        switch (this.content) {
            case 12: {
                System.out.println(XSDComplexType.indent(n) + "content = " + "elementOnly");
                break;
            }
            case 13: {
                System.out.println(XSDComplexType.indent(n) + "content = " + "mixed");
                break;
            }
            case 10: {
                System.out.println(XSDComplexType.indent(n) + "content = " + "empty");
                break;
            }
            case 11: {
                System.out.println(XSDComplexType.indent(n) + "content = " + "textOnly");
                break;
            }
        }
        if (this.derivedBy != "#undef") {
            System.out.println(XSDComplexType.indent(n) + "derivedBy = " + this.derivedBy);
        }
        if (!(string = this.getBlockString()).equals("")) {
            System.out.println(XSDComplexType.indent(n) + "block =" + string);
        }
        if (!(string = this.getFinalString()).equals("")) {
            System.out.println(XSDComplexType.indent(n) + "final =" + string);
        }
        if (this.refLocalname != null) {
            System.out.print(XSDComplexType.indent(n) + "ref = " + this.refNamespace);
            System.out.println(":" + this.refLocalname);
        }
        this.printSTagEnd(n);
        if (this.attrGroup != null) {
            this.attrGroup.print(n + 3);
        }
        if (this.typeGroup != null) {
            this.typeGroup.print(n + 3);
        }
        if (this.simpleType != null) {
            this.simpleType.print(n + 3);
        }
        this.printETag(n);
    }

    static {
        try {
            urType = new XSDComplexType();
            urType.initTypeGroup(0);
            XSDComplexType.urType.targetNS = "http://www.w3.org/2001/XMLSchema";
            XSDAny xSDAny = new XSDAny();
            xSDAny.setMaxOccurs(0x7FFFFFF8);
            xSDAny.setMinOccurs(0);
            xSDAny.setProcessContents("lax");
            XSDComplexType.urType.typeGroup.addParticleNode(xSDAny);
            xSDAny = new XSDAny(7);
            XSDComplexType.urType.attrGroup.setWildcard(xSDAny);
            urType.setContent("mixed");
            BlockAll = new BitSet(8);
            FinalAll = new BitSet(8);
            BFNONE = new BitSet(8);
            BlockAll.set(0);
            BlockAll.set(1);
            BlockAll.set(2);
            FinalAll.set(3);
            FinalAll.set(4);
            FinalAll.set(5);
            FinalAll.set(6);
        }
        catch (XSDException xSDException) {
            // empty catch block
        }
    }
}

