/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import oracle.xml.jdwp.XSLJDWPClassMatchEventRequest;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPEventRequest;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPFieldOnlyEventRequest;
import oracle.xml.jdwp.XSLJDWPLocationOnlyEventRequest;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPStepEventRequest;

public class XSLJDWPEventRequestGroup
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    private byte eventKind;
    private byte suspendPolicy;
    private int modifiers = 0;
    private XSLJDWPEventRequest[] eventRequests;
    private int requestID;

    XSLJDWPEventRequestGroup() {
    }

    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.cmd.cmd) {
            case 1: {
                xSLJDWPPacket2 = this.setCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.clearCmd();
                break;
            }
            case 3: {
                xSLJDWPPacket2 = this.clearAllBreakpointsCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    XSLJDWPPacket setCmd() {
        try {
            this.eventKind = this.cmdStrm.readByte();
            this.suspendPolicy = this.cmdStrm.readByte();
            this.modifiers = this.cmdStrm.readInt();
            this.eventRequests = new XSLJDWPEventRequest[this.modifiers];
            block14: for (int i = 0; i < this.modifiers; ++i) {
                byte by = this.cmdStrm.readByte();
                switch (by) {
                    case 1: {
                        this.cmdStrm.readInt();
                        continue block14;
                    }
                    case 2: {
                        this.cmdStrm.readInt();
                        continue block14;
                    }
                    case 3: {
                        this.cmdStrm.readThreadID();
                        continue block14;
                    }
                    case 4: {
                        this.cmdStrm.readReferenceType();
                        continue block14;
                    }
                    case 5: {
                        this.eventRequests[i] = new XSLJDWPClassMatchEventRequest(this.cmdStrm.readString());
                        this.eventRequests[i].setModKind(by);
                        continue block14;
                    }
                    case 6: {
                        this.cmdStrm.readString();
                        continue block14;
                    }
                    case 7: {
                        this.eventRequests[i] = new XSLJDWPLocationOnlyEventRequest(this.cmdStrm.readLocation());
                        this.eventRequests[i].setModKind(by);
                        continue block14;
                    }
                    case 8: {
                        this.cmdStrm.readReferenceType();
                        this.cmdStrm.readBoolean();
                        this.cmdStrm.readBoolean();
                        continue block14;
                    }
                    case 9: {
                        this.eventRequests[i] = new XSLJDWPFieldOnlyEventRequest(this.cmdStrm.readReferenceType(), this.cmdStrm.readFieldID());
                        this.eventRequests[i].setModKind(by);
                        continue block14;
                    }
                    case 10: {
                        this.eventRequests[i] = new XSLJDWPStepEventRequest(this.cmdStrm.readThreadID(), this.cmdStrm.readInt(), this.cmdStrm.readInt());
                        this.eventRequests[i].setModKind(by);
                        continue block14;
                    }
                }
            }
            if (this.eventKind == 90 || this.eventKind == 99 || this.eventKind == 1 || this.eventKind == 2 || this.eventKind == 3 || this.eventKind == 20 || this.eventKind == 40 || this.eventKind == 41 || this.eventKind == 6 || this.eventKind == 7 || this.eventKind == 8) {
                this.jdwpvm.getEventRequestManager().add(this);
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        this.requestID = this.jdwpvm.getEventRequestManager().generateRequestID();
        xSLJDWPPacketStream.writeInt(this.requestID);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket clearCmd() {
        byte by = this.cmdStrm.readByte();
        int n = this.cmdStrm.readInt();
        this.jdwpvm.getEventRequestManager().clear(by, n);
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket clearAllBreakpointsCmd() {
        this.jdwpvm.getEventRequestManager().clearAllBreakpoints();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    public int getRequestID() {
        return this.requestID;
    }

    public byte getEventKind() {
        return this.eventKind;
    }

    public byte getSuspendPolicy() {
        return this.suspendPolicy;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public XSLJDWPEventRequest[] getXSLJDWPEventRequests() {
        return this.eventRequests;
    }
}

