/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import javax.xml.parsers.DocumentBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JXDocumentBuilder
extends DocumentBuilder {
    private DOMParser domParser = new DOMParser();
    private Connection domConn;
    private String domKind;

    JXDocumentBuilder() {
    }

    DOMParser getDOMParser() {
        return this.domParser;
    }

    public Document parse(InputStream inputStream) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        int n = inputStream.available();
        InputSource inputSource = new InputSource(inputStream);
        return this.parse(inputSource);
    }

    public Document parse(InputStream inputStream, String string) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        int n = inputStream.available();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.parse(inputSource);
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource is null");
        }
        this.domParser.parse(inputSource);
        return this.domParser.getDocument();
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return this.domParser.getValidationMode();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.domParser.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.domParser.setErrorHandler(errorHandler);
    }

    public Document newDocument() {
        if ("oracle.xml.parser.XMLDocument.THICK".equals(this.domKind)) {
            return new XMLDocument(this.domConn, 0L);
        }
        return new XMLDocument();
    }

    public DOMImplementation getDOMImplementation() {
        XMLDOMImplementation xMLDOMImplementation = new XMLDOMImplementation();
        if ("oracle.xml.parser.XMLDocument.THICK".equals(this.domKind)) {
            xMLDOMImplementation.setAttribute("oracle.xml.parser.XMLDocument.Connection", this.domConn);
            xMLDOMImplementation.setAttribute("oracle.xml.parser.XMLDocument.Kind", "oracle.xml.parser.XMLDocument.THICK");
        }
        return xMLDOMImplementation;
    }

    void setConnection(Connection connection) {
        this.domConn = connection;
    }

    void setDOMKind(String string) {
        this.domKind = string;
        if (string == null) {
            this.domKind = "oracle.xml.parser.XMLDocument.THIN";
        }
    }
}

