/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class ColorSpaceConvertor {
    private static ColorSpace rgbCS;
    private static ColorConvertOp CSToRGB;
    private static ColorConvertOp ccopWithHints;
    private static ColorModel rgbModel;
    public static boolean wasRemoved;
    public static boolean isUsingARGB;
    private static ICC_ColorSpace YCC;
    private static ICC_ColorSpace CMY;
    private static ColorSpace CMYK;

    private static void initCMYKColorspace() throws PdfException {
        try {
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(ColorSpaceConvertor.class.getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm"));
            ICC_Profile iCC_Profile2 = ICC_Profile.getInstance(1000);
            rgbCS = new ICC_ColorSpace(iCC_Profile2);
            rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            CSToRGB = new ColorConvertOp(new ICC_ColorSpace(iCC_Profile), rgbCS, ColorSpaces.hints);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " initialising color components");
            throw new PdfException("[PDF] Unable to create CMYK colorspace. Check cmyk.icm in jar file");
        }
    }

    public static BufferedImage convertFromICCCMYK(int n, int n2, byte[] byArray, ColorSpace colorSpace) {
        if (colorSpace == null) {
            colorSpace = rgbCS;
        }
        BufferedImage bufferedImage = null;
        try {
            Object object;
            int n3 = n * n2 * 4;
            if (byArray.length < n3) {
                object = new byte[n3];
                System.arraycopy(byArray, 0, object, 0, byArray.length);
                byArray = object;
            }
            object = new DataBufferByte(byArray, byArray.length);
            int[] nArray = new int[]{0, 1, 2, 3};
            WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object, n, n2, n * 4, 4, nArray, null);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8, 8}, false, false, 1, 0);
            bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception  " + exception + " converting from ICC colorspace");
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    public static BufferedImage convertFromICCCMYK(int n, int n2, DataBuffer dataBuffer, ColorSpace colorSpace) {
        BufferedImage bufferedImage = null;
        try {
            int[] nArray = new int[]{0, 1, 2, 3};
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBuffer, n, n2, n * 4, 4, nArray, null);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8, 8}, false, false, 1, 0);
            bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception  " + exception + " converting from ICC colorspace");
        }
        return bufferedImage;
    }

    public static byte[] convertIndexToRGB(byte[] byArray, ColorSpace colorSpace) {
        try {
            int n = byArray.length / 4;
            int n2 = 1;
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            int[] nArray = new int[]{0, 1, 2, 3};
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 4, 4, nArray, null);
            WritableRaster writableRaster2 = rgbModel.createCompatibleWritableRaster(n, n2);
            if (CSToRGB == null) {
                ColorSpaceConvertor.initCMYKColorspace();
            }
            CSToRGB.filter(writableRaster, writableRaster2);
            int n3 = n * n2 * 3;
            byArray = new byte[n3];
            DataBuffer dataBuffer = writableRaster2.getDataBuffer();
            for (int i = 0; i < n3; ++i) {
                byArray[i] = (byte)dataBuffer.getElem(i);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception  " + exception + " converting colorspace");
        }
        return byArray;
    }

    public static final BufferedImage convertToRGB(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 1) {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
                ccopWithHints.filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception.toString() + " removing alpha from JPEG image");
            }
        }
        return bufferedImage;
    }

    public static final BufferedImage convertToARGB(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 2) {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
                ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                colorConvertOp.filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " creating argb image");
            }
        }
        isUsingARGB = true;
        return bufferedImage;
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        byte[] byArray2 = new byte[n * n2 * 3];
        int n3 = n * n2 * 4;
        double d = -1.0;
        double d2 = -1.12;
        double d3 = -1.12;
        double d4 = -1.21;
        double d5 = 255.0;
        byArray2 = new byte[n * n2 * 3];
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n4 = 0;
        for (int i = 0; i < n3; i += 4) {
            double d9 = (double)(byArray[i] & 0xFF) / d5;
            double d10 = (double)(byArray[i + 1] & 0xFF) / d5;
            double d11 = (double)(byArray[i + 2] & 0xFF) / d5;
            double d12 = (double)(byArray[i + 3] & 0xFF) / d5;
            if (d != d9 || d2 != d10 || d3 != d11 || d4 != d12) {
                double d13 = 1.0;
                double d14 = ColorSpaceConvertor.clip01(d9 + d12);
                double d15 = ColorSpaceConvertor.clip01(d10 + d12);
                double d16 = ColorSpaceConvertor.clip01(d11 + d12);
                double d17 = (d13 - d14) * (d13 - d15) * (d13 - d16);
                double d18 = d14 * (d13 - d15) * (d13 - d16);
                double d19 = (d13 - d14) * d15 * (d13 - d16);
                double d20 = (d13 - d14) * (d13 - d15) * d16;
                double d21 = (d13 - d14) * d15 * d16;
                double d22 = d14 * (d13 - d15) * d16;
                double d23 = d14 * d15 * (d13 - d16);
                d6 = d5 * ColorSpaceConvertor.clip01(d17 + 0.9137 * d19 + 0.9961 * d20 + 0.9882 * d21);
                d7 = d5 * ColorSpaceConvertor.clip01(d17 + 0.6196 * d18 + d20 + 0.5176 * d22);
                d8 = d5 * ColorSpaceConvertor.clip01(d17 + 0.7804 * d18 + 0.5412 * d19 + 0.0667 * d21 + 0.2118 * d22 + 0.4863 * d23);
                d = d9;
                d2 = d10;
                d3 = d11;
                d4 = d12;
            }
            byArray2[n4++] = (byte)d6;
            byArray2[n4++] = (byte)d7;
            byArray2[n4++] = (byte)d8;
        }
        try {
            int[] nArray = new int[]{0, 1, 2};
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
        }
        return bufferedImage;
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(DataBuffer dataBuffer, int n, int n2, boolean bl) {
        wasRemoved = false;
        byte[] byArray = ((DataBufferByte)dataBuffer).getData();
        BufferedImage bufferedImage = null;
        byte[] byArray2 = new byte[n * n2 * 4];
        int n3 = n * n2 * 4;
        boolean bl2 = false;
        boolean bl3 = true;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = 0;
        for (int i = 0; i < n3; i += 4) {
            int n12 = byArray[i] & 0xFF;
            int n13 = (byArray[1 + i] & 0xFF) - 128;
            int n14 = (byArray[2 + i] & 0xFF) - 128;
            int n15 = byArray[3 + i] & 0xFF;
            int n16 = 255;
            if (n7 != n12 || n8 != n13 || n9 != n14 || n10 != n15) {
                if (bl) {
                    System.out.println(n12 + " " + n13 + ' ' + n14 + ' ' + n15);
                }
                if ((n4 = (int)((float)(n12 - n15) + 1.402f * (float)n14)) < 0) {
                    n4 = 0;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                if ((n5 = (int)((float)(n12 - n15) - 0.34414f * (float)n13 - 0.71414f * (float)n14)) < 0) {
                    n5 = 0;
                }
                if (n5 > 255) {
                    n5 = 255;
                }
                if ((n6 = (int)((float)(n12 - n15) + 1.772f * (float)n13)) < 0) {
                    n6 = 0;
                }
                if (n6 > 255) {
                    n6 = 255;
                }
                if (n12 != 255 || n14 != 0 || n13 != 0 || n15 != 255) {
                    bl3 = false;
                }
                if (n12 == 255 && n14 == n13 && n15 == 0 && n14 != 0) {
                    n4 = 255;
                    n5 = 255;
                    n6 = 255;
                    if (n15 == 255) {
                        n16 = 0;
                    } else {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
                if (bl) {
                    System.out.println(n4 + " " + n5 + ' ' + n6);
                }
                n7 = n12;
                n8 = n13;
                n9 = n14;
                n10 = n15;
            }
            byArray2[n11++] = (byte)n4;
            byArray2[n11++] = (byte)n5;
            byArray2[n11++] = (byte)n6;
            byArray2[n11++] = (byte)n16;
        }
        if (!bl2 || bl3) {
            wasRemoved = true;
            return null;
        }
        try {
            int[] nArray = new int[]{0, 1, 2, 3};
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            bufferedImage = new BufferedImage(n, n2, 2);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 4, 4, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
        }
        return bufferedImage;
    }

    public static BufferedImage iccConvertCMYKImageToRGB(byte[] byArray, int n, int n2, String string) throws IOException {
        Object object;
        Object object2;
        int n3;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            n3 = string5.indexOf("=");
            if (n3 == -1) {
                throw new RuntimeException("Wrong parameter in " + string + "\nPlease use comma-separated set of uses such as YCC=/desktop/ycc.pf,CMY=/desktop/cmy.pf");
            }
            String string6 = string5.substring(0, n3).trim();
            String string7 = string5.substring(n3 + 1).trim();
            if (string6.equals("YCC")) {
                string2 = string7;
                continue;
            }
            if (string6.equals("CMY")) {
                string3 = string7;
                continue;
            }
            if (string6.equals("CMYK")) {
                string4 = string7;
                continue;
            }
            throw new RuntimeException("Unknown parameter in " + string + "\nPlease use comma-separated set of uses such as YCC= CMY= or (optional value) CMYK=");
        }
        if (CMYK == null) {
            if (string4 == null) {
                CMYK = new DeviceCMYKColorSpace().getColorSpace();
            } else {
                try {
                    CMYK = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(string4)));
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to create CMYK colorspace with  " + string4 + "\nPlease check Path and file valid or use built-in");
                }
            }
            if (string2 == null) {
                throw new RuntimeException("Mandatory YCC value not supplied in " + string + "\nPlease add ,YCC=yourPath/yourYCCprofile.pf");
            }
            try {
                YCC = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(string2)));
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to create YCC colorspace with  " + string2 + "\nPlease check Path and file valid");
            }
            if (string3 == null) {
                throw new RuntimeException("Mandatory CMY value not supplied in " + string + "\nPlease add ,CMY=yourPath/yourCMYprofile.pf");
            }
            try {
                CMY = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(string3)));
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to create CMY colorspace with  " + string3 + "\nPlease check Path and file valid");
            }
            rgbCS = new ICC_ColorSpace(ICC_Profile.getInstance(1000));
            rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            CSToRGB = new ColorConvertOp(CMYK, rgbCS, ColorSpaces.hints);
        }
        int n4 = n * n2 * 4;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        float[] fArray = new float[3];
        int n9 = 0;
        HashMap<Object, float[]> hashMap = new HashMap<Object, float[]>();
        for (int i = 0; i < n4; i += 4) {
            n3 = byArray[i] & 0xFF;
            int n10 = byArray[i + 1] & 0xFF;
            int n11 = byArray[i + 2] & 0xFF;
            int n12 = byArray[i + 3] & 0xFF;
            if (n3 != n5 || n10 != n6 || n11 != n7 || n12 != n8) {
                object2 = new Integer(n3 + (n10 << 8) + (n11 << 16));
                object = hashMap.get(object2);
                if (object == null) {
                    float[] fArray2 = new float[]{(float)n3 / 255.0f, (float)n10 / 255.0f, (float)n11 / 255.0f};
                    float[] fArray3 = YCC.toCIEXYZ(fArray2);
                    fArray = CMY.fromCIEXYZ(fArray3);
                    if (n9 > 1000) {
                        n9 = 0;
                        hashMap.clear();
                    }
                    hashMap.put(object2, fArray);
                } else {
                    fArray = (float[])object;
                }
                n5 = n3;
                n6 = n10;
                n7 = n11;
                n8 = n12;
            }
            byArray[i] = (byte)(fArray[0] * 255.0f);
            byArray[i + 1] = (byte)(fArray[1] * 255.0f);
            byArray[i + 2] = (byte)(fArray[2] * 255.0f);
        }
        WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n * 4, 4, new int[]{0, 1, 2, 3}, null);
        object2 = rgbModel.createCompatibleWritableRaster(n, n2);
        CSToRGB.filter(writableRaster, (WritableRaster)object2);
        object = new BufferedImage(n, n2, 1);
        ((BufferedImage)object).setData((Raster)object2);
        return object;
    }

    public static final BufferedImage convertColorspace(BufferedImage bufferedImage, int n) {
        try {
            BufferedImage bufferedImage2 = bufferedImage;
            bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), n);
            ColorConvertOp colorConvertOp = new ColorConvertOp(null);
            colorConvertOp.filter(bufferedImage2, bufferedImage);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " converting image");
        }
        return bufferedImage;
    }

    private static double clip01(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    static {
        CSToRGB = null;
        ccopWithHints = new ColorConvertOp(ColorSpaces.hints);
        rgbModel = null;
        isUsingARGB = false;
        YCC = null;
        CMY = null;
        CMYK = null;
    }
}

