/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.InvalidAttributeValueException;
import oracle.xdb.RealInputStream;
import oracle.xdb.XMLType;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.spi.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XDBResource
extends XDBDocument
implements Resource {
    private static String RES_OWNERID = "OwnerID";
    private static String RES_CHARSET = "CharacterSet";
    private static String RES_CREATEDATE = "CreationDate";
    private static String RES_MODDATE = "ModificationDate";
    private static String RES_AUTHOR = "Author";
    private static String RES_DISPLAYNAME = "DisplayName";
    private static String RES_COMMENT = "Comment";
    private static String RES_LANGUAGE = "Language";
    private static String RES_CONTENTTYPE = "ContentType";
    private static String RES_VERSIONID = "VersionId";
    private static String RES_FLAGS = "Flags";
    private static String RES_SCHEMA_ELEMENT = "SchemaElement";
    private static String RES_LAST_MOD = "LastModifier";
    private static String RES_CREATOR = "Creator";
    private static String RES_OWNER = "Owner";
    private static String RES_ACL = "acl";
    private static final int NO_ERROR = 0;
    private static final int NOT_CONTAINER_ERROR = 1;
    private static final int NOT_FOUND_ERROR = 2;
    private static final int NOT_DONE = 3;
    private static final int INVALID_HANDLE = 4;
    private static final int ENTRY_EXISTS_ERROR = 5;
    private static final int OTHER_ERROR = 6;
    private static final int INV_RESHDL_OR_PATH_ERR = 31001;
    private static final int NOT_CONT_ERR = 31002;
    private static final int ENTRY_EXISTS_ERR = 31003;
    private static final int DBBLKSIZE_TOO_SMALL_ERR = 31004;
    private static final int PATHNAME_TOO_LONG_ERR = 31005;
    private static final int PATH_SEGMENT_TOO_LONG_ERR = 31006;
    private static final int DEL_NONEMPTY_CONT_ERR = 31007;
    private static final int XDB_SPI_UNBIND_CONTEXT_ERR = 1;
    private static final int XDB_SPI_ENUM_EMPTY_ERR = 3;
    protected Element m_resElem;
    protected String m_path;
    private static int RES_FLAGS_CONTAINER = 8;
    private static int CONTENT_XML = 1;
    private static int CONTENT_BINARY = 2;

    public XDBResource(Connection conn, String abspath, long xobd) {
        super(conn, xobd);
        this.m_resElem = this.getDocumentElement();
        this.m_path = abspath;
    }

    public XDBResource(XMLType resxmlt, Connection conn, String abspath) {
        super(resxmlt, conn, 0L);
        this.m_path = abspath;
    }

    public static native void freeServerCtx(long var0);

    public String getACL() {
        if (this.m_resElem instanceof XDBElement) {
            return this.getACLNative(((XDBElement)this.m_resElem).toCState());
        }
        return null;
    }

    private native String getACLNative(long var1);

    public String getAuthor() {
        return this.getProperty(RES_AUTHOR);
    }

    public String getCharacterSet() {
        return this.getProperty(RES_CHARSET);
    }

    public String getComment() {
        return this.getProperty(RES_COMMENT);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getContentBinary() {
        long strm_c_state = 0L;
        try {
            int conntype = XMLType.getConnType(this.m_conn);
            switch (conntype) {
                case 2: {
                    strm_c_state = this.getContentKprb(((XDBElement)this.m_resElem).toCState(), CONTENT_BINARY);
                    if (strm_c_state != 0L) return new RealInputStream(0L, strm_c_state, 2, XDBDocument.getGP(this.m_conn));
                    return null;
                }
                case 1: {
                    strm_c_state = this.getContentThick(XMLType.getServiceHandle(this.m_conn, conntype), XMLType.getErrorHandle(this.m_conn, conntype), this.m_path, CONTENT_BINARY);
                    if (strm_c_state != 0L) return new RealInputStream(0L, strm_c_state, 2, XDBDocument.getGP(this.m_conn));
                    return null;
                }
                case 0: {
                    return null;
                }
                default: {
                    return new RealInputStream(0L, strm_c_state, 2, XDBDocument.getGP(this.m_conn));
                }
            }
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private native long getContentKprb(long var1, int var3);

    private native long getContentThick(long var1, long var3, String var5, int var6);

    public String getContentType() {
        return this.getProperty(RES_CONTENTTYPE);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document getContentXML() {
        long cstate = 0L;
        try {
            int conntype = XMLType.getConnType(this.m_conn);
            switch (conntype) {
                case 2: {
                    cstate = this.getContentKprb(((XDBElement)this.m_resElem).toCState(), CONTENT_XML);
                    if (cstate != 0L) return new XDBDocument(this.m_conn, cstate);
                    return null;
                }
                case 1: {
                    cstate = this.getContentThick(XMLType.getServiceHandle(this.m_conn, conntype), XMLType.getErrorHandle(this.m_conn, conntype), this.m_path, CONTENT_XML);
                    if (cstate != 0L) return new XDBDocument(this.m_conn, cstate);
                    return null;
                }
                case 0: {
                    return null;
                }
                default: {
                    return new XDBDocument(this.m_conn, cstate);
                }
            }
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public Timestamp getCreationDate() {
        String credat = this.getProperty(RES_CREATEDATE);
        return Timestamp.valueOf(credat.replace('T', ' '));
    }

    public String getCreator() {
        return this.getProperty(RES_CREATOR);
    }

    public String getDisplayName() {
        return this.getProperty(RES_DISPLAYNAME);
    }

    public String getLanguage() {
        return this.getProperty(RES_LANGUAGE);
    }

    public String getLastModifier() {
        return this.getProperty(RES_LAST_MOD);
    }

    public Timestamp getModificationDate() {
        String moddat = this.getProperty(RES_MODDATE);
        return Timestamp.valueOf(moddat.replace('T', ' '));
    }

    public String getOwner() {
        return this.getProperty(RES_OWNER);
    }

    public long getOwnerId() {
        long l;
        String s = this.getProperty(RES_OWNERID);
        try {
            l = Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        return l;
    }

    private String getProperty(String propname) {
        NodeList nl = this.m_resElem.getElementsByTagName(propname);
        if (nl == null) {
            return null;
        }
        Node n = nl.item(0);
        if (n == null) {
            return null;
        }
        if ((n = n.getFirstChild()) == null) {
            return null;
        }
        return n.getNodeValue();
    }

    public String getSchemaElement() {
        return this.getProperty(RES_SCHEMA_ELEMENT);
    }

    public static native long getServerCtx();

    public static native long getServerEnv();

    public int getSize() {
        if (this.m_resElem instanceof XDBElement) {
            return this.getSizeNative(((XDBElement)this.m_resElem).toCState());
        }
        return 0;
    }

    private native int getSizeNative(long var1);

    public int getVersionId() {
        int i;
        String s = this.getProperty(RES_OWNERID);
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            i = 0;
        }
        return i;
    }

    public boolean isFolder() {
        long flags;
        try {
            flags = Long.parseLong(this.getProperty(RES_FLAGS));
        }
        catch (NumberFormatException numberFormatException) {
            flags = 0L;
        }
        return (flags & (long)RES_FLAGS_CONTAINER) == (long)RES_FLAGS_CONTAINER;
    }

    public void save() {
        if (this.m_resElem instanceof XDBElement) {
            this.saveNative(((XDBElement)this.m_resElem).toCState());
        }
    }

    private native void saveNative(long var1);

    public void setACL(String aclpath) throws InvalidAttributeValueException {
        if (!(this.m_resElem instanceof XDBElement)) {
            throw new InvalidAttributeValueException();
        }
        this.setACLNative(((XDBElement)this.m_resElem).toCState(), aclpath, true);
    }

    private native long setACLNative(long var1, String var3, boolean var4);

    public void setAuthor(String authname) throws InvalidAttributeValueException {
        this.setProperty(RES_AUTHOR, authname);
    }

    public void setCharacterSet(String charSet) throws InvalidAttributeValueException {
        this.setProperty(RES_CHARSET, charSet);
    }

    public void setComment(String davcom) throws InvalidAttributeValueException {
        this.setProperty(RES_COMMENT, davcom);
    }

    public void setContent(Object xmlobj) throws InvalidAttributeValueException, OperationNotSupportedException {
    }

    public void setContentType(String conttype) throws InvalidAttributeValueException {
        this.setProperty(RES_CONTENTTYPE, conttype);
    }

    public void setCreationDate(Timestamp credate) throws InvalidAttributeValueException {
        this.setProperty(RES_CREATEDATE, credate.toString().replace(' ', 'T'));
    }

    public void setCreator(String creator) throws InvalidAttributeValueException {
        this.setProperty(RES_CREATOR, creator);
    }

    public void setDisplayName(String dname) throws InvalidAttributeValueException {
        this.setProperty(RES_DISPLAYNAME, dname);
    }

    public void setLanguage(String lang) throws InvalidAttributeValueException {
        this.setProperty(RES_LANGUAGE, lang);
    }

    public void setLastModifier(String modifier) throws InvalidAttributeValueException {
        this.setProperty(RES_LAST_MOD, modifier);
    }

    public void setModificationDate(Timestamp moddate) throws InvalidAttributeValueException {
        this.setProperty(RES_MODDATE, moddate.toString().replace(' ', 'T'));
    }

    public void setOwner(String owner) throws InvalidAttributeValueException {
        this.setProperty(RES_OWNER, owner);
    }

    public void setOwnerId(long ownerid) throws InvalidAttributeValueException {
        this.setProperty(RES_OWNERID, String.valueOf(ownerid));
    }

    private void setProperty(String propname, String value) {
        Node n;
        NodeList nl = this.m_resElem.getElementsByTagName(propname);
        if (nl != null && (n = nl.item(0)) != null) {
            if ((n = n.getFirstChild()) != null) {
                n.setNodeValue(value);
                return;
            }
            try {
                Text tnode = this.createTextNode(value);
                n.appendChild(tnode);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Element e = this.createElementNS("http://xmlns.oracle.com/xdb/XDBResource.xsd", propname);
            Text tnode = this.createTextNode(value);
            e.appendChild(tnode);
            this.m_resElem.appendChild(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSchemaElement(String schema) throws InvalidAttributeValueException {
        this.setProperty(RES_SCHEMA_ELEMENT, schema);
    }

    public void setVersionId(int versionId) throws InvalidAttributeValueException {
        this.setProperty(RES_VERSIONID, String.valueOf(versionId));
    }
}

