/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.graphics.ExtGState;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.PatternColor;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.TextSprite;
import org.icepdf.core.pobjects.graphics.TextState;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentParser {
    private static final Logger logger = Logger.getLogger(ContentParser.class.toString());
    public static final float OVERPAINT_ALPHA = 0.4f;
    private GraphicsState graphicState;
    private Library library;
    private Resources resources;
    private boolean inTextBlock;
    private int textBlockIndex = 0;
    private AffineTransform textBlockBase;

    public ContentParser(Library library, Resources resources) {
        this.library = library;
        this.resources = resources;
    }

    public GraphicsState getGraphicsState() {
        return this.graphicState;
    }

    public void setGraphicsState(GraphicsState graphicsState) {
        this.graphicState = graphicsState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shapes parse(InputStream inputStream) throws InterruptedException {
        InputStream[] inputStreamArray;
        Object object;
        Shapes shapes = new Shapes();
        if (this.graphicState == null) {
            this.graphicState = new GraphicsState(shapes);
        } else {
            this.graphicState.setCTM(new AffineTransform());
            this.graphicState.setClip(null);
            ContentParser.setStroke(shapes, this.graphicState);
            this.graphicState.setShapes(shapes);
        }
        if (logger.isLoggable(Level.FINER)) {
            if (inputStream instanceof SeekableInput) {
                object = Utils.getContentFromSeekableInput((SeekableInput)((Object)inputStream), false);
            } else {
                inputStreamArray = new InputStream[]{inputStream};
                object = Utils.getContentAndReplaceInputStream(inputStreamArray, false);
                inputStream = inputStreamArray[0];
            }
            logger.finer("Content = " + (String)object);
        }
        object = new Parser(inputStream);
        inputStreamArray = new Stack();
        try {
            try {
                GeneralPath generalPath = null;
                while (true) {
                    float f;
                    float f2;
                    float f3;
                    if (Thread.interrupted()) {
                        throw new InterruptedException("ContentParser thread interrupted");
                    }
                    Object object2 = ((Parser)object).getStreamObject();
                    if (!(object2 instanceof String)) {
                        inputStreamArray.push(object2);
                        continue;
                    }
                    if (object2.equals("l")) {
                        float f4 = ((Number)inputStreamArray.pop()).floatValue();
                        float f5 = ((Number)inputStreamArray.pop()).floatValue();
                        generalPath.lineTo(f5, f4);
                        continue;
                    }
                    if (object2.equals("m")) {
                        if (generalPath == null) {
                            generalPath = new GeneralPath();
                        }
                        float f6 = ((Number)inputStreamArray.pop()).floatValue();
                        float f7 = ((Number)inputStreamArray.pop()).floatValue();
                        generalPath.moveTo(f7, f6);
                        continue;
                    }
                    if (object2.equals("c")) {
                        float f8 = ((Number)inputStreamArray.pop()).floatValue();
                        float f9 = ((Number)inputStreamArray.pop()).floatValue();
                        float f10 = ((Number)inputStreamArray.pop()).floatValue();
                        f3 = ((Number)inputStreamArray.pop()).floatValue();
                        f2 = ((Number)inputStreamArray.pop()).floatValue();
                        f = ((Number)inputStreamArray.pop()).floatValue();
                        generalPath.curveTo(f, f2, f3, f10, f9, f8);
                        continue;
                    }
                    if (object2.equals("S")) {
                        if (generalPath == null) continue;
                        this.commonStroke(shapes, generalPath);
                        generalPath = null;
                        continue;
                    }
                    if (object2.equals("Tf")) {
                        ContentParser.consume_Tf(this.graphicState, (Stack)inputStreamArray, this.resources);
                        continue;
                    }
                    if (object2.equals("BT")) {
                        this.setAlpha(shapes, 1.0f);
                        this.parseText((Parser)object, shapes, false, null);
                        continue;
                    }
                    if (object2.equals("F") || object2.equals("f")) {
                        if (generalPath != null) {
                            generalPath.setWindingRule(1);
                            this.commonFill(shapes, generalPath);
                        }
                        generalPath = null;
                        continue;
                    }
                    if (object2.equals("q")) {
                        this.graphicState = ContentParser.consume_q(this.graphicState);
                        continue;
                    }
                    if (object2.equals("Q")) {
                        this.graphicState = ContentParser.consume_Q(this.graphicState, shapes);
                        continue;
                    }
                    if (object2.equals("re")) {
                        if (generalPath == null) {
                            generalPath = new GeneralPath();
                        }
                        float f11 = ((Number)inputStreamArray.pop()).floatValue();
                        float f12 = ((Number)inputStreamArray.pop()).floatValue();
                        float f13 = ((Number)inputStreamArray.pop()).floatValue();
                        f3 = ((Number)inputStreamArray.pop()).floatValue();
                        generalPath.moveTo(f3, f13);
                        generalPath.lineTo(f3 + f12, f13);
                        generalPath.lineTo(f3 + f12, f13 + f11);
                        generalPath.lineTo(f3, f13 + f11);
                        generalPath.lineTo(f3, f13);
                        continue;
                    }
                    if (object2.equals("cm")) {
                        ContentParser.consume_cm(this.graphicState, (Stack)inputStreamArray, this.inTextBlock, this.textBlockBase);
                        continue;
                    }
                    if (object2.equals("h")) {
                        if (generalPath == null) continue;
                        generalPath.closePath();
                        continue;
                    }
                    if (object2.equals("BDC")) {
                        inputStreamArray.pop();
                        inputStreamArray.pop();
                        continue;
                    }
                    if (object2.equals("EMC")) continue;
                    if (object2.equals("Do")) {
                        Object object3;
                        String string = ((Name)inputStreamArray.pop()).getName();
                        if (this.resources.isForm(string)) {
                            this.graphicState = this.graphicState.save();
                            object3 = this.resources.getForm(string);
                            if (object3 != null) {
                                ((Form)object3).setGraphicsState(new GraphicsState(this.graphicState));
                                ((Form)object3).setParentResources(this.resources);
                                ((Form)object3).init();
                                AffineTransform affineTransform = new AffineTransform(this.graphicState.getCTM());
                                affineTransform.concatenate(((Form)object3).getMatrix());
                                shapes.add(affineTransform);
                                if (this.graphicState.getClip() != null) {
                                    shapes.add(((Form)object3).getBBox().createIntersection(this.graphicState.getClip().getBounds2D()));
                                } else {
                                    shapes.add(((Form)object3).getBBox());
                                }
                                shapes.addClipCommand();
                                shapes.add(((Form)object3).getShapes());
                                if (((Form)object3).getShapes() != null) {
                                    shapes.add(((Form)object3).getShapes().getImages());
                                }
                                shapes.addNoClipCommand();
                            }
                            this.graphicState = this.graphicState.restore();
                            continue;
                        }
                        object3 = this.resources.getImage(string, this.graphicState.getFillColor());
                        if (object3 == null) continue;
                        AffineTransform affineTransform = new AffineTransform(this.graphicState.getCTM());
                        this.graphicState.scale(1.0, -1.0);
                        this.graphicState.translate(0.0, -1.0);
                        shapes.add(object3);
                        this.graphicState.set(affineTransform);
                        continue;
                    }
                    if (object2.equals("f*")) {
                        if (generalPath != null) {
                            generalPath.setWindingRule(0);
                            this.commonFill(shapes, generalPath);
                        }
                        generalPath = null;
                        continue;
                    }
                    if (object2.equals("gs")) {
                        ContentParser.consume_gs(this.graphicState, (Stack)inputStreamArray, this.resources);
                        continue;
                    }
                    if (object2.equals("n")) {
                        generalPath = null;
                        continue;
                    }
                    if (object2.equals("w") || object2.equals("LW")) {
                        ContentParser.consume_w(this.graphicState, (Stack)inputStreamArray, shapes);
                        continue;
                    }
                    if (object2.equals("W")) {
                        if (generalPath == null) continue;
                        generalPath.setWindingRule(1);
                        generalPath.closePath();
                        this.graphicState.setClip(generalPath);
                        continue;
                    }
                    if (object2.equals("sc") || object2.equals("scn")) {
                        ContentParser.consume_sc(this.graphicState, (Stack)inputStreamArray, this.library, this.resources);
                        continue;
                    }
                    if (object2.equals("b")) {
                        if (generalPath != null) {
                            generalPath.setWindingRule(1);
                            generalPath.closePath();
                            this.commonStroke(shapes, generalPath);
                            this.commonFill(shapes, generalPath);
                        }
                        generalPath = null;
                        continue;
                    }
                    if (object2.equals("k")) {
                        ContentParser.consume_k(this.graphicState, (Stack)inputStreamArray, this.library, this.resources);
                        continue;
                    }
                    if (object2.equals("g")) {
                        ContentParser.consume_g(this.graphicState, (Stack)inputStreamArray, this.library, this.resources);
                        continue;
                    }
                    if (object2.equals("i")) {
                        ContentParser.consume_i((Stack)inputStreamArray);
                        continue;
                    }
                    if (object2.equals("M")) {
                        ContentParser.consume_M(this.graphicState, (Stack)inputStreamArray, shapes);
                        continue;
                    }
                    if (object2.equals("J")) {
                        ContentParser.consume_J(this.graphicState, (Stack)inputStreamArray, shapes);
                        continue;
                    }
                    if (object2.equals("rg")) {
                        ContentParser.consume_rg(this.graphicState, (Stack)inputStreamArray, this.library, this.resources);
                        continue;
                    }
                    if (object2.equals("d")) {
                        ContentParser.consume_d(this.graphicState, (Stack)inputStreamArray, shapes);
                        continue;
                    }
                    if (object2.equals("v")) {
                        float f14 = ((Number)inputStreamArray.pop()).floatValue();
                        float f15 = ((Number)inputStreamArray.pop()).floatValue();
                        float f16 = ((Number)inputStreamArray.pop()).floatValue();
                        f3 = ((Number)inputStreamArray.pop()).floatValue();
                        generalPath.curveTo((float)generalPath.getCurrentPoint().getX(), (float)generalPath.getCurrentPoint().getY(), f3, f16, f15, f14);
                        continue;
                    }
                    if (object2.equals("j")) {
                        ContentParser.consume_j(this.graphicState, (Stack)inputStreamArray, shapes);
                        continue;
                    }
                    if (object2.equals("y")) {
                        float f17 = ((Number)inputStreamArray.pop()).floatValue();
                        float f18 = ((Number)inputStreamArray.pop()).floatValue();
                        float f19 = ((Number)inputStreamArray.pop()).floatValue();
                        f3 = ((Number)inputStreamArray.pop()).floatValue();
                        generalPath.curveTo(f3, f19, f18, f17, f18, f17);
                        continue;
                    }
                    if (object2.equals("cs")) {
                        ContentParser.consume_cs(this.graphicState, (Stack)inputStreamArray, this.resources);
                        continue;
                    }
                    if (object2.equals("ri")) {
                        inputStreamArray.pop();
                        continue;
                    }
                    if (object2.equals("SC") || object2.equals("SCN")) {
                        ContentParser.consume_SC(this.graphicState, (Stack)inputStreamArray, this.library, this.resources);
                        continue;
                    }
                    if (object2.equals("B")) {
                        if (generalPath != null) {
                            generalPath.setWindingRule(1);
                            this.commonStroke(shapes, generalPath);
                            this.commonFill(shapes, generalPath);
                        }
                        generalPath = null;
                        continue;
                    }
                    if (object2.equals("K")) {
                        ContentParser.consume_K(this.graphicState, (Stack)inputStreamArray, this.library, this.resources);
                        continue;
                    }
                    if (object2.equals("d0")) {
                        this.graphicState = this.graphicState.save();
                        float f20 = ((Number)inputStreamArray.pop()).floatValue();
                        float f21 = ((Number)inputStreamArray.pop()).floatValue();
                        TextState textState = this.graphicState.getTextState();
                        textState.setType3HorizontalDisplacement(new Point2D.Float(f21, f20));
                        continue;
                    }
                    if (object2.equals("s")) {
                        if (generalPath == null) continue;
                        generalPath.closePath();
                        this.commonStroke(shapes, generalPath);
                        generalPath = null;
                        continue;
                    }
                    if (object2.equals("G")) {
                        ContentParser.consume_G(this.graphicState, (Stack)inputStreamArray, this.library, this.resources);
                        continue;
                    }
                    if (object2.equals("b*")) {
                        if (generalPath != null) {
                            generalPath.setWindingRule(0);
                            generalPath.closePath();
                            this.commonStroke(shapes, generalPath);
                            this.commonFill(shapes, generalPath);
                        }
                        generalPath = null;
                        continue;
                    }
                    if (object2.equals("RG")) {
                        ContentParser.consume_RG(this.graphicState, (Stack)inputStreamArray, this.library, this.resources);
                        continue;
                    }
                    if (object2.equals("CS")) {
                        ContentParser.consume_CS(this.graphicState, (Stack)inputStreamArray, this.resources);
                        continue;
                    }
                    if (object2.equals("d1")) {
                        this.graphicState = this.graphicState.save();
                        float f22 = ((Number)inputStreamArray.pop()).floatValue();
                        float f23 = ((Number)inputStreamArray.pop()).floatValue();
                        float f24 = ((Number)inputStreamArray.pop()).floatValue();
                        f3 = ((Number)inputStreamArray.pop()).floatValue();
                        f2 = ((Number)inputStreamArray.pop()).floatValue();
                        f = ((Number)inputStreamArray.pop()).floatValue();
                        TextState textState = this.graphicState.getTextState();
                        textState.setType3HorizontalDisplacement(new Point2D.Float(f, f2));
                        textState.setType3BBox(new PRectangle(new Point2D.Float(f24, f3), new Point2D.Float(f22, f23)));
                        continue;
                    }
                    if (object2.equals("B*")) {
                        if (generalPath != null) {
                            generalPath.setWindingRule(0);
                            this.commonStroke(shapes, generalPath);
                            this.commonFill(shapes, generalPath);
                        }
                        generalPath = null;
                        continue;
                    }
                    if (object2.equals("BMC")) {
                        inputStreamArray.pop();
                        continue;
                    }
                    if (object2.equals("BI")) {
                        this.parseInlineImage((Parser)object, shapes);
                        continue;
                    }
                    if (object2.equals("BX") || object2.equals("EX")) continue;
                    if (object2.equals("W*")) {
                        if (generalPath == null) continue;
                        generalPath.setWindingRule(0);
                        generalPath.closePath();
                        this.graphicState.setClip(generalPath);
                        continue;
                    }
                    if (object2.equals("DP")) {
                        inputStreamArray.pop();
                        inputStreamArray.pop();
                        continue;
                    }
                    if (object2.equals("MP")) {
                        inputStreamArray.pop();
                        continue;
                    }
                    if (object2.equals("sh")) {
                        Name name;
                        ShadingPattern shadingPattern;
                        Object e = inputStreamArray.peek();
                        if (!(e instanceof Name) || (shadingPattern = this.resources.getShading((name = (Name)inputStreamArray.pop()).toString())) == null) continue;
                        shadingPattern.init();
                        this.setAlpha(shapes, this.graphicState.getFillAlpha());
                        shapes.add(shadingPattern.getPaint());
                        shapes.add(this.graphicState.getClip());
                        shapes.addFillCommand();
                        continue;
                    }
                    if (object2.equals("Tc")) {
                        ContentParser.consume_Tc(this.graphicState, (Stack)inputStreamArray);
                        continue;
                    }
                    if (object2.equals("Tw")) {
                        ContentParser.consume_Tw(this.graphicState, (Stack)inputStreamArray);
                        continue;
                    }
                    if (object2.equals("TL")) {
                        ContentParser.consume_TL(this.graphicState, (Stack)inputStreamArray);
                        continue;
                    }
                    if (object2.equals("Tr")) {
                        ContentParser.consume_Tr(this.graphicState, (Stack)inputStreamArray);
                        continue;
                    }
                    if (object2.equals("Tz")) {
                        ContentParser.consume_Tz(this.graphicState, (Stack)inputStreamArray);
                        continue;
                    }
                    if (!object2.equals("Ts")) continue;
                    ContentParser.consume_Ts(this.graphicState, (Stack)inputStreamArray);
                }
            }
            catch (IOException iOException) {
                logger.finer("End of Content Stream");
                this.setAlpha(shapes, 1.0f);
            }
        }
        catch (Throwable throwable) {
            this.setAlpha(shapes, 1.0f);
            throw throwable;
        }
        while (!inputStreamArray.isEmpty()) {
            String string = inputStreamArray.pop().toString();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("STACK=" + string);
        }
        return shapes;
    }

    public Vector<StringBuffer> parseTextBlocks(InputStream inputStream) {
        Vector<StringBuffer> vector = new Vector<StringBuffer>(15);
        Parser parser = new Parser(inputStream);
        Shapes shapes = new Shapes();
        if (this.graphicState == null) {
            this.graphicState = new GraphicsState(shapes);
        }
        try {
            Object object = parser.getStreamObject();
            Stack<Object> stack = new Stack<Object>();
            while (object != null) {
                if (object instanceof String) {
                    if (object.equals("BT")) {
                        this.parseText(parser, shapes, true, vector);
                        ++this.textBlockIndex;
                        stack.clear();
                    } else if (object.equals("Tf")) {
                        ContentParser.consume_Tf(this.graphicState, stack, this.resources);
                        stack.clear();
                    }
                } else {
                    stack.push(object);
                }
                object = parser.getStreamObject();
            }
            stack.clear();
        }
        catch (IOException iOException) {
            logger.finer("End of Content Stream");
        }
        shapes.dispose();
        return vector;
    }

    public final void addExtractedText(Vector<StringBuffer> vector, StringBuffer stringBuffer) {
        if (vector.isEmpty()) {
            vector.add(stringBuffer);
        } else if (this.textBlockIndex < vector.size()) {
            StringBuffer stringBuffer2 = vector.elementAt(this.textBlockIndex);
            stringBuffer2.append(stringBuffer.toString());
            vector.setElementAt(stringBuffer2, this.textBlockIndex);
        } else {
            vector.add(stringBuffer);
        }
    }

    void parseText(Parser parser, Shapes shapes, boolean bl, Vector<StringBuffer> vector) throws IOException {
        Stack<Object> stack = new Stack<Object>();
        this.inTextBlock = true;
        float f = 0.0f;
        float f2 = 0.0f;
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        this.textBlockBase = new AffineTransform(this.graphicState.getCTM());
        this.graphicState.getTextState().tmatrix = new AffineTransform();
        this.graphicState.getTextState().tlmatrix = new AffineTransform();
        this.graphicState.scale(1.0, -1.0);
        Object object = parser.getStreamObject();
        while (!object.equals("ET")) {
            if (object instanceof String) {
                Object object2;
                float f3;
                Object object3;
                Object object4;
                Object object5;
                if (object.equals("Tj")) {
                    Object e = stack.pop();
                    if (e instanceof StringObject) {
                        object5 = (StringObject)e;
                        object4 = this.graphicState.getTextState();
                        ContentParser.applyTextScaling(this.graphicState);
                        object3 = (Point2D.Float)this.drawString(object5.getLiteralStringBuffer(((TextState)object4).font.getSubTypeFormat(), ((TextState)object4).font.getFont()), float_, f2, 0.0f, this.graphicState.getTextState(), shapes, bl, vector);
                        this.graphicState.translate(((Point2D.Float)object3).x, 0.0);
                        f += ((Point2D.Float)object3).x;
                        f2 = 0.0f;
                        float_.setLocation(0.0f, 0.0f);
                    }
                    if (bl) {
                        this.addExtractedText(vector, new StringBuffer(" "));
                    }
                } else if (object.equals("Tc")) {
                    this.graphicState.getTextState().cspace = ((Number)stack.pop()).floatValue();
                } else if (object.equals("Tw")) {
                    this.graphicState.getTextState().wspace = ((Number)stack.pop()).floatValue();
                } else if (object.equals("Td")) {
                    float f4 = ((Number)stack.pop()).floatValue();
                    float f5 = ((Number)stack.pop()).floatValue();
                    this.graphicState.translate(-f, 0.0);
                    f = 0.0f;
                    f2 = 0.0f;
                    float_.setLocation(0.0f, 0.0f);
                    this.graphicState.translate(f5, -f4);
                    if (bl) {
                        this.addExtractedText(vector, new StringBuffer("\n"));
                    }
                } else if (object.equals("Tm")) {
                    f = 0.0f;
                    f2 = 0.0f;
                    float_.setLocation(0.0f, 0.0f);
                    float f6 = ((Number)stack.pop()).floatValue();
                    float f7 = ((Number)stack.pop()).floatValue();
                    float f8 = ((Number)stack.pop()).floatValue();
                    float f9 = ((Number)stack.pop()).floatValue();
                    float f10 = ((Number)stack.pop()).floatValue();
                    f3 = ((Number)stack.pop()).floatValue();
                    object2 = new AffineTransform(this.textBlockBase);
                    this.graphicState.getTextState().tmatrix = new AffineTransform(f3, f10, f9, f8, f7, f6);
                    ((AffineTransform)object2).concatenate(this.graphicState.getTextState().tmatrix);
                    this.graphicState.set((AffineTransform)object2);
                    this.graphicState.scale(1.0, -1.0);
                } else if (object.equals("Tf")) {
                    ContentParser.consume_Tf(this.graphicState, stack, this.resources);
                } else if (object.equals("TJ")) {
                    ContentParser.applyTextScaling(this.graphicState);
                    Vector vector2 = (Vector)stack.pop();
                    f3 = f2;
                    object2 = vector2.elements();
                    while (object2.hasMoreElements()) {
                        object5 = object2.nextElement();
                        if (object5 instanceof StringObject) {
                            object4 = object5;
                            object3 = this.graphicState.getTextState();
                            float_ = (Point2D.Float)this.drawString(object4.getLiteralStringBuffer(((TextState)object3).font.getSubTypeFormat(), ((TextState)object3).font.getFont()), float_, f2, f3, this.graphicState.getTextState(), shapes, bl, vector);
                            f3 = float_.x;
                        } else if (object5 instanceof Number) {
                            float f11;
                            Number number = (Number)object5;
                            float_.x = (float)((double)float_.x - (double)(number.floatValue() * this.graphicState.getTextState().currentfont.getSize()) / 1000.0);
                            if (bl && (double)(f11 = float_.x - f3) > 0.01) {
                                this.addExtractedText(vector, new StringBuffer(" "));
                            }
                        }
                        f2 = float_.x;
                    }
                    if (bl) {
                        this.addExtractedText(vector, new StringBuffer(" "));
                    }
                } else if (object.equals("TD")) {
                    float f12 = ((Number)stack.pop()).floatValue();
                    float f13 = ((Number)stack.pop()).floatValue();
                    this.graphicState.translate(-f, 0.0);
                    f = 0.0f;
                    f2 = 0.0f;
                    float_.setLocation(0.0f, 0.0f);
                    this.graphicState.translate(f13, -f12);
                    this.graphicState.getTextState().leading = -f12;
                    if (bl) {
                        this.addExtractedText(vector, new StringBuffer("\n"));
                    }
                } else if (object.equals("TL")) {
                    this.graphicState.getTextState().leading = ((Number)stack.pop()).floatValue();
                } else if (object.equals("q")) {
                    this.graphicState = ContentParser.consume_q(this.graphicState);
                } else if (object.equals("Q")) {
                    this.graphicState = ContentParser.consume_Q(this.graphicState, shapes);
                } else if (object.equals("cm")) {
                    ContentParser.consume_cm(this.graphicState, stack, this.inTextBlock, this.textBlockBase);
                } else if (object.equals("T*")) {
                    this.graphicState.translate(-f, 0.0);
                    f = 0.0f;
                    f2 = 0.0f;
                    float_.setLocation(0.0f, 0.0f);
                    this.graphicState.translate(0.0, this.graphicState.getTextState().leading);
                    if (bl) {
                        this.addExtractedText(vector, new StringBuffer("\n"));
                    }
                } else if (object.equals("BDC")) {
                    stack.pop();
                    stack.pop();
                } else if (!object.equals("EMC")) {
                    if (object.equals("gs")) {
                        ContentParser.consume_gs(this.graphicState, stack, this.resources);
                    } else if (object.equals("w") || object.equals("LW")) {
                        ContentParser.consume_w(this.graphicState, stack, shapes);
                    } else if (object.equals("sc") || object.equals("scn")) {
                        ContentParser.consume_sc(this.graphicState, stack, this.library, this.resources);
                    } else if (object.equals("k")) {
                        ContentParser.consume_k(this.graphicState, stack, this.library, this.resources);
                    } else if (object.equals("g")) {
                        ContentParser.consume_g(this.graphicState, stack, this.library, this.resources);
                    } else if (object.equals("i")) {
                        ContentParser.consume_i(stack);
                    } else if (object.equals("M")) {
                        ContentParser.consume_M(this.graphicState, stack, shapes);
                    } else if (object.equals("J")) {
                        ContentParser.consume_J(this.graphicState, stack, shapes);
                    } else if (object.equals("rg")) {
                        ContentParser.consume_rg(this.graphicState, stack, this.library, this.resources);
                    } else if (object.equals("d")) {
                        ContentParser.consume_d(this.graphicState, stack, shapes);
                    } else if (object.equals("d")) {
                        ContentParser.consume_d(this.graphicState, stack, shapes);
                    } else if (object.equals("j")) {
                        ContentParser.consume_j(this.graphicState, stack, shapes);
                    } else if (object.equals("cs")) {
                        ContentParser.consume_cs(this.graphicState, stack, this.resources);
                    } else if (object.equals("ri")) {
                        stack.pop();
                    } else if (object.equals("SC") || object.equals("SCN")) {
                        ContentParser.consume_SC(this.graphicState, stack, this.library, this.resources);
                    } else if (object.equals("K")) {
                        ContentParser.consume_K(this.graphicState, stack, this.library, this.resources);
                    } else if (object.equals("G")) {
                        ContentParser.consume_G(this.graphicState, stack, this.library, this.resources);
                    } else if (object.equals("RG")) {
                        ContentParser.consume_RG(this.graphicState, stack, this.library, this.resources);
                    } else if (object.equals("CS")) {
                        ContentParser.consume_CS(this.graphicState, stack, this.resources);
                    } else if (object.equals("Tr")) {
                        this.graphicState.getTextState().rmode = (int)((Number)stack.pop()).floatValue();
                    } else if (object.equals("Tz")) {
                        ContentParser.consume_Tz(this.graphicState, stack);
                    } else if (object.equals("Ts")) {
                        this.graphicState.getTextState().trise = ((Number)stack.pop()).floatValue();
                    } else if (!object.equals("BX") && !object.equals("EX")) {
                        if (object.equals("'")) {
                            this.graphicState.translate(-f, this.graphicState.getTextState().leading);
                            ContentParser.applyTextScaling(this.graphicState);
                            f = 0.0f;
                            f2 = 0.0f;
                            float_.setLocation(0.0f, 0.0f);
                            StringObject stringObject = (StringObject)stack.pop();
                            object5 = this.graphicState.getTextState();
                            object4 = (Point2D.Float)this.drawString(stringObject.getLiteralStringBuffer(((TextState)object5).font.getSubTypeFormat(), ((TextState)object5).font.getFont()), new Point2D.Float(0.0f, 0.0f), 0.0f, 0.0f, this.graphicState.getTextState(), shapes, bl, vector);
                            this.graphicState.translate(((Point2D.Float)object4).x, 0.0);
                            f += ((Point2D.Float)object4).x;
                            if (bl) {
                                this.addExtractedText(vector, new StringBuffer("\n"));
                            }
                        } else if (object.equals("\"")) {
                            StringObject stringObject = (StringObject)stack.pop();
                            this.graphicState.getTextState().cspace = ((Number)stack.pop()).floatValue();
                            this.graphicState.getTextState().wspace = ((Number)stack.pop()).floatValue();
                            this.graphicState.translate(-f, this.graphicState.getTextState().leading);
                            ContentParser.applyTextScaling(this.graphicState);
                            f = 0.0f;
                            f2 = 0.0f;
                            float_.setLocation(0.0f, 0.0f);
                            object5 = this.graphicState.getTextState();
                            object4 = (Point2D.Float)this.drawString(stringObject.getLiteralStringBuffer(((TextState)object5).font.getSubTypeFormat(), ((TextState)object5).font.getFont()), new Point2D.Float(0.0f, 0.0f), 0.0f, 0.0f, this.graphicState.getTextState(), shapes, bl, vector);
                            this.graphicState.translate(((Point2D.Float)object4).x, 0.0);
                            f += ((Point2D.Float)object4).x;
                            if (bl) {
                                this.addExtractedText(vector, new StringBuffer("\n"));
                            }
                        }
                    }
                }
            } else {
                stack.push(object);
            }
            object = parser.getStreamObject();
        }
        if (bl) {
            this.addExtractedText(vector, new StringBuffer("\n\n"));
        }
        while (!stack.isEmpty()) {
            String string = stack.pop().toString();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.warning("Text=" + string);
        }
        this.graphicState.set(this.textBlockBase);
        this.inTextBlock = false;
    }

    void parseInlineImage(Parser parser, Shapes shapes) throws IOException {
        try {
            Object object;
            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
            Object object2 = parser.getStreamObject();
            while (!object2.equals("ID")) {
                if (object2.equals("BPC")) {
                    object2 = new Name("BitsPerComponent");
                } else if (object2.equals("CS")) {
                    object2 = new Name("ColorSpace");
                } else if (object2.equals("D")) {
                    object2 = new Name("Decode");
                } else if (object2.equals("DP")) {
                    object2 = new Name("DecodeParms");
                } else if (object2.equals("F")) {
                    object2 = new Name("Filter");
                } else if (object2.equals("H")) {
                    object2 = new Name("Height");
                } else if (object2.equals("IM")) {
                    object2 = new Name("ImageMask");
                } else if (object2.equals("I")) {
                    object2 = new Name("Indexed");
                } else if (object2.equals("W")) {
                    object2 = new Name("Width");
                }
                object = parser.getStreamObject();
                hashtable.put(object2, object);
                object2 = parser.getStreamObject();
            }
            object = new ByteArrayOutputStream(4096);
            object2 = parser.peek2();
            boolean bl = false;
            while (object2 != null && !object2.equals(" EI") && !(bl = parser.readLineForInlineImage((OutputStream)object))) {
                object2 = parser.peek2();
            }
            if (!bl) {
                parser.getToken();
            }
            ((OutputStream)object).flush();
            ((ByteArrayOutputStream)object).close();
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            SeekableByteArrayInputStream seekableByteArrayInputStream = new SeekableByteArrayInputStream(byArray);
            SeekableInputConstrainedWrapper seekableInputConstrainedWrapper = new SeekableInputConstrainedWrapper(seekableByteArrayInputStream, 0L, byArray.length, true);
            Stream stream = new Stream(this.library, hashtable, seekableInputConstrainedWrapper);
            BufferedImage bufferedImage = stream.getImage(this.graphicState.getFillColor(), this.resources, true);
            stream.dispose(false);
            AffineTransform affineTransform = new AffineTransform(this.graphicState.getCTM());
            this.graphicState.scale(1.0, -1.0);
            this.graphicState.translate(0.0, -1.0);
            shapes.add(bufferedImage);
            this.graphicState.set(affineTransform);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error parsing inline image.", exception);
        }
    }

    private static void consume_G(GraphicsState graphicsState, Stack stack, Library library, Resources resources) {
        float f = ((Number)stack.pop()).floatValue();
        graphicsState.setStrokeColorSpace(PColorSpace.getColorSpace(library, new Name("DeviceGray")));
        graphicsState.setStrokeColor(new Color(f, f, f));
    }

    private static void consume_g(GraphicsState graphicsState, Stack stack, Library library, Resources resources) {
        float f = ((Number)stack.pop()).floatValue();
        graphicsState.setFillColorSpace(PColorSpace.getColorSpace(library, new Name("DeviceGray")));
        graphicsState.setFillColor(new Color(f, f, f));
    }

    private static void consume_RG(GraphicsState graphicsState, Stack stack, Library library, Resources resources) {
        float f = ((Number)stack.pop()).floatValue();
        float f2 = ((Number)stack.pop()).floatValue();
        float f3 = ((Number)stack.pop()).floatValue();
        f = Math.max(0.0f, Math.min(1.0f, f));
        f2 = Math.max(0.0f, Math.min(1.0f, f2));
        f3 = Math.max(0.0f, Math.min(1.0f, f3));
        graphicsState.setStrokeColorSpace(PColorSpace.getColorSpace(library, new Name("DeviceRGB")));
        graphicsState.setStrokeColor(new Color(f3, f2, f));
    }

    private static void consume_rg(GraphicsState graphicsState, Stack stack, Library library, Resources resources) {
        float f = ((Number)stack.pop()).floatValue();
        float f2 = ((Number)stack.pop()).floatValue();
        float f3 = ((Number)stack.pop()).floatValue();
        f = Math.max(0.0f, Math.min(1.0f, f));
        f2 = Math.max(0.0f, Math.min(1.0f, f2));
        f3 = Math.max(0.0f, Math.min(1.0f, f3));
        graphicsState.setFillColorSpace(PColorSpace.getColorSpace(library, new Name("DeviceRGB")));
        graphicsState.setFillColor(new Color(f3, f2, f));
    }

    private static void consume_K(GraphicsState graphicsState, Stack stack, Library library, Resources resources) {
        float f = ((Number)stack.pop()).floatValue();
        float f2 = ((Number)stack.pop()).floatValue();
        float f3 = ((Number)stack.pop()).floatValue();
        float f4 = ((Number)stack.pop()).floatValue();
        PColorSpace pColorSpace = PColorSpace.getColorSpace(library, new Name("DeviceCMYK"));
        graphicsState.setStrokeColorSpace(pColorSpace);
        graphicsState.setStrokeColor(pColorSpace.getColor(PColorSpace.reverse(new float[]{f4, f3, f2, f})));
    }

    private static void consume_k(GraphicsState graphicsState, Stack stack, Library library, Resources resources) {
        float f = ((Number)stack.pop()).floatValue();
        float f2 = ((Number)stack.pop()).floatValue();
        float f3 = ((Number)stack.pop()).floatValue();
        float f4 = ((Number)stack.pop()).floatValue();
        PColorSpace pColorSpace = PColorSpace.getColorSpace(library, new Name("DeviceCMYK"));
        graphicsState.setFillColorSpace(pColorSpace);
        graphicsState.setFillColor(pColorSpace.getColor(PColorSpace.reverse(new float[]{f4, f3, f2, f})));
    }

    private static void consume_CS(GraphicsState graphicsState, Stack stack, Resources resources) {
        Name name = (Name)stack.pop();
        graphicsState.setStrokeColorSpace(resources.getColorSpace(name));
    }

    private static void consume_cs(GraphicsState graphicsState, Stack stack, Resources resources) {
        Name name = (Name)stack.pop();
        graphicsState.setFillColorSpace(resources.getColorSpace(name));
    }

    private static void consume_SC(GraphicsState graphicsState, Stack stack, Library library, Resources resources) {
        Object e = stack.peek();
        if (e instanceof Name) {
            Dictionary dictionary;
            Name name = (Name)stack.pop();
            Pattern pattern = resources.getPattern(name.toString());
            if (graphicsState.getStrokeColorSpace() instanceof PatternColor) {
                dictionary = (PatternColor)graphicsState.getStrokeColorSpace();
                ((PatternColor)dictionary).setPattern(pattern);
            } else {
                dictionary = new PatternColor(null, null);
                ((PatternColor)dictionary).setPattern(pattern);
                graphicsState.setStrokeColorSpace((PColorSpace)dictionary);
            }
            if (pattern instanceof TilingPattern && ((TilingPattern)(dictionary = (TilingPattern)pattern)).getPaintType() == 2) {
                int n = graphicsState.getStrokeColorSpace().getNumComponents();
                float[] fArray = new float[n];
                for (int i = 0; !stack.isEmpty() && stack.peek() instanceof Number && i < n; ++i) {
                    fArray[i] = ((Number)stack.pop()).floatValue();
                }
                ((TilingPattern)dictionary).setUnColored(graphicsState.getStrokeColorSpace().getColor(fArray));
            }
        } else if (e instanceof Number) {
            int n;
            int n2 = graphicsState.getStrokeColorSpace().getNumComponents();
            int n3 = 4;
            float[] fArray = new float[n3];
            for (n = 0; !stack.isEmpty() && stack.peek() instanceof Number && n < n3; ++n) {
                fArray[n] = ((Number)stack.pop()).floatValue();
            }
            if (n != n2) {
                graphicsState.setStrokeColorSpace(PColorSpace.getColorSpace(library, n));
            }
            float[] fArray2 = new float[n];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            graphicsState.setStrokeColor(graphicsState.getStrokeColorSpace().getColor(fArray2));
        }
    }

    private static void consume_sc(GraphicsState graphicsState, Stack stack, Library library, Resources resources) {
        Object e = stack.peek();
        if (e instanceof Name) {
            Dictionary dictionary;
            Name name = (Name)stack.pop();
            Pattern pattern = resources.getPattern(name.toString());
            if (graphicsState.getFillColorSpace() instanceof PatternColor) {
                dictionary = (PatternColor)graphicsState.getFillColorSpace();
                ((PatternColor)dictionary).setPattern(pattern);
            } else {
                dictionary = new PatternColor(library, null);
                ((PatternColor)dictionary).setPattern(pattern);
                graphicsState.setFillColorSpace((PColorSpace)dictionary);
            }
            if (pattern instanceof TilingPattern && ((TilingPattern)(dictionary = (TilingPattern)pattern)).getPaintType() == 2) {
                int n = graphicsState.getFillColorSpace().getNumComponents();
                float[] fArray = new float[n];
                for (int i = 0; !stack.isEmpty() && stack.peek() instanceof Number && i < n; ++i) {
                    fArray[i] = ((Number)stack.pop()).floatValue();
                }
                graphicsState.setFillColor(graphicsState.getFillColorSpace().getColor(fArray));
            }
        } else if (e instanceof Number) {
            int n;
            int n2 = graphicsState.getFillColorSpace().getNumComponents();
            int n3 = 4;
            float[] fArray = new float[n3];
            for (n = 0; !stack.isEmpty() && stack.peek() instanceof Number && n < n3; ++n) {
                fArray[n] = ((Number)stack.pop()).floatValue();
            }
            if (n != n2) {
                graphicsState.setFillColorSpace(PColorSpace.getColorSpace(library, n));
            }
            float[] fArray2 = new float[n];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            graphicsState.setFillColor(graphicsState.getFillColorSpace().getColor(fArray2));
        }
    }

    private static GraphicsState consume_q(GraphicsState graphicsState) {
        return graphicsState.save();
    }

    private static GraphicsState consume_Q(GraphicsState graphicsState, Shapes shapes) {
        GraphicsState graphicsState2 = graphicsState.restore();
        if (graphicsState2 != null) {
            graphicsState = graphicsState2;
        } else {
            graphicsState = new GraphicsState(shapes);
            graphicsState.set(new AffineTransform());
            shapes.addNoClipCommand();
        }
        return graphicsState;
    }

    private static void consume_cm(GraphicsState graphicsState, Stack stack, boolean bl, AffineTransform affineTransform) {
        float f = ((Number)stack.pop()).floatValue();
        float f2 = ((Number)stack.pop()).floatValue();
        float f3 = ((Number)stack.pop()).floatValue();
        float f4 = ((Number)stack.pop()).floatValue();
        float f5 = ((Number)stack.pop()).floatValue();
        float f6 = ((Number)stack.pop()).floatValue();
        if (!bl) {
            AffineTransform affineTransform2 = new AffineTransform(graphicsState.getCTM());
            affineTransform2.concatenate(new AffineTransform(f6, f5, f4, f3, f2, f));
            graphicsState.set(affineTransform2);
            graphicsState.updateClipCM(new AffineTransform(f6, f5, f4, f3, f2, f));
        } else {
            affineTransform.concatenate(new AffineTransform(f6, f5, f4, f3, f2, f));
        }
    }

    private static void consume_i(Stack stack) {
        stack.pop();
    }

    private static void consume_J(GraphicsState graphicsState, Stack stack, Shapes shapes) {
        graphicsState.setLineCap((int)((Number)stack.pop()).floatValue());
        if (graphicsState.getLineCap() == 0) {
            graphicsState.setLineCap(0);
        } else if (graphicsState.getLineCap() == 1) {
            graphicsState.setLineCap(1);
        } else if (graphicsState.getLineCap() == 2) {
            graphicsState.setLineCap(2);
        }
        ContentParser.setStroke(shapes, graphicsState);
    }

    private static void consume_d(GraphicsState graphicsState, Stack stack, Shapes shapes) {
        try {
            float[] fArray;
            float f = ((Number)stack.pop()).floatValue();
            Vector vector = (Vector)stack.pop();
            if (vector.size() > 0) {
                Enumeration enumeration = vector.elements();
                fArray = new float[vector.size()];
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    fArray[n++] = ((Number)enumeration.nextElement()).floatValue();
                }
            } else {
                f = 0.0f;
                fArray = null;
            }
            graphicsState.setDashArray(fArray);
            graphicsState.setDashPhase(f);
        }
        catch (ClassCastException classCastException) {
            logger.log(Level.FINE, "Dash pattern syntax error: ", classCastException);
        }
        ContentParser.setStroke(shapes, graphicsState);
    }

    private static void consume_j(GraphicsState graphicsState, Stack stack, Shapes shapes) {
        graphicsState.setLineJoin((int)((Number)stack.pop()).floatValue());
        if (graphicsState.getLineJoin() == 0) {
            graphicsState.setLineJoin(0);
        } else if (graphicsState.getLineJoin() == 1) {
            graphicsState.setLineJoin(1);
        } else if (graphicsState.getLineJoin() == 2) {
            graphicsState.setLineJoin(2);
        }
        ContentParser.setStroke(shapes, graphicsState);
    }

    private static void consume_w(GraphicsState graphicsState, Stack stack, Shapes shapes) {
        graphicsState.setLineWidth(((Number)stack.pop()).floatValue());
        ContentParser.setStroke(shapes, graphicsState);
    }

    private static void consume_M(GraphicsState graphicsState, Stack stack, Shapes shapes) {
        graphicsState.setMiterLimit(((Number)stack.pop()).floatValue());
        ContentParser.setStroke(shapes, graphicsState);
    }

    private static void consume_gs(GraphicsState graphicsState, Stack stack, Resources resources) {
        ExtGState extGState;
        Object e = stack.pop();
        if (e instanceof Name && (extGState = resources.getExtGState(((Name)e).getName())) != null) {
            graphicsState.concatenate(extGState);
        }
    }

    private static void consume_Tf(GraphicsState graphicsState, Stack stack, Resources resources) {
        float f = ((Number)stack.pop()).floatValue();
        Name name = (Name)stack.pop();
        graphicsState.getTextState().font = resources.getFont(name.getName());
        graphicsState.getTextState().currentfont = graphicsState.getTextState().font.getFont().deriveFont(f);
    }

    private static void consume_Tc(GraphicsState graphicsState, Stack stack) {
        graphicsState.getTextState().cspace = ((Number)stack.pop()).floatValue();
    }

    private static void consume_Tz(GraphicsState graphicsState, Stack stack) {
        Object e = stack.pop();
        if (e instanceof Number) {
            float f = ((Number)e).floatValue();
            graphicsState.getTextState().hScalling = f / 100.0f;
        }
    }

    private static void consume_Tw(GraphicsState graphicsState, Stack stack) {
        graphicsState.getTextState().wspace = ((Number)stack.pop()).floatValue();
    }

    private static void consume_Tr(GraphicsState graphicsState, Stack stack) {
        graphicsState.getTextState().rmode = (int)((Number)stack.pop()).floatValue();
    }

    private static void consume_TL(GraphicsState graphicsState, Stack stack) {
        graphicsState.getTextState().leading = ((Number)stack.pop()).floatValue();
    }

    private static void consume_Ts(GraphicsState graphicsState, Stack stack) {
        graphicsState.getTextState().trise = ((Number)stack.pop()).floatValue();
    }

    public void dispose(boolean bl) {
        this.graphicState = null;
        this.library = null;
        this.resources.dispose(bl);
    }

    private Point2D drawString(StringBuffer stringBuffer, Point2D point2D, float f, float f2, TextState textState, Shapes shapes, boolean bl, Vector vector) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
        float f3 = ((Point2D.Float)point2D).x;
        float f4 = ((Point2D.Float)point2D).y;
        if (stringBuffer.length() == 0) {
            return new Point2D.Float(0.0f, 0.0f);
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        char c = stringBuffer.charAt(0);
        float f7 = (float)textState.currentfont.echarAdvance(c).getX();
        if (f3 + f7 < f) {
            f3 = f;
        }
        FontFile fontFile = textState.currentfont;
        boolean bl2 = textState.font.isVerticalWriting();
        float f8 = textState.trise;
        float f9 = textState.cspace;
        float f10 = textState.wspace;
        int n2 = stringBuffer.length();
        TextSprite textSprite = new TextSprite(fontFile, n2);
        for (n = 0; n < n2; ++n) {
            char c2;
            float f11;
            float f12;
            float f13;
            c = stringBuffer.charAt(n);
            float f14 = f13 = (float)fontFile.echarAdvance(c).getX();
            if (!bl2) {
                f12 = f3 + f5;
                f11 = f6 - f8;
                f5 += f13;
                f5 += f9;
                if (stringBuffer.charAt(n) == ' ') {
                    f5 += f10;
                }
            } else {
                f12 = f3 - f13 / 2.0f;
                f11 = f4 + (f6 += f14 - f8);
            }
            textSprite.addText(c, f12, f11, f13);
            if (!bl) continue;
            boolean bl3 = textState.currentfont.getToUnicode() != null;
            char c3 = c2 = bl3 ? textState.currentfont.getToUnicode().toSelector(stringBuffer2.charAt(n)) : c;
            if (c2 <= '\u00ff') {
                this.addExtractedText(vector, new StringBuffer(String.valueOf(c2)));
                continue;
            }
            this.addExtractedText(vector, new StringBuffer("\\U" + Integer.toHexString(c2)));
        }
        f3 += f5;
        f4 += f6;
        n = textState.rmode;
        switch (n) {
            case 0: {
                this.drawModeFill(textSprite, shapes, n);
                break;
            }
            case 1: {
                this.drawModeStroke(textSprite, textState, shapes, n);
                break;
            }
            case 2: {
                this.drawModeFillStroke(textSprite, textState, shapes, n);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.drawModeFill(textSprite, shapes, n);
                break;
            }
            case 5: {
                this.drawModeStroke(textSprite, textState, shapes, n);
                break;
            }
            case 6: {
                this.drawModeFillStroke(textSprite, textState, shapes, n);
                break;
            }
            case 7: {
                textSprite.setRMode(n);
                shapes.add(textSprite);
            }
        }
        return new Point2D.Float(f3, f4);
    }

    private void drawModeFill(TextSprite textSprite, Shapes shapes, int n) {
        textSprite.setRMode(n);
        shapes.add(this.graphicState.getFillColor());
        shapes.add(textSprite);
    }

    private void drawModeStroke(TextSprite textSprite, TextState textState, Shapes shapes, int n) {
        textSprite.setRMode(n);
        textSprite.setStrokeColor(this.graphicState.getStrokeColor());
        float f = this.graphicState.getLineWidth();
        float f2 = this.graphicState.getLineWidth();
        f2 = (float)((double)f2 / textState.tmatrix.getScaleX());
        this.graphicState.setLineWidth(f2);
        ContentParser.setStroke(shapes, this.graphicState);
        shapes.add(this.graphicState.getStrokeColor());
        shapes.add(textSprite);
        this.graphicState.setLineWidth(f);
        ContentParser.setStroke(shapes, this.graphicState);
    }

    private void drawModeFillStroke(TextSprite textSprite, TextState textState, Shapes shapes, int n) {
        textSprite.setRMode(n);
        textSprite.setStrokeColor(this.graphicState.getStrokeColor());
        float f = this.graphicState.getLineWidth();
        float f2 = this.graphicState.getLineWidth();
        f2 = (float)((double)f2 / textState.tmatrix.getScaleX());
        this.graphicState.setLineWidth(f2);
        ContentParser.setStroke(shapes, this.graphicState);
        shapes.add(this.graphicState.getFillColor());
        shapes.add(textSprite);
        this.graphicState.setLineWidth(f);
        ContentParser.setStroke(shapes, this.graphicState);
    }

    private void commonStroke(Shapes shapes, GeneralPath generalPath) {
        if (this.graphicState.isOverprintStroking()) {
            this.setAlpha(shapes, this.commonOverPrintAlpha(this.graphicState.getStrokeAlpha()));
        }
        if (this.graphicState.getFillColorSpace() instanceof PatternColor) {
            PatternColor patternColor = (PatternColor)this.graphicState.getFillColorSpace();
            Pattern pattern = patternColor.getPattern();
            if (pattern != null && pattern.getPatternType() == 1) {
                TilingPattern tilingPattern = (TilingPattern)pattern;
                if (tilingPattern.getPaintType() == 2) {
                    this.setAlpha(shapes, this.graphicState.getFillAlpha());
                    shapes.add(tilingPattern.getUnColored());
                    shapes.add(generalPath);
                    shapes.addDrawCommand();
                } else if (tilingPattern.getPaintType() == 1) {
                    this.setAlpha(shapes, this.graphicState.getFillAlpha());
                    shapes.add(tilingPattern.getFirstColor());
                    shapes.add(generalPath);
                    shapes.addDrawCommand();
                }
            } else if (pattern != null && pattern.getPatternType() == 2) {
                pattern.init();
                this.setAlpha(shapes, this.graphicState.getFillAlpha());
                shapes.add(pattern.getPaint());
                shapes.add(generalPath);
                shapes.addDrawCommand();
            }
        } else {
            this.setAlpha(shapes, this.graphicState.getStrokeAlpha());
            shapes.add(this.graphicState.getStrokeColor());
            shapes.add(generalPath);
            shapes.addDrawCommand();
        }
        if (this.graphicState.isOverprintStroking()) {
            this.setAlpha(shapes, this.graphicState.getFillAlpha());
        }
    }

    private float commonOverPrintAlpha(float f) {
        if (f != 1.0f && f > 0.4f) {
            f -= 0.4f;
        } else if (!(f < 0.4f)) {
            f = 0.4f;
        }
        return f;
    }

    private void commonFill(Shapes shapes, GeneralPath generalPath) {
        if (this.graphicState.isOverprintOther()) {
            this.setAlpha(shapes, this.commonOverPrintAlpha(this.graphicState.getFillAlpha()));
        } else {
            this.setAlpha(shapes, this.graphicState.getFillAlpha());
        }
        if (this.graphicState.getFillColorSpace() instanceof PatternColor) {
            PatternColor patternColor = (PatternColor)this.graphicState.getFillColorSpace();
            Pattern pattern = patternColor.getPattern();
            if (pattern != null && pattern.getPatternType() == 1) {
                TilingPattern tilingPattern = (TilingPattern)pattern;
                if (tilingPattern.getPaintType() == 2) {
                    shapes.add(tilingPattern.getUnColored());
                    shapes.add(generalPath);
                    shapes.addFillCommand();
                } else if (tilingPattern.getPaintType() == 1) {
                    tilingPattern.init();
                    shapes.add(tilingPattern.getFirstColor());
                    shapes.add(generalPath);
                    shapes.addFillCommand();
                }
            } else if (pattern != null && pattern.getPatternType() == 2) {
                pattern.init();
                shapes.add(pattern.getPaint());
                shapes.add(generalPath);
                shapes.addFillCommand();
            }
        } else {
            shapes.add(this.graphicState.getFillColor());
            shapes.add(generalPath);
            shapes.addFillCommand();
        }
        if (this.graphicState.isOverprintOther()) {
            this.setAlpha(shapes, this.graphicState.getFillAlpha());
        }
    }

    static void setStroke(Shapes shapes, GraphicsState graphicsState) {
        shapes.add(new BasicStroke(graphicsState.getLineWidth(), graphicsState.getLineCap(), graphicsState.getLineJoin(), graphicsState.getMiterLimit(), graphicsState.getDashArray(), graphicsState.getDashPhase()));
    }

    private static void applyTextScaling(GraphicsState graphicsState) {
        AffineTransform affineTransform = new AffineTransform(graphicsState.getTextState().hScalling, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        AffineTransform affineTransform2 = new AffineTransform(graphicsState.getCTM());
        affineTransform2.concatenate(affineTransform);
        graphicsState.set(affineTransform2);
    }

    void setAlpha(Shapes shapes, float f) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        shapes.add(alphaComposite);
    }
}

