/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.InputStreamTokenizer;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Tokenizer;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.MapRow;
import net.sf.mpxj.primavera.PrimaveraReader;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.primavera.WbsRowComparator;
import net.sf.mpxj.reader.AbstractProjectReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimaveraXERFileReader
extends AbstractProjectReader {
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    boolean m_skipTable;
    private Map<String, List<Row>> m_tables;
    private String m_currentTableName;
    private List<Row> m_currentTable;
    private String[] m_currentFieldNames;
    private String m_defaultCurrencyName;
    private Map<String, DecimalFormat> m_currencyMap = new HashMap<String, DecimalFormat>();
    private DecimalFormat m_numberFormat;
    private Row m_defaultCurrencyData;
    private DateFormat m_df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final List<Row> EMPTY_TABLE = new LinkedList<Row>();
    private List<ProjectListener> m_projectListeners;
    private UserFieldCounters m_udfCounters = new UserFieldCounters();
    private Map<FieldType, String> m_resourceFields = PrimaveraReader.getDefaultResourceFieldMap();
    private Map<FieldType, String> m_wbsFields = PrimaveraReader.getDefaultWbsFieldMap();
    private Map<FieldType, String> m_taskFields = PrimaveraReader.getDefaultTaskFieldMap();
    private Map<FieldType, String> m_assignmentFields = PrimaveraReader.getDefaultAssignmentFieldMap();
    private Map<FieldType, String> m_aliases = PrimaveraReader.getDefaultAliases();
    private boolean m_matchPrimaveraWBS = true;
    private static final Map<String, XerRecordType> RECORD_TYPE_MAP = new HashMap<String, XerRecordType>();
    private static final Map<String, XerFieldType> FIELD_TYPE_MAP;
    private static final Set<String> REQUIRED_TABLES;
    private static final WbsRowComparator WBS_ROW_COMPARATOR;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public void setProjectID(int n) {
        this.m_projectID = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.m_numberFormat = new DecimalFormat();
            this.processFile(inputStream);
            this.m_reader = new PrimaveraReader(this.m_udfCounters, this.m_resourceFields, this.m_wbsFields, this.m_taskFields, this.m_assignmentFields, this.m_aliases, this.m_matchPrimaveraWBS);
            ProjectFile projectFile = this.m_reader.getProject();
            projectFile.getEventManager().addProjectListeners(this.m_projectListeners);
            this.processProjectID();
            this.processProjectProperties();
            this.processUserDefinedFields();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            projectFile.updateStructure();
            ProjectFile projectFile2 = projectFile;
            return projectFile2;
        }
        finally {
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        try {
            LinkedList<ProjectFile> linkedList = new LinkedList<ProjectFile>();
            this.m_tables = new HashMap<String, List<Row>>();
            this.m_numberFormat = new DecimalFormat();
            this.processFile(inputStream);
            List<Row> list = this.getRows("project", null, null);
            for (Row row : list) {
                this.setProjectID(row.getInt("proj_id"));
                this.m_reader = new PrimaveraReader(this.m_udfCounters, this.m_resourceFields, this.m_wbsFields, this.m_taskFields, this.m_assignmentFields, this.m_aliases, this.m_matchPrimaveraWBS);
                ProjectFile projectFile = this.m_reader.getProject();
                projectFile.getEventManager().addProjectListeners(this.m_projectListeners);
                this.processProjectProperties();
                this.processUserDefinedFields();
                this.processCalendars();
                this.processResources();
                this.processTasks();
                this.processPredecessors();
                this.processAssignments();
                this.m_reader = null;
                projectFile.updateStructure();
                linkedList.add(projectFile);
            }
            LinkedList<ProjectFile> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
        }
    }

    private void processFile(InputStream inputStream) throws MPXJException {
        int n = 1;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[6];
            byArray[0] = (byte)bufferedInputStream.read();
            bufferedInputStream.mark(1024);
            bufferedInputStream.read(byArray, 1, 5);
            if (!new String(byArray).equals("ERMHDR")) {
                throw new MPXJException("Invalid file format");
            }
            bufferedInputStream.reset();
            InputStreamTokenizer inputStreamTokenizer = new InputStreamTokenizer(bufferedInputStream);
            inputStreamTokenizer.setDelimiter('\t');
            ArrayList<String> arrayList = new ArrayList<String>();
            while (inputStreamTokenizer.getType() != -1) {
                this.readRecord(inputStreamTokenizer, arrayList);
                if (!this.processRecord(arrayList)) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new MPXJException("Error reading file (failed at line " + n + ")", exception);
        }
    }

    private void processProjectID() {
        List<Row> list;
        if (this.m_projectID == null && !(list = this.getRows("project", null, null)).isEmpty()) {
            Row row = list.get(0);
            this.m_projectID = row.getInteger("proj_id");
        }
    }

    private void processCurrency(Row row) {
        String string = row.getString("curr_short_name");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
        decimalFormatSymbols.setGroupingSeparator(row.getString("digit_group_symbol").charAt(0));
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.applyPattern("#.#");
        this.m_currencyMap.put(string, decimalFormat);
        if (string.equalsIgnoreCase(this.m_defaultCurrencyName)) {
            this.m_numberFormat = decimalFormat;
            this.m_defaultCurrencyData = row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> listProjects(InputStream inputStream) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.processFile(inputStream);
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            List<Row> list = this.getRows("project", null, null);
            for (Row row : list) {
                Integer n = row.getInteger("proj_id");
                String string = row.getString("proj_short_name");
                hashMap.put(n, string);
            }
            HashMap<Integer, String> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            this.m_tables = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
        }
    }

    private void processProjectProperties() {
        List<Row> list = this.getRows("project", "proj_id", this.m_projectID);
        this.m_reader.processProjectProperties(list);
        if (this.m_defaultCurrencyData != null) {
            this.m_reader.processDefaultCurrency(this.m_defaultCurrencyData);
        }
    }

    private void processUserDefinedFields() {
        List<Row> list = this.getRows("udftype", null, null);
        this.m_reader.processUserDefinedFields(list);
    }

    private void processCalendars() {
        List<Row> list = this.getRows("calendar", null, null);
        this.m_reader.processCalendars(list);
    }

    private void processResources() {
        List<Row> list = this.getRows("rsrc", null, null);
        this.m_reader.processResources(list);
    }

    private void processTasks() {
        List<Row> list = this.getRows("projwbs", "proj_id", this.m_projectID);
        List<Row> list2 = this.getRows("task", "proj_id", this.m_projectID);
        List<Row> list3 = this.getRows("projcost", "proj_id", this.m_projectID);
        List<Row> list4 = this.getRows("udfvalue", "proj_id", this.m_projectID);
        Collections.sort(list, WBS_ROW_COMPARATOR);
        this.m_reader.processTasks(list, list2, list3, list4);
    }

    private void processPredecessors() {
        List<Row> list = this.getRows("taskpred", "proj_id", this.m_projectID);
        this.m_reader.processPredecessors(list);
    }

    private void processAssignments() {
        List<Row> list = this.getRows("taskrsrc", "proj_id", this.m_projectID);
        this.m_reader.processAssignments(list);
    }

    private void readRecord(Tokenizer tokenizer, List<String> list) throws IOException {
        list.clear();
        while (tokenizer.nextToken() == -3) {
            list.add(tokenizer.getToken());
        }
    }

    private boolean processRecord(List<String> list) throws MPXJException {
        boolean bl = false;
        XerRecordType xerRecordType = RECORD_TYPE_MAP.get(list.get(0));
        if (xerRecordType == null) {
            throw new MPXJException("Invalid format");
        }
        switch (xerRecordType) {
            case HEADER: {
                this.processHeader(list);
                break;
            }
            case TABLE: {
                this.m_currentTableName = list.get(1).toLowerCase();
                boolean bl2 = this.m_skipTable = !REQUIRED_TABLES.contains(this.m_currentTableName);
                if (this.m_skipTable) {
                    this.m_currentTable = null;
                    break;
                }
                this.m_currentTable = new LinkedList<Row>();
                this.m_tables.put(this.m_currentTableName, this.m_currentTable);
                break;
            }
            case FIELDS: {
                if (this.m_skipTable) {
                    this.m_currentFieldNames = null;
                    break;
                }
                this.m_currentFieldNames = list.toArray(new String[list.size()]);
                for (int i = 0; i < this.m_currentFieldNames.length; ++i) {
                    this.m_currentFieldNames[i] = this.m_currentFieldNames[i].toLowerCase();
                }
                break;
            }
            case DATA: {
                if (this.m_skipTable) break;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (int i = 1; i < list.size(); ++i) {
                    Object object;
                    String string = this.m_currentFieldNames[i];
                    String string2 = list.get(i);
                    XerFieldType xerFieldType = FIELD_TYPE_MAP.get(string);
                    if (xerFieldType == null) {
                        xerFieldType = XerFieldType.STRING;
                    }
                    if (string2.length() == 0) {
                        object = null;
                    } else {
                        switch (xerFieldType) {
                            case DATE: {
                                try {
                                    object = this.m_df.parseObject(string2);
                                    break;
                                }
                                catch (ParseException parseException) {
                                    throw new MPXJException("Invalid date", parseException);
                                }
                            }
                            case CURRENCY: {
                                try {
                                    object = this.m_numberFormat.parse(string2).doubleValue();
                                    break;
                                }
                                catch (ParseException parseException) {
                                    throw new MPXJException("Invalid number or number format", parseException);
                                }
                            }
                            case DOUBLE: {
                                try {
                                    object = this.m_numberFormat.parse(string2).doubleValue();
                                    break;
                                }
                                catch (ParseException parseException) {
                                    throw new MPXJException("Invalid number or number format", parseException);
                                }
                            }
                            case DURATION: {
                                try {
                                    object = this.m_numberFormat.parse(string2).doubleValue();
                                    break;
                                }
                                catch (ParseException parseException) {
                                    throw new MPXJException("Invalid number or number format", parseException);
                                }
                            }
                            case INTEGER: {
                                object = Integer.valueOf(string2);
                                break;
                            }
                            default: {
                                object = string2;
                            }
                        }
                    }
                    hashMap.put(string, object);
                }
                MapRow mapRow = new MapRow(hashMap);
                this.m_currentTable.add(mapRow);
                if (!this.m_currentTableName.equals("currtype")) break;
                this.processCurrency(mapRow);
                break;
            }
            case END: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void processHeader(List<String> list) {
        this.m_defaultCurrencyName = list.size() > 8 ? list.get(8) : "USD";
    }

    public void setFieldNameForUdfType(UserFieldDataType userFieldDataType, String string) {
        this.m_udfCounters.setFieldNameForType(userFieldDataType, string);
    }

    public Map<FieldType, String> getResourceFieldMap() {
        return this.m_resourceFields;
    }

    public Map<FieldType, String> getWbsFieldMap() {
        return this.m_wbsFields;
    }

    public Map<FieldType, String> getTaskFieldMap() {
        return this.m_taskFields;
    }

    public Map<FieldType, String> getAssignmentFields() {
        return this.m_assignmentFields;
    }

    public Map<FieldType, String> getAliases() {
        return this.m_aliases;
    }

    private List<Row> getRows(String string, String string2, Integer n) {
        List<Row> list;
        List<Row> list2 = this.m_tables.get(string);
        if (list2 == null) {
            list = EMPTY_TABLE;
        } else if (string2 == null) {
            list = list2;
        } else {
            list = new LinkedList<Row>();
            for (Row row : list2) {
                if (!NumberHelper.equals(n, row.getInteger(string2))) continue;
                list.add(row);
            }
        }
        return list;
    }

    public boolean getMatchPrimaveraWBS() {
        return this.m_matchPrimaveraWBS;
    }

    public void setMatchPrimaveraWBS(boolean bl) {
        this.m_matchPrimaveraWBS = bl;
    }

    static {
        RECORD_TYPE_MAP.put("RMHDR", XerRecordType.HEADER);
        RECORD_TYPE_MAP.put("%T", XerRecordType.TABLE);
        RECORD_TYPE_MAP.put("%F", XerRecordType.FIELDS);
        RECORD_TYPE_MAP.put("%R", XerRecordType.DATA);
        RECORD_TYPE_MAP.put("%E", XerRecordType.END);
        FIELD_TYPE_MAP = new HashMap<String, XerFieldType>();
        FIELD_TYPE_MAP.put("proj_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("create_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("plan_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("plan_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("rsrc_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("create_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("wbs_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("orig_cost", XerFieldType.CURRENCY);
        FIELD_TYPE_MAP.put("indep_remain_total_cost", XerFieldType.CURRENCY);
        FIELD_TYPE_MAP.put("indep_remain_work_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("anticip_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("anticip_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("parent_wbs_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("task_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("phys_complete_pct", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("remain_drtn_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("act_work_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("remain_work_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("target_work_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("target_drtn_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("cstr_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("act_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("act_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("late_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("late_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("expect_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("early_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("early_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("target_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("target_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("restart_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("reend_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("create_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("pred_task_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("lag_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("remain_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("target_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("act_reg_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("target_cost", XerFieldType.CURRENCY);
        FIELD_TYPE_MAP.put("act_reg_cost", XerFieldType.CURRENCY);
        FIELD_TYPE_MAP.put("target_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("target_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("act_equip_qty", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("remain_equip_qty", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("clndr_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("default_flag", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("clndr_name", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("proj_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("base_clndr_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("last_chng_date", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("clndr_type", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("day_hr_cnt", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("week_hr_cnt", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("month_hr_cnt", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("year_hr_cnt", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("clndr_data", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("seq_num", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("taskrsrc_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("parent_rsrc_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("free_float_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("total_float_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("decimal_digit_cnt", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("target_qty_per_hr", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("target_lag_drtn_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("act_cost", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("target_cost", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("remain_cost", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("last_recalc_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("udf_type", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("table_name", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("udf_type_name", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("udf_type_label", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("loginal_data_type", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("super_flag", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("fk_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("udf_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("udf_number", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("udf_text", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("udf_code_id", XerFieldType.INTEGER);
        REQUIRED_TABLES = new HashSet<String>();
        REQUIRED_TABLES.add("project");
        REQUIRED_TABLES.add("calendar");
        REQUIRED_TABLES.add("rsrc");
        REQUIRED_TABLES.add("projwbs");
        REQUIRED_TABLES.add("task");
        REQUIRED_TABLES.add("taskpred");
        REQUIRED_TABLES.add("taskrsrc");
        REQUIRED_TABLES.add("currtype");
        REQUIRED_TABLES.add("udftype");
        REQUIRED_TABLES.add("udfvalue");
        REQUIRED_TABLES.add("projcost");
        WBS_ROW_COMPARATOR = new WbsRowComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum XerFieldType {
        STRING,
        INTEGER,
        DOUBLE,
        DATE,
        DURATION,
        CURRENCY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum XerRecordType {
        HEADER,
        TABLE,
        FIELDS,
        DATA,
        END;

    }
}

