/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.Locale;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintField;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.MPPAssignmentField;
import net.sf.mpxj.common.MPPAssignmentField14;
import net.sf.mpxj.common.MPPConstraintField;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPResourceField14;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.MPPTaskField14;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldTypeHelper {
    public static int getFieldID(FieldType fieldType) {
        int n;
        switch (fieldType.getFieldTypeClass()) {
            case TASK: {
                n = 0xB400000 | MPPTaskField.getID((TaskField)fieldType);
                break;
            }
            case RESOURCE: {
                n = 0xC400000 | MPPResourceField.getID((ResourceField)fieldType);
                break;
            }
            case ASSIGNMENT: {
                n = 0xF400000 | MPPAssignmentField.getID((AssignmentField)fieldType);
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public static final FieldType getInstance(int n) {
        FieldType fieldType;
        int n2 = n & 0xFFFF0000;
        int n3 = n & 0xFFFF;
        switch (n2) {
            case 0xB400000: {
                fieldType = MPPTaskField.getInstance(n3);
                if (fieldType != null) break;
                fieldType = FieldTypeHelper.getPlaceholder(TaskField.class, n3);
                break;
            }
            case 0xC400000: {
                fieldType = MPPResourceField.getInstance(n3);
                if (fieldType != null) break;
                fieldType = FieldTypeHelper.getPlaceholder(ResourceField.class, n3);
                break;
            }
            case 0xF400000: {
                fieldType = MPPAssignmentField.getInstance(n3);
                if (fieldType != null) break;
                fieldType = FieldTypeHelper.getPlaceholder(AssignmentField.class, n3);
                break;
            }
            case 0xD400000: {
                fieldType = MPPConstraintField.getInstance(n3);
                if (fieldType != null) break;
                fieldType = FieldTypeHelper.getPlaceholder(ConstraintField.class, n3);
                break;
            }
            default: {
                fieldType = FieldTypeHelper.getPlaceholder(null, n3);
            }
        }
        return fieldType;
    }

    public static final FieldType getInstance14(int n) {
        FieldType fieldType;
        int n2 = n & 0xFFFF0000;
        int n3 = n & 0xFFFF;
        switch (n2) {
            case 0xB400000: {
                fieldType = MPPTaskField14.getInstance(n3);
                if (fieldType != null) break;
                fieldType = FieldTypeHelper.getPlaceholder(TaskField.class, n3);
                break;
            }
            case 0xC400000: {
                fieldType = MPPResourceField14.getInstance(n3);
                if (fieldType != null) break;
                fieldType = FieldTypeHelper.getPlaceholder(ResourceField.class, n3);
                break;
            }
            case 0xF400000: {
                fieldType = MPPAssignmentField14.getInstance(n3);
                if (fieldType != null) break;
                fieldType = FieldTypeHelper.getPlaceholder(AssignmentField.class, n3);
                break;
            }
            case 0xD400000: {
                fieldType = MPPConstraintField.getInstance(n3);
                if (fieldType != null) break;
                fieldType = FieldTypeHelper.getPlaceholder(ConstraintField.class, n3);
                break;
            }
            default: {
                fieldType = FieldTypeHelper.getPlaceholder(null, n3);
            }
        }
        return fieldType;
    }

    private static FieldType getPlaceholder(final Class<?> clazz, final int n) {
        return new FieldType(){

            public FieldTypeClass getFieldTypeClass() {
                return FieldTypeClass.UNKNOWN;
            }

            public String name() {
                return null;
            }

            public int getValue() {
                return n;
            }

            public String getName() {
                return "Unknown " + (clazz == null ? "" : clazz.getSimpleName() + "(" + n + ")");
            }

            public String getName(Locale locale) {
                return this.getName();
            }

            public DataType getDataType() {
                return null;
            }

            public FieldType getUnitsType() {
                return null;
            }

            public String toString() {
                return this.getName();
            }
        };
    }

    public static FieldType mapTextFields(FieldType fieldType) {
        if (fieldType != null && fieldType.getFieldTypeClass() == FieldTypeClass.TASK) {
            TaskField taskField = (TaskField)fieldType;
            switch (taskField) {
                case START_TEXT: {
                    fieldType = TaskField.START;
                    break;
                }
                case FINISH_TEXT: {
                    fieldType = TaskField.FINISH;
                    break;
                }
                case DURATION_TEXT: {
                    fieldType = TaskField.DURATION;
                    break;
                }
            }
        }
        return fieldType;
    }
}

