/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.dependency;

import com.projity.association.AssociationList;
import com.projity.functor.CollectionVisitor;
import com.projity.pm.calendar.HasCalendar;
import com.projity.pm.dependency.HasDependencies;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Closure;

public class HasDependenciesImpl
implements HasDependencies,
Serializable {
    private HasCalendar hasCalendar;
    private transient AssociationList predecessors = new AssociationList();
    private transient AssociationList successors = new AssociationList();

    public HasDependenciesImpl(HasCalendar hasCalendar) {
        this.hasCalendar = hasCalendar;
    }

    public AssociationList getPredecessorList() {
        return this.predecessors;
    }

    public AssociationList getSuccessorList() {
        return this.successors;
    }

    public Closure forAllPredecessors(Closure closure) {
        return new CollectionVisitor(closure){

            protected final Collection getCollection(Object object) {
                return ((HasDependencies)object).getPredecessorList().getList();
            }
        };
    }

    public Closure forAllSuccesssors(Closure closure) {
        return new CollectionVisitor(closure){

            protected final Collection getCollection(Object object) {
                return ((HasDependencies)object).getSuccessorList().getList();
            }
        };
    }

    public HasCalendar getHasCalendar() {
        return this.hasCalendar;
    }

    public boolean dependsOn(HasDependencies hasDependencies) {
        System.out.println("error dependsOn should not be called on ScheduleWindowImpl");
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.predecessors = new AssociationList();
        this.successors = new AssociationList();
    }

    public AssociationList getDependencyList(boolean bl) {
        return bl ? this.predecessors : this.successors;
    }
}

