/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.timesheet;

import com.projity.datatype.Rate;
import com.projity.field.CanBeDirty;
import com.projity.field.FieldContext;
import com.projity.functor.IntervalConsumer;
import com.projity.graphic.configuration.HasCssStyle;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.AssignmentSpecificFields;
import com.projity.pm.assignment.TimeDistributedFields;
import com.projity.pm.assignment.timesheet.UpdatesFromTimesheet;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.scheduling.ScheduleInterval;
import com.projity.pm.task.HasNotes;
import com.projity.pm.task.Project;
import com.projity.util.DateTime;
import com.projity.util.MathUtils;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class TimesheetAssignment
implements Schedule,
AssignmentSpecificFields,
TimeDistributedFields,
UpdatesFromTimesheet,
HasCssStyle,
CanBeDirty,
Comparable,
HasNotes {
    Assignment assignment;
    String taskName;
    String projectName;
    long projectUniqueId;
    long taskUniqueId;
    long resourceUniqueId;
    boolean alreadyTimesheet = false;
    Collection parentsNames = null;
    transient boolean dirty = false;
    transient String description;
    private String notes;

    public final boolean isAlreadyTimesheet() {
        return this.alreadyTimesheet;
    }

    public final void setAlreadyTimesheet(boolean bl) {
        this.alreadyTimesheet = bl;
    }

    public final long getResourceUniqueId() {
        return this.resourceUniqueId;
    }

    public final long getTaskUniqueId() {
        return this.taskUniqueId;
    }

    public final Assignment getAssignment() {
        return this.assignment;
    }

    public final void setAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    public TimesheetAssignment(String string, String string2, long l, long l2, long l3, Assignment assignment, String string3) {
        this.projectName = string;
        this.taskName = string2;
        this.projectUniqueId = l;
        this.taskUniqueId = l2;
        this.resourceUniqueId = l3;
        this.assignment = assignment;
        this.notes = string3;
    }

    public long getDuration() {
        return this.assignment.getDuration();
    }

    public long getEnd() {
        return this.assignment.getEnd();
    }

    public long getStart() {
        return this.assignment.getStart();
    }

    public long getActualDuration() {
        return this.assignment.getActualDuration();
    }

    public long getActualFinish() {
        return this.assignment.getActualFinish();
    }

    public long getActualStart() {
        return this.assignment.getActualStart();
    }

    public double getPercentComplete() {
        return this.assignment.getPercentComplete();
    }

    public long getRemainingDuration() {
        return this.assignment.getRemainingDuration();
    }

    public long getResume() {
        return this.assignment.getResume();
    }

    public long getStop() {
        return this.assignment.getStop();
    }

    public final String getProjectName() {
        return this.projectName;
    }

    public final void setProjectName(String string) {
        this.projectName = string;
    }

    public final String getTaskName() {
        return this.taskName;
    }

    public final void setTaskName(String string) {
        this.taskName = string;
    }

    public TimesheetAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    public int getWorkContourType() {
        return this.assignment.getWorkContourType();
    }

    public void setWorkContourType(int n) {
    }

    public long getResourceAvailability() {
        return this.assignment.getResourceAvailability();
    }

    public String getTaskId() {
        return this.taskUniqueId + "";
    }

    public String getResourceName() {
        return null;
    }

    public String getResourceId() {
        return this.resourceUniqueId + "";
    }

    public Rate getRate() {
        return this.assignment.getRate();
    }

    public void setRate(Rate rate) {
        this.assignment.setRate(rate);
    }

    public double getCost(FieldContext fieldContext) {
        return this.assignment.getCost();
    }

    public long getWork(FieldContext fieldContext) {
        return this.assignment.getWork(fieldContext);
    }

    public void setWork(long l, FieldContext fieldContext) {
        this.assignment.setWork(l, fieldContext);
    }

    public boolean isReadOnlyWork(FieldContext fieldContext) {
        return false;
    }

    public double getActualCost(FieldContext fieldContext) {
        return this.assignment.getActualCost(fieldContext);
    }

    public long getActualWork(FieldContext fieldContext) {
        return this.assignment.getActualWork(fieldContext);
    }

    public void setActualWork(long l, FieldContext fieldContext) {
        this.assignment.setActualWork(l, fieldContext);
    }

    public boolean isReadOnlyActualWork(FieldContext fieldContext) {
        return false;
    }

    public long getRemainingWork(FieldContext fieldContext) {
        return this.assignment.getRemainingWork(fieldContext);
    }

    public void setRemainingWork(long l, FieldContext fieldContext) {
        this.assignment.setRemainingWork(l, fieldContext);
    }

    public boolean isReadOnlyRemainingWork(FieldContext fieldContext) {
        return false;
    }

    public double getBaselineCost(int n, FieldContext fieldContext) {
        return this.assignment.getBaselineCost(n, fieldContext);
    }

    public long getBaselineWork(int n, FieldContext fieldContext) {
        return this.assignment.getBaselineWork(n, fieldContext);
    }

    public boolean fieldHideCost(FieldContext fieldContext) {
        return false;
    }

    public boolean fieldHideWork(FieldContext fieldContext) {
        return false;
    }

    public boolean fieldHideBaselineCost(int n, FieldContext fieldContext) {
        return false;
    }

    public boolean fieldHideBaselineWork(int n, FieldContext fieldContext) {
        return false;
    }

    public boolean fieldHideActualCost(FieldContext fieldContext) {
        return false;
    }

    public boolean fieldHideActualWork(FieldContext fieldContext) {
        return false;
    }

    public double getFixedCost(FieldContext fieldContext) {
        return this.assignment.getFixedCost(fieldContext);
    }

    public void setFixedCost(double d, FieldContext fieldContext) {
        this.assignment.setFixedCost(d, fieldContext);
    }

    public boolean isReadOnlyFixedCost(FieldContext fieldContext) {
        return false;
    }

    public double getActualFixedCost(FieldContext fieldContext) {
        return this.assignment.getActualFixedCost(fieldContext);
    }

    public boolean fieldHideActualFixedCost(FieldContext fieldContext) {
        return false;
    }

    public double getRemainingCost(FieldContext fieldContext) {
        return this.assignment.getRemainingCost(fieldContext);
    }

    public void setActualStart(long l) {
        this.assignment.setActualStart(l);
    }

    public void setActualFinish(long l) {
        this.assignment.setActualFinish(l);
    }

    public void setActualDuration(long l) {
        this.assignment.setActualDuration(l);
    }

    public void setRemainingDuration(long l) {
        this.assignment.setRemainingDuration(l);
    }

    public void setPercentComplete(double d) {
        this.assignment.setPercentComplete(d);
    }

    public void setDuration(long l) {
        this.assignment.setDuration(l);
    }

    public long getElapsedDuration() {
        return this.assignment.getElapsedDuration();
    }

    public long getDependencyStart() {
        return this.assignment.getDependencyStart();
    }

    public void setDependencyStart(long l) {
        this.assignment.setDependencyStart(l);
    }

    public void setResume(long l) {
        this.assignment.setResume(l);
    }

    public void setStop(long l) {
        this.assignment.setStop(l);
    }

    public void clearDuration() {
        this.assignment.clearDuration();
    }

    public void moveRemainingToDate(long l) {
        this.assignment.moveRemainingToDate(l);
    }

    public void moveInterval(Object object, long l, long l2, ScheduleInterval scheduleInterval, boolean bl) {
        this.assignment.moveInterval(object, l, l2, scheduleInterval, bl);
    }

    public void consumeIntervals(IntervalConsumer intervalConsumer) {
        this.assignment.consumeIntervals(intervalConsumer);
    }

    public WorkCalendar getEffectiveWorkCalendar() {
        return this.assignment.getEffectiveWorkCalendar();
    }

    public void split(Object object, long l, long l2) {
        this.assignment.split(object, l, l2);
    }

    public boolean isJustModified() {
        return this.assignment.isJustModified();
    }

    public void setStart(long l) {
        this.assignment.setStart(l);
    }

    public void setEnd(long l) {
        this.assignment.setEnd(l);
    }

    public boolean isComplete() {
        return this.assignment.isComplete();
    }

    public void setComplete(boolean bl) {
        this.assignment.setComplete(bl);
    }

    public Project getProject() {
        return this.assignment.getOwningProject();
    }

    public long getTimesheetFinish() {
        return this.assignment.getTimesheetFinish();
    }

    public long getTimesheetStart() {
        return this.assignment.getTimesheetStart();
    }

    public long getLastTimesheetUpdate() {
        return this.assignment.getLastTimesheetUpdate();
    }

    public boolean applyTimesheet(Collection collection, long l) {
        return false;
    }

    public boolean isPendingTimesheetUpdate() {
        return this.assignment.isPendingTimesheetUpdate();
    }

    public int getTimesheetStatus() {
        return this.assignment.getTimesheetStatus();
    }

    public String getTimesheetStatusName() {
        return this.assignment.getTimesheetStatusName();
    }

    public String getCssStyleClass() {
        return this.getTimesheetStatusName();
    }

    public void setHierarchy(Collection collection) {
        this.parentsNames = collection;
    }

    public Collection getHierarchy() {
        return this.parentsNames;
    }

    public boolean isIntegratedOrComplete() {
        if (this.getTimesheetStatus() == 3) {
            return true;
        }
        if (this.getTimesheetStatus() == 2) {
            return false;
        }
        return this.isComplete();
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public long getCachedStart() {
        Date date = this.assignment.getCachedStart();
        if (date == null) {
            return 0L;
        }
        date = DateTime.fromGmt(date);
        return date.getTime();
    }

    public long getCachedEnd() {
        Date date = this.assignment.getCachedEnd();
        if (date == null) {
            return 0L;
        }
        return DateTime.gmt(date);
    }

    public int compareTo(Object object) {
        return MathUtils.signum(this.getCachedStart() - ((TimesheetAssignment)object).getCachedStart());
    }

    public long getReadOnlyDuration() {
        return this.getDuration();
    }

    public final long getEarliestStop() {
        return this.assignment.getEarliestStop();
    }

    public final long getCompletedThrough() {
        return this.assignment.getCompletedThrough();
    }

    public void setCompletedThrough(long l) {
        this.assignment.setCompletedThrough(l);
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public String toExternalId() {
        return this.taskUniqueId + "/" + this.resourceUniqueId;
    }

    public Object backupDetail() {
        return null;
    }

    public void restoreDetail(Object object, Object object2, boolean bl) {
    }

    public long getProjectUniqueId() {
        return this.projectUniqueId;
    }

    public void setProjectUniqueId(long l) {
        this.projectUniqueId = l;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
    }
}

